/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericTypeResolver {
    private static final Map<Class, Reference<Map<TypeVariable, Type>>> typeVariableCache = Collections.synchronizedMap(new WeakHashMap());

    public static Type getTargetType(MethodParameter methodParam) {
        Assert.notNull(methodParam, "MethodParameter must not be null");
        if (methodParam.getConstructor() != null) {
            return methodParam.getConstructor().getGenericParameterTypes()[methodParam.getParameterIndex()];
        }
        if (methodParam.getParameterIndex() >= 0) {
            return methodParam.getMethod().getGenericParameterTypes()[methodParam.getParameterIndex()];
        }
        return methodParam.getMethod().getGenericReturnType();
    }

    public static Class<?> resolveParameterType(MethodParameter methodParam, Class clazz) {
        Type genericType = GenericTypeResolver.getTargetType(methodParam);
        Assert.notNull(clazz, "Class must not be null");
        Map<TypeVariable, Type> typeVariableMap = GenericTypeResolver.getTypeVariableMap(clazz);
        Type rawType = GenericTypeResolver.getRawType(genericType, typeVariableMap);
        Class<?> result = rawType instanceof Class ? (Class<?>)rawType : methodParam.getParameterType();
        methodParam.setParameterType(result);
        methodParam.typeVariableMap = typeVariableMap;
        return result;
    }

    public static Class<?> resolveReturnType(Method method, Class clazz) {
        Assert.notNull(method, "Method must not be null");
        Type genericType = method.getGenericReturnType();
        Assert.notNull(clazz, "Class must not be null");
        Map<TypeVariable, Type> typeVariableMap = GenericTypeResolver.getTypeVariableMap(clazz);
        Type rawType = GenericTypeResolver.getRawType(genericType, typeVariableMap);
        return rawType instanceof Class ? (Class<?>)rawType : method.getReturnType();
    }

    public static Class<?> resolveTypeArgument(Class clazz, Class genericIfc) {
        Class[] typeArgs = GenericTypeResolver.resolveTypeArguments(clazz, genericIfc);
        if (typeArgs == null) {
            return null;
        }
        if (typeArgs.length != 1) {
            throw new IllegalArgumentException("Expected 1 type argument on generic interface [" + genericIfc.getName() + "] but found " + typeArgs.length);
        }
        return typeArgs[0];
    }

    public static Class[] resolveTypeArguments(Class clazz, Class genericIfc) {
        return GenericTypeResolver.doResolveTypeArguments(clazz, clazz, genericIfc);
    }

    private static Class[] doResolveTypeArguments(Class ownerClass, Class classToIntrospect, Class genericIfc) {
        while (classToIntrospect != null) {
            if (genericIfc.isInterface()) {
                Type[] ifcs;
                Type[] typeArray = ifcs = classToIntrospect.getGenericInterfaces();
                int n = ifcs.length;
                int n2 = 0;
                while (n2 < n) {
                    Type ifc = typeArray[n2];
                    Class[] result = GenericTypeResolver.doResolveTypeArguments(ownerClass, ifc, genericIfc);
                    if (result != null) {
                        return result;
                    }
                    ++n2;
                }
            } else {
                Class[] result = GenericTypeResolver.doResolveTypeArguments(ownerClass, classToIntrospect.getGenericSuperclass(), genericIfc);
                if (result != null) {
                    return result;
                }
            }
            classToIntrospect = classToIntrospect.getSuperclass();
        }
        return null;
    }

    private static Class[] doResolveTypeArguments(Class ownerClass, Type ifc, Class genericIfc) {
        if (ifc instanceof ParameterizedType) {
            ParameterizedType paramIfc = (ParameterizedType)ifc;
            Type rawType = paramIfc.getRawType();
            if (genericIfc.equals(rawType)) {
                Type[] typeArgs = paramIfc.getActualTypeArguments();
                Class[] result = new Class[typeArgs.length];
                int i = 0;
                while (i < typeArgs.length) {
                    Type arg = typeArgs[i];
                    result[i] = GenericTypeResolver.extractClass(ownerClass, arg);
                    ++i;
                }
                return result;
            }
            if (genericIfc.isAssignableFrom((Class)rawType)) {
                return GenericTypeResolver.doResolveTypeArguments(ownerClass, (Class)rawType, genericIfc);
            }
        } else if (genericIfc.isAssignableFrom((Class)ifc)) {
            return GenericTypeResolver.doResolveTypeArguments(ownerClass, (Class)ifc, genericIfc);
        }
        return null;
    }

    private static Class extractClass(Class ownerClass, Type arg) {
        if (arg instanceof ParameterizedType) {
            return GenericTypeResolver.extractClass(ownerClass, ((ParameterizedType)arg).getRawType());
        }
        if (arg instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)arg;
            Type gt = gat.getGenericComponentType();
            Class componentClass = GenericTypeResolver.extractClass(ownerClass, gt);
            return Array.newInstance(componentClass, 0).getClass();
        }
        if (arg instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)arg;
            arg = GenericTypeResolver.getTypeVariableMap(ownerClass).get(tv);
            arg = arg == null ? GenericTypeResolver.extractBoundForTypeVariable(tv) : GenericTypeResolver.extractClass(ownerClass, arg);
        }
        return arg instanceof Class ? (Class)arg : Object.class;
    }

    static Class resolveType(Type genericType, Map<TypeVariable, Type> typeVariableMap) {
        Type rawType = GenericTypeResolver.getRawType(genericType, typeVariableMap);
        return rawType instanceof Class ? (Class)rawType : Object.class;
    }

    static Type getRawType(Type genericType, Map<TypeVariable, Type> typeVariableMap) {
        TypeVariable tv;
        Type resolvedType = genericType;
        if (genericType instanceof TypeVariable && (resolvedType = typeVariableMap.get(tv = (TypeVariable)genericType)) == null) {
            resolvedType = GenericTypeResolver.extractBoundForTypeVariable(tv);
        }
        if (resolvedType instanceof ParameterizedType) {
            return ((ParameterizedType)resolvedType).getRawType();
        }
        return resolvedType;
    }

    static Map<TypeVariable, Type> getTypeVariableMap(Class clazz) {
        Map<TypeVariable, Type> typeVariableMap;
        Reference<Map<TypeVariable, Type>> ref = typeVariableCache.get(clazz);
        Map<TypeVariable, Type> map = typeVariableMap = ref != null ? ref.get() : null;
        if (typeVariableMap == null) {
            ParameterizedType pt;
            typeVariableMap = new HashMap<TypeVariable, Type>();
            GenericTypeResolver.extractTypeVariablesFromGenericInterfaces(clazz.getGenericInterfaces(), typeVariableMap);
            Type genericType = clazz.getGenericSuperclass();
            Class<?> type = clazz.getSuperclass();
            while (type != null && !Object.class.equals((Object)type)) {
                if (genericType instanceof ParameterizedType) {
                    pt = (ParameterizedType)genericType;
                    GenericTypeResolver.populateTypeMapFromParameterizedType(pt, typeVariableMap);
                }
                GenericTypeResolver.extractTypeVariablesFromGenericInterfaces(type.getGenericInterfaces(), typeVariableMap);
                genericType = type.getGenericSuperclass();
                type = type.getSuperclass();
            }
            type = clazz;
            while (type.isMemberClass()) {
                genericType = type.getGenericSuperclass();
                if (genericType instanceof ParameterizedType) {
                    pt = (ParameterizedType)genericType;
                    GenericTypeResolver.populateTypeMapFromParameterizedType(pt, typeVariableMap);
                }
                type = type.getEnclosingClass();
            }
            typeVariableCache.put(clazz, new WeakReference<Map<TypeVariable, Type>>(typeVariableMap));
        }
        return typeVariableMap;
    }

    static Type extractBoundForTypeVariable(TypeVariable typeVariable) {
        Type[] bounds = typeVariable.getBounds();
        if (bounds.length == 0) {
            return Object.class;
        }
        Type bound = bounds[0];
        if (bound instanceof TypeVariable) {
            bound = GenericTypeResolver.extractBoundForTypeVariable((TypeVariable)bound);
        }
        return bound;
    }

    private static void extractTypeVariablesFromGenericInterfaces(Type[] genericInterfaces, Map<TypeVariable, Type> typeVariableMap) {
        Type[] typeArray = genericInterfaces;
        int n = genericInterfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Type genericInterface = typeArray[n2];
            if (genericInterface instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericInterface;
                GenericTypeResolver.populateTypeMapFromParameterizedType(pt, typeVariableMap);
                if (pt.getRawType() instanceof Class) {
                    GenericTypeResolver.extractTypeVariablesFromGenericInterfaces(((Class)pt.getRawType()).getGenericInterfaces(), typeVariableMap);
                }
            } else if (genericInterface instanceof Class) {
                GenericTypeResolver.extractTypeVariablesFromGenericInterfaces(((Class)genericInterface).getGenericInterfaces(), typeVariableMap);
            }
            ++n2;
        }
    }

    private static void populateTypeMapFromParameterizedType(ParameterizedType type, Map<TypeVariable, Type> typeVariableMap) {
        if (type.getRawType() instanceof Class) {
            Type[] actualTypeArguments = type.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeVariables = ((Class)type.getRawType()).getTypeParameters();
            int i = 0;
            while (i < actualTypeArguments.length) {
                Type actualTypeArgument = actualTypeArguments[i];
                TypeVariable variable = typeVariables[i];
                if (actualTypeArgument instanceof Class) {
                    typeVariableMap.put(variable, actualTypeArgument);
                } else if (actualTypeArgument instanceof GenericArrayType) {
                    typeVariableMap.put(variable, actualTypeArgument);
                } else if (actualTypeArgument instanceof ParameterizedType) {
                    typeVariableMap.put(variable, actualTypeArgument);
                } else if (actualTypeArgument instanceof TypeVariable) {
                    TypeVariable typeVariableArgument = (TypeVariable)actualTypeArgument;
                    Type resolvedType = typeVariableMap.get(typeVariableArgument);
                    if (resolvedType == null) {
                        resolvedType = GenericTypeResolver.extractBoundForTypeVariable(typeVariableArgument);
                    }
                    typeVariableMap.put(variable, resolvedType);
                }
                ++i;
            }
        }
    }
}

