/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.importer.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.osgi.context.BundleContextAware;
import org.springframework.osgi.service.importer.OsgiServiceLifecycleListener;
import org.springframework.osgi.service.importer.support.Cardinality;
import org.springframework.osgi.service.importer.support.ImportContextClassLoader;
import org.springframework.osgi.util.OsgiFilterUtils;
import org.springframework.osgi.util.internal.ClassUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class AbstractOsgiServiceImportFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean,
BundleContextAware,
BeanClassLoaderAware,
BeanNameAware {
    private static final Log log = LogFactory.getLog((Class)AbstractOsgiServiceImportFactoryBean.class);
    private ClassLoader classLoader;
    private BundleContext bundleContext;
    private ImportContextClassLoader contextClassLoader = ImportContextClassLoader.CLIENT;
    private Class[] interfaces;
    private String filter;
    private Filter unifiedFilter;
    private OsgiServiceLifecycleListener[] listeners;
    private String serviceBeanName;
    private Cardinality cardinality;
    private String beanName = "";

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.bundleContext, (String)"Required 'bundleContext' property was not set.");
        Assert.notNull((Object)this.classLoader, (String)"Required 'classLoader' property was not set.");
        Assert.notEmpty((Object[])this.interfaces, (String)"Required 'interfaces' property was not set.");
        Assert.noNullElements((Object[])this.interfaces, (String)"Null 'interfaces' entries not allowed.");
        Assert.isTrue((!ClassUtils.containsUnrelatedClasses(this.interfaces) ? 1 : 0) != 0, (String)"more then one concrete class specified; cannot create proxy.");
        this.listeners = this.listeners == null ? new OsgiServiceLifecycleListener[]{} : this.listeners;
        this.getUnifiedFilter();
    }

    public Filter getUnifiedFilter() {
        if (this.unifiedFilter != null) {
            return this.unifiedFilter;
        }
        String filterWithClasses = OsgiFilterUtils.unifyFilter(this.interfaces, this.filter);
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("Unified classes=" + ObjectUtils.nullSafeToString((Object[])this.interfaces) + " and filter=[" + this.filter + "]  in=[" + filterWithClasses + "]"));
        }
        String filterWithServiceBeanName = OsgiFilterUtils.unifyFilter("org.springframework.osgi.bean.name", new String[]{this.serviceBeanName}, filterWithClasses);
        if (trace) {
            log.trace((Object)("Unified serviceBeanName [" + ObjectUtils.nullSafeToString((Object)this.serviceBeanName) + "] and filter=[" + filterWithClasses + "]  in=[" + filterWithServiceBeanName + "]"));
        }
        this.unifiedFilter = OsgiFilterUtils.createFilter(filterWithServiceBeanName);
        return this.unifiedFilter;
    }

    public void setInterfaces(Class[] interfaces) {
        this.interfaces = interfaces;
    }

    public void setContextClassLoader(ImportContextClassLoader contextClassLoader) {
        Assert.notNull((Object)((Object)contextClassLoader));
        this.contextClassLoader = contextClassLoader;
    }

    public void setBundleContext(BundleContext context) {
        this.bundleContext = context;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setListeners(OsgiServiceLifecycleListener[] listeners) {
        this.listeners = listeners;
    }

    public void setServiceBeanName(String serviceBeanName) {
        this.serviceBeanName = serviceBeanName;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getBeanClassLoader() {
        return this.classLoader;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public Class[] getInterfaces() {
        return this.interfaces;
    }

    public String getFilter() {
        return this.filter;
    }

    public OsgiServiceLifecycleListener[] getListeners() {
        return this.listeners;
    }

    public ImportContextClassLoader getContextClassLoader() {
        return this.contextClassLoader;
    }

    public Cardinality getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(Cardinality cardinality) {
        Assert.notNull((Object)((Object)cardinality));
        this.cardinality = cardinality;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }
}

