/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.services.concurrent;

import org.eclipse.virgo.nano.shim.serviceability.TracingService;

final class ExecutorServiceDelegate {
    private final ApplicationNameAccessor accessor;
    private final Object monitor = new Object();
    private long totalExecutionTime;

    public ExecutorServiceDelegate(TracingService tracingService) {
        this.accessor = new ApplicationNameAccessor(tracingService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAverageExecutionTime(long completedTaskCount) {
        Object object = this.monitor;
        synchronized (object) {
            return completedTaskCount == 0L ? this.totalExecutionTime : this.totalExecutionTime / completedTaskCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getExecutionTime() {
        Object object = this.monitor;
        synchronized (object) {
            return this.totalExecutionTime;
        }
    }

    public Runnable decorate(Runnable delegate) {
        return new KernelRunnable(delegate);
    }

    private static class ApplicationNameAccessor {
        private final TracingService tracingService;

        public ApplicationNameAccessor(TracingService tracingService) {
            this.tracingService = tracingService;
        }

        public String getCurrentApplicationName() {
            return this.tracingService.getCurrentApplicationName();
        }

        public void setCurrentApplicationName(String applicationName) {
            this.tracingService.setCurrentApplicationName(applicationName);
        }
    }

    private class KernelRunnable
    implements Runnable {
        private final Runnable delegate;
        private final String applicationName;

        public KernelRunnable(Runnable delegate) {
            this.delegate = delegate;
            this.applicationName = ExecutorServiceDelegate.this.accessor.getCurrentApplicationName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long timeBefore = System.currentTimeMillis();
            ExecutorServiceDelegate.this.accessor.setCurrentApplicationName(this.applicationName);
            try {
                this.delegate.run();
            }
            catch (Throwable throwable) {
                ExecutorServiceDelegate.this.accessor.setCurrentApplicationName(null);
                ExecutorServiceDelegate outer = ExecutorServiceDelegate.this;
                long time = System.currentTimeMillis() - timeBefore;
                Object object = outer.monitor;
                synchronized (object) {
                    ExecutorServiceDelegate executorServiceDelegate = outer;
                    executorServiceDelegate.totalExecutionTime = executorServiceDelegate.totalExecutionTime + time;
                }
                throw throwable;
            }
            ExecutorServiceDelegate.this.accessor.setCurrentApplicationName(null);
            ExecutorServiceDelegate outer = ExecutorServiceDelegate.this;
            long time = System.currentTimeMillis() - timeBefore;
            Object object = outer.monitor;
            synchronized (object) {
                ExecutorServiceDelegate executorServiceDelegate = outer;
                executorServiceDelegate.totalExecutionTime = executorServiceDelegate.totalExecutionTime + time;
            }
        }
    }
}

