/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.context;

import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;

public class PortletContextAwareProcessor
implements BeanPostProcessor {
    private PortletContext portletContext;
    private PortletConfig portletConfig;

    public PortletContextAwareProcessor(PortletContext portletContext) {
        this(portletContext, null);
    }

    public PortletContextAwareProcessor(PortletConfig portletConfig) {
        this(null, portletConfig);
    }

    public PortletContextAwareProcessor(PortletContext portletContext, PortletConfig portletConfig) {
        this.portletContext = portletContext;
        this.portletConfig = portletConfig;
        if (portletContext == null && portletConfig != null) {
            this.portletContext = portletConfig.getPortletContext();
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (this.portletContext != null && bean instanceof PortletContextAware) {
            ((PortletContextAware)bean).setPortletContext(this.portletContext);
        }
        if (this.portletConfig != null && bean instanceof PortletConfigAware) {
            ((PortletConfigAware)bean).setPortletConfig(this.portletConfig);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        return bean;
    }
}

