/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.web.failover;

import java.io.Serializable;
import java.util.Map;
import javax.enterprise.context.Conversation;
import javax.servlet.http.HttpSession;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.ConversationContext;
import org.apache.webbeans.context.SessionContext;
import org.apache.webbeans.conversation.ConversationManager;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.spi.FailOverService;
import org.apache.webbeans.web.context.SessionContextManager;
import org.apache.webbeans.web.context.WebContextsService;

public class FailOverBag
implements Serializable {
    private static final long serialVersionUID = -6314819837009653189L;
    protected final WebBeansLogger logger = WebBeansLogger.getLogger(FailOverBag.class);
    private String sessionId;
    private String owbFailoverJVMId;
    private SessionContext sessionContext;
    private Map<Conversation, ConversationContext> conversationContextMap;
    private transient WebBeansContext webBeansContext = WebBeansContext.getInstance();

    public FailOverBag() {
    }

    public FailOverBag(HttpSession session, FailOverService service) {
        this.sessionId = session.getId();
        this.owbFailoverJVMId = service.getJVMId();
        this.updateOwbFailOverBag(session, service);
    }

    public void updateOwbFailOverBag(HttpSession session, FailOverService service) {
        SessionContextManager sessionManager = ((WebContextsService)this.webBeansContext.getContextsService()).getSessionContextManager();
        this.sessionContext = sessionManager.getSessionContextWithSessionId(session.getId());
        ConversationManager conversationManager = this.webBeansContext.getConversationManager();
        this.conversationContextMap = conversationManager.getConversationMapWithSessionId(session.getId());
    }

    public void restore() {
        try {
            this.webBeansContext = WebBeansContext.getInstance();
            if (this.sessionContext != null) {
                SessionContextManager sessionManager = ((WebContextsService)this.webBeansContext.getContextsService()).getSessionContextManager();
                sessionManager.addNewSessionContext(this.sessionId, this.sessionContext);
                this.sessionContext.setActive(true);
            }
            if (this.conversationContextMap != null && !this.conversationContextMap.isEmpty()) {
                ConversationManager conversationManager = this.webBeansContext.getConversationManager();
                for (Conversation c : this.conversationContextMap.keySet()) {
                    ConversationContext cc = this.conversationContextMap.get(c);
                    conversationManager.addConversationContext(c, cc);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
        }
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getJVMId() {
        return this.owbFailoverJVMId;
    }
}

