/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.util.Iterator;
import org.eclipse.dali.orm.Inheritance;
import org.eclipse.dali.orm.OrmFactory;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.PrimaryKeyJoinColumn;
import org.eclipse.dali.orm.adapters.IInheritanceModelAdapter;
import org.eclipse.dali.orm.adapters.IPrimaryKeyJoinColumnModelAdapter;
import org.eclipse.dali.orm.provider.InheritanceItemProvider;
import org.eclipse.dali.orm.provider.OrmItemProviderAdapterFactory;
import org.eclipse.dali.orm.provider.PrimaryKeyJoinColumnItemProvider;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.dali.ui.views.PrimaryKeyJoinColumnDialog;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class PrimaryKeyJoinColumnsComposite
extends Composite
implements IPersistenceComposite {
    protected boolean populating;
    private Inheritance inheritance;
    private ListViewer pkJoinColumnsListViewer;
    private PrimaryKeyJoinColumnItemProvider pkJoinColumnItemProvider;
    private InheritanceItemProvider inheritanceItemProvider;
    private INotifyChangedListener pkJoinColumnListener;
    private INotifyChangedListener inheritanceListener;
    private Group pkJoinColumnsGroup;
    private Button overrideDefaultJoinColumnsCheckBox;
    private Button pkJoinColumnsRemoveButton;
    private Button pkJoinColumnsEditButton;
    protected EditingDomain editingDomain;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public PrimaryKeyJoinColumnsComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.pkJoinColumnItemProvider = (PrimaryKeyJoinColumnItemProvider)adapterFactory.createPrimaryKeyJoinColumnAdapter();
        this.inheritanceItemProvider = (InheritanceItemProvider)adapterFactory.createInheritanceAdapter();
        this.initializeLayout();
    }

    private void initializeLayout() {
        this.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData();
        this.overrideDefaultJoinColumnsCheckBox = new Button((Composite)this, 32);
        this.overrideDefaultJoinColumnsCheckBox.setText(DaliUiMessages.PrimaryKeyJoinColumnsComposite_overrideDefaultPrimaryKeyJoinColumns);
        this.overrideDefaultJoinColumnsCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PrimaryKeyJoinColumnsComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)PrimaryKeyJoinColumnsComposite.this.editingDomain, (Object)PrimaryKeyJoinColumnsComposite.this.inheritance, (Object)OrmPackage.eINSTANCE.getInheritance_DefaultPrimaryKeyJoinColumns(), (Object)(!PrimaryKeyJoinColumnsComposite.this.overrideDefaultJoinColumnsCheckBox.getSelection() ? 1 : 0)));
            }
        });
        this.pkJoinColumnsGroup = new Group((Composite)this, 16);
        this.pkJoinColumnsGroup.setText(DaliUiMessages.PrimaryKeyJoinColumnsComposite_primaryKeyJoinColumn);
        this.pkJoinColumnsGroup.setLayout((Layout)new GridLayout(2, false));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        this.pkJoinColumnsGroup.setLayoutData((Object)gridData);
        this.pkJoinColumnsListViewer = new ListViewer((Composite)this.pkJoinColumnsGroup, 2050);
        this.pkJoinColumnsListViewer.setContentProvider(this.buildJoinColumnsListContentProvider());
        this.pkJoinColumnsListViewer.setLabelProvider((IBaseLabelProvider)this.buildJoinColumnsListLabelProvider());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.verticalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.pkJoinColumnsListViewer.getList().setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.pkJoinColumnsListViewer.getList(), "org.eclipse.dali.ui.mapping_joinTableJoinColumns");
        Button addJoinColumnButton = new Button((Composite)this.pkJoinColumnsGroup, 0);
        addJoinColumnButton.setText(DaliUiMessages.PrimaryKeyJoinColumnsComposite_add);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        addJoinColumnButton.setLayoutData((Object)gridData);
        addJoinColumnButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PrimaryKeyJoinColumnsComposite.this.addPrimaryKeyJoinColumn();
            }
        });
        this.pkJoinColumnsEditButton = new Button((Composite)this.pkJoinColumnsGroup, 0);
        this.pkJoinColumnsEditButton.setText(DaliUiMessages.PrimaryKeyJoinColumnsComposite_edit);
        this.pkJoinColumnsEditButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PrimaryKeyJoinColumnsComposite.this.editPrimaryKeyJoinColumn();
            }
        });
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.pkJoinColumnsEditButton.setLayoutData((Object)gridData);
        this.pkJoinColumnsRemoveButton = new Button((Composite)this.pkJoinColumnsGroup, 0);
        this.pkJoinColumnsRemoveButton.setText(DaliUiMessages.PrimaryKeyJoinColumnsComposite_remove);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        this.pkJoinColumnsRemoveButton.setLayoutData((Object)gridData);
        this.pkJoinColumnsRemoveButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PrimaryKeyJoinColumnsComposite.this.removePrimaryKeyJoinColumn();
            }
        });
        this.pkJoinColumnsListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PrimaryKeyJoinColumnsComposite.this.updatePrimaryKeyJoinColumnsEnablement();
            }
        });
    }

    private IContentProvider buildJoinColumnsListContentProvider() {
        return new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((Inheritance)inputElement).getPrimaryKeyJoinColumns().toArray();
            }
        };
    }

    private ILabelProvider buildJoinColumnsListLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                PrimaryKeyJoinColumn joinColumn = (PrimaryKeyJoinColumn)element;
                if (PrimaryKeyJoinColumnsComposite.this.inheritance.isDefaultPrimaryKeyJoinColumns()) {
                    return PrimaryKeyJoinColumnsComposite.this.buildDefaultJoinColumnLabel(joinColumn);
                }
                return PrimaryKeyJoinColumnsComposite.this.buildJoinColumnLabel(joinColumn);
            }
        };
    }

    private String buildDefaultJoinColumnLabel(PrimaryKeyJoinColumn joinColumn) {
        return NLS.bind((String)DaliUiMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParamsDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
    }

    private String buildJoinColumnLabel(PrimaryKeyJoinColumn joinColumn) {
        if (joinColumn.getSpecifiedName() == null) {
            if (joinColumn.getSpecifiedReferencedColumnName() == null) {
                return NLS.bind((String)DaliUiMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParamsBothDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
            }
            return NLS.bind((String)DaliUiMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParamsFirstDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        if (joinColumn.getSpecifiedReferencedColumnName() == null) {
            return NLS.bind((String)DaliUiMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParamsSecDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        return NLS.bind((String)DaliUiMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParams, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
    }

    private void addPrimaryKeyJoinColumn() {
        PrimaryKeyJoinColumnDialog dialog = new PrimaryKeyJoinColumnDialog(this.getShell(), this.inheritance);
        this.addJoinColumnFromDialog(dialog);
    }

    private void addJoinColumnFromDialog(PrimaryKeyJoinColumnDialog dialog) {
        if (dialog.open() == 0) {
            IPrimaryKeyJoinColumnModelAdapter columnModelAdapter = ((IInheritanceModelAdapter)this.inheritance.getModelAdapter()).createPrimaryKeyJoinColumnModelAdapter();
            String name = dialog.getSelectedName();
            String referencedColumnName = dialog.getReferencedColumnName();
            PrimaryKeyJoinColumn joinColumn = OrmFactory.eINSTANCE.createPrimaryKeyJoinColumn(columnModelAdapter);
            this.editingDomain.getCommandStack().execute(AddCommand.create((EditingDomain)this.editingDomain, (Object)this.inheritance, (Object)OrmPackage.eINSTANCE.getInheritance_PrimaryKeyJoinColumns(), (Object)joinColumn));
            this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)joinColumn, (Object)OrmPackage.eINSTANCE.getAbstractJoinColumn_SpecifiedName(), (Object)name));
            this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)joinColumn, (Object)OrmPackage.eINSTANCE.getAbstractJoinColumn_SpecifiedReferencedColumnName(), (Object)referencedColumnName));
        }
    }

    private PrimaryKeyJoinColumn getSelectedJoinColumn() {
        return (PrimaryKeyJoinColumn)((StructuredSelection)this.pkJoinColumnsListViewer.getSelection()).getFirstElement();
    }

    private void editPrimaryKeyJoinColumn() {
        PrimaryKeyJoinColumn joinColumn = this.getSelectedJoinColumn();
        PrimaryKeyJoinColumnDialog dialog = new PrimaryKeyJoinColumnDialog(this.getShell(), joinColumn);
        this.editJoinColumnFromDialog(dialog, joinColumn);
    }

    private void editJoinColumnFromDialog(PrimaryKeyJoinColumnDialog dialog, PrimaryKeyJoinColumn joinColumn) {
        if (dialog.open() == 0) {
            this.editJoinColumnDialogOkd(dialog, joinColumn);
        }
    }

    private void editJoinColumnDialogOkd(PrimaryKeyJoinColumnDialog dialog, PrimaryKeyJoinColumn joinColumn) {
        String name = dialog.getSelectedName();
        String referencedColumnName = dialog.getReferencedColumnName();
        if (dialog.isDefaultNameSelected()) {
            if (joinColumn.getSpecifiedName() != null) {
                this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)joinColumn, (Object)OrmPackage.eINSTANCE.getAbstractJoinColumn_SpecifiedName(), null));
            }
        } else if (joinColumn.getSpecifiedName() == null || !joinColumn.getSpecifiedName().equals(name)) {
            this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)joinColumn, (Object)OrmPackage.eINSTANCE.getAbstractJoinColumn_SpecifiedName(), (Object)name));
        }
        if (dialog.isDefaultReferencedColumnNameSelected()) {
            if (joinColumn.getSpecifiedReferencedColumnName() != null) {
                this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)joinColumn, (Object)OrmPackage.eINSTANCE.getAbstractJoinColumn_SpecifiedReferencedColumnName(), null));
            }
        } else if (joinColumn.getSpecifiedReferencedColumnName() == null || !joinColumn.getSpecifiedReferencedColumnName().equals(referencedColumnName)) {
            this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)joinColumn, (Object)OrmPackage.eINSTANCE.getAbstractJoinColumn_SpecifiedReferencedColumnName(), (Object)referencedColumnName));
        }
    }

    private void removePrimaryKeyJoinColumn() {
        ISelection selection = this.pkJoinColumnsListViewer.getSelection();
        if (selection instanceof StructuredSelection) {
            Iterator i = ((StructuredSelection)selection).iterator();
            while (i.hasNext()) {
                this.inheritance.getPrimaryKeyJoinColumns().remove(i.next());
            }
        }
    }

    private void updatePrimaryKeyJoinColumnsEnablement() {
        boolean groupEnabledState = !this.inheritance.isDefaultPrimaryKeyJoinColumns();
        this.enableGroup(this.pkJoinColumnsGroup, groupEnabledState);
        this.pkJoinColumnsRemoveButton.setEnabled(groupEnabledState && !((StructuredSelection)this.pkJoinColumnsListViewer.getSelection()).isEmpty());
        this.pkJoinColumnsEditButton.setEnabled(groupEnabledState && ((StructuredSelection)this.pkJoinColumnsListViewer.getSelection()).size() == 1);
    }

    private void enableGroup(Group group, boolean enabled) {
        group.setEnabled(enabled);
        int i = 0;
        while (i < group.getChildren().length) {
            group.getChildren()[i].setEnabled(enabled);
            ++i;
        }
    }

    public void populate(EObject model) {
        this.populating = true;
        this.disengageListeners();
        this.inheritance = (Inheritance)model;
        if (this.inheritance == null) {
            this.pkJoinColumnsListViewer.setInput(null);
            return;
        }
        this.engageListeners();
        this.pkJoinColumnsListViewer.setInput((Object)this.inheritance);
        this.updatePrimaryKeyJoinColumnsEnablement();
        this.overrideDefaultJoinColumnsCheckBox.setSelection(!this.inheritance.isDefaultPrimaryKeyJoinColumns());
        this.populating = false;
    }

    private void engageListeners() {
        this.inheritanceItemProvider.addListener(this.getInheritanceListener());
        this.pkJoinColumnItemProvider.addListener(this.getJoinColumnListener());
        this.inheritance.eAdapters().add((Object)this.inheritanceItemProvider);
        Iterator i = this.inheritance.getPrimaryKeyJoinColumns().iterator();
        while (i.hasNext()) {
            ((PrimaryKeyJoinColumn)i.next()).eAdapters().add((Object)this.pkJoinColumnItemProvider);
        }
    }

    private void disengageListeners() {
        if (this.inheritance != null) {
            this.inheritanceItemProvider.removeListener(this.getInheritanceListener());
            this.pkJoinColumnItemProvider.removeListener(this.getJoinColumnListener());
            this.inheritance.eAdapters().remove((Object)this.inheritanceItemProvider);
            Iterator i = this.inheritance.getPrimaryKeyJoinColumns().iterator();
            while (i.hasNext()) {
                ((PrimaryKeyJoinColumn)i.next()).eAdapters().remove((Object)this.pkJoinColumnItemProvider);
            }
        }
    }

    private INotifyChangedListener getJoinColumnListener() {
        if (this.pkJoinColumnListener == null) {
            this.pkJoinColumnListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    PrimaryKeyJoinColumnsComposite.this.pkJoinColumnChanged(notification, PrimaryKeyJoinColumnsComposite.this.pkJoinColumnsListViewer);
                }
            };
        }
        return this.pkJoinColumnListener;
    }

    private INotifyChangedListener getInheritanceListener() {
        if (this.inheritanceListener == null) {
            this.inheritanceListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    PrimaryKeyJoinColumnsComposite.this.inheritanceChanged(notification);
                }
            };
        }
        return this.inheritanceListener;
    }

    protected void inheritanceChanged(Notification notification) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.orm.Inheritance");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (notification.getFeatureID((Class)clazz) == 3) {
            if (notification.getEventType() == 3) {
                ((PrimaryKeyJoinColumn)notification.getNewValue()).eAdapters().add((Object)this.pkJoinColumnItemProvider);
            } else if (notification.getEventType() == 4) {
                ((PrimaryKeyJoinColumn)notification.getOldValue()).eAdapters().remove((Object)this.pkJoinColumnItemProvider);
            }
        } else {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.dali.orm.Inheritance");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (notification.getFeatureID((Class)clazz2) == 4) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        PrimaryKeyJoinColumnsComposite.this.pkJoinColumnsListViewer.refresh();
                        boolean isDefault = PrimaryKeyJoinColumnsComposite.this.inheritance.isDefaultPrimaryKeyJoinColumns();
                        PrimaryKeyJoinColumnsComposite.this.overrideDefaultJoinColumnsCheckBox.setSelection(!isDefault);
                        PrimaryKeyJoinColumnsComposite.this.updatePrimaryKeyJoinColumnsEnablement();
                    }
                });
            }
        }
    }

    protected void pkJoinColumnChanged(Notification notification, final ListViewer listViewer) {
        block20: {
            block19: {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.dali.orm.PrimaryKeyJoinColumn");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (notification.getFeatureID((Class)clazz) == 1) break block19;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.dali.orm.PrimaryKeyJoinColumn");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (notification.getFeatureID((Class)clazz2) == 4) break block19;
                Class<?> clazz3 = class$1;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$1 = Class.forName("org.eclipse.dali.orm.PrimaryKeyJoinColumn");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (notification.getFeatureID((Class)clazz3) == 0) break block19;
                Class<?> clazz4 = class$1;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$1 = Class.forName("org.eclipse.dali.orm.PrimaryKeyJoinColumn");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (notification.getFeatureID((Class)clazz4) != 3) break block20;
            }
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (!PrimaryKeyJoinColumnsComposite.this.isDisposed()) {
                        listViewer.refresh();
                    }
                }
            });
        }
    }

    public void dispose() {
        this.disengageListeners();
        super.dispose();
    }
}

