/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.wizards;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dali.core.DaliPlugin;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.PersistenceUiPlugin;
import org.eclipse.dali.ui.datamodels.JPAProjectDataModelProvider;
import org.eclipse.dali.ui.wizards.JPAProjectContentPage;
import org.eclipse.dali.ui.wizards.JPAProjectFieldData;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizard;

public class ConfigureJPAProjectWizard
extends DataModelWizard
implements IWorkbenchWizard {
    private IJavaProject project;
    private JPAProjectFieldData fieldData;
    private JPAProjectContentPage mainPage;

    public ConfigureJPAProjectWizard(IJavaProject project) {
        this.setWindowTitle(DaliUiMessages.ConfigureJPAProjectWizard_title);
        this.project = project;
        this.fieldData = new JPAProjectFieldData();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    protected void doAddPages() {
        this.mainPage = JPAProjectContentPage.buildJavaProjectHoldingPage("page 1 - project content", this.getDataModel(), this.fieldData, this.project);
        this.mainPage.setTitle(DaliUiMessages.ConfigureJPAProjectWizard_page1_title);
        this.mainPage.setDescription(DaliUiMessages.ConfigureJPAProjectWizard_page1_desc);
        this.addPage((IWizardPage)this.mainPage);
    }

    protected IDataModelProvider getDefaultProvider() {
        return new JPAProjectDataModelProvider();
    }

    protected boolean prePerformFinish() {
        this.mainPage.updateData();
        try {
            DaliPlugin.addPersistenceNature((IJavaProject)this.project, (String)this.fieldData.getConnectionName(), (String)this.fieldData.getSchemaName());
        }
        catch (CoreException ce) {
            PersistenceUiPlugin.log(ce);
            return false;
        }
        return true;
    }
}

