/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa1.context.orm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.Generator;
import org.eclipse.jpt.core.context.XmlContextNode;
import org.eclipse.jpt.core.context.orm.OrmGenerator;
import org.eclipse.jpt.core.context.orm.OrmGeneratorContainer;
import org.eclipse.jpt.core.context.orm.OrmSequenceGenerator;
import org.eclipse.jpt.core.context.orm.OrmTableGenerator;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlGeneratorContainer;
import org.eclipse.jpt.core.resource.orm.XmlSequenceGenerator;
import org.eclipse.jpt.core.resource.orm.XmlTableGenerator;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmGeneratorContainer
extends AbstractOrmXmlContextNode
implements OrmGeneratorContainer {
    protected OrmSequenceGenerator sequenceGenerator;
    protected OrmTableGenerator tableGenerator;
    protected final XmlGeneratorContainer resourceGeneratorContainer;

    public GenericOrmGeneratorContainer(XmlContextNode parent, XmlGeneratorContainer resourceGeneratorContainer) {
        super(parent);
        this.resourceGeneratorContainer = resourceGeneratorContainer;
        this.initializeSequenceGenerator();
        this.initializeTableGenerator();
    }

    @Override
    public OrmSequenceGenerator addSequenceGenerator() {
        if (this.getSequenceGenerator() != null) {
            throw new IllegalStateException("sequenceGenerator already exists");
        }
        XmlSequenceGenerator resourceSequenceGenerator = this.buildResourceSequenceGenerator();
        this.sequenceGenerator = this.buildSequenceGenerator(resourceSequenceGenerator);
        this.resourceGeneratorContainer.setSequenceGenerator(resourceSequenceGenerator);
        this.firePropertyChanged("sequenceGenerator", null, this.sequenceGenerator);
        return this.sequenceGenerator;
    }

    @Override
    public void removeSequenceGenerator() {
        if (this.getSequenceGenerator() == null) {
            throw new IllegalStateException("sequenceGenerator does not exist, cannot be removed");
        }
        OrmSequenceGenerator oldSequenceGenerator = this.sequenceGenerator;
        this.sequenceGenerator = null;
        this.resourceGeneratorContainer.setSequenceGenerator(null);
        this.firePropertyChanged("sequenceGenerator", oldSequenceGenerator, null);
    }

    @Override
    public OrmSequenceGenerator getSequenceGenerator() {
        return this.sequenceGenerator;
    }

    protected void setSequenceGenerator(OrmSequenceGenerator newSequenceGenerator) {
        OrmSequenceGenerator oldSequenceGenerator = this.sequenceGenerator;
        this.sequenceGenerator = newSequenceGenerator;
        this.firePropertyChanged("sequenceGenerator", oldSequenceGenerator, newSequenceGenerator);
    }

    @Override
    public OrmTableGenerator addTableGenerator() {
        if (this.getTableGenerator() != null) {
            throw new IllegalStateException("tableGenerator already exists");
        }
        XmlTableGenerator resourceTableGenerator = this.buildResourceTableGenerator();
        this.tableGenerator = this.buildTableGenerator(resourceTableGenerator);
        this.resourceGeneratorContainer.setTableGenerator(resourceTableGenerator);
        this.firePropertyChanged("tableGenerator", null, this.tableGenerator);
        return this.tableGenerator;
    }

    @Override
    public void removeTableGenerator() {
        if (this.getTableGenerator() == null) {
            throw new IllegalStateException("tableGenerator does not exist, cannot be removed");
        }
        OrmTableGenerator oldTableGenerator = this.tableGenerator;
        this.tableGenerator = null;
        this.resourceGeneratorContainer.setTableGenerator(null);
        this.firePropertyChanged("tableGenerator", oldTableGenerator, null);
    }

    @Override
    public OrmTableGenerator getTableGenerator() {
        return this.tableGenerator;
    }

    protected void setTableGenerator(OrmTableGenerator newTableGenerator) {
        OrmTableGenerator oldTableGenerator = this.tableGenerator;
        this.tableGenerator = newTableGenerator;
        this.firePropertyChanged("tableGenerator", oldTableGenerator, newTableGenerator);
    }

    protected void initializeSequenceGenerator() {
        if (this.resourceGeneratorContainer.getSequenceGenerator() != null) {
            this.sequenceGenerator = this.buildSequenceGenerator(this.resourceGeneratorContainer.getSequenceGenerator());
        }
    }

    protected XmlSequenceGenerator buildResourceSequenceGenerator() {
        return OrmFactory.eINSTANCE.createXmlSequenceGenerator();
    }

    protected OrmSequenceGenerator buildSequenceGenerator(XmlSequenceGenerator resourceSequenceGenerator) {
        return this.getXmlContextNodeFactory().buildOrmSequenceGenerator(this, resourceSequenceGenerator);
    }

    protected void initializeTableGenerator() {
        if (this.resourceGeneratorContainer.getTableGenerator() != null) {
            this.tableGenerator = this.buildTableGenerator(this.resourceGeneratorContainer.getTableGenerator());
        }
    }

    protected XmlTableGenerator buildResourceTableGenerator() {
        return OrmFactory.eINSTANCE.createXmlTableGenerator();
    }

    protected OrmTableGenerator buildTableGenerator(XmlTableGenerator resourceTableGenerator) {
        return this.getXmlContextNodeFactory().buildOrmTableGenerator(this, resourceTableGenerator);
    }

    @Override
    public void update() {
        this.updateSequenceGenerator();
        this.updateTableGenerator();
    }

    protected void updateSequenceGenerator() {
        if (this.resourceGeneratorContainer.getSequenceGenerator() == null) {
            if (this.getSequenceGenerator() != null) {
                this.setSequenceGenerator(null);
            }
        } else if (this.getSequenceGenerator() == null) {
            this.setSequenceGenerator(this.buildSequenceGenerator(this.resourceGeneratorContainer.getSequenceGenerator()));
        } else {
            this.getSequenceGenerator().update(this.resourceGeneratorContainer.getSequenceGenerator());
        }
    }

    protected void updateTableGenerator() {
        if (this.resourceGeneratorContainer.getTableGenerator() == null) {
            if (this.getTableGenerator() != null) {
                this.setTableGenerator(null);
            }
        } else if (this.getTableGenerator() == null) {
            this.setTableGenerator(this.buildTableGenerator(this.resourceGeneratorContainer.getTableGenerator()));
        } else {
            this.getTableGenerator().update(this.resourceGeneratorContainer.getTableGenerator());
        }
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateGenerators(messages);
    }

    protected void validateGenerators(List<IMessage> messages) {
        Iterator<OrmGenerator> localGenerators = this.generators();
        while (localGenerators.hasNext()) {
            OrmGenerator localGenerator = localGenerators.next();
            ListIterator<Generator> globalGenerators = this.getPersistenceUnit().generators();
            while (globalGenerators.hasNext()) {
                if (!localGenerator.duplicates((Generator)globalGenerators.next())) continue;
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "GENERATOR_DUPLICATE_NAME", new String[]{localGenerator.getName()}, localGenerator, localGenerator.getNameTextRange()));
            }
        }
    }

    protected Iterator<OrmGenerator> generators() {
        ArrayList<OrmGenerator> generators = new ArrayList<OrmGenerator>();
        this.addGeneratorsTo(generators);
        return generators.iterator();
    }

    protected void addGeneratorsTo(ArrayList<OrmGenerator> generators) {
        if (this.sequenceGenerator != null) {
            generators.add(this.sequenceGenerator);
        }
        if (this.tableGenerator != null) {
            generators.add(this.tableGenerator);
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.resourceGeneratorContainer.getValidationTextRange();
    }
}

