/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NumberIntegerExpressionConverter;
import org.eclipse.jpt.core.resource.java.GeneratorAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SourceGeneratorAnnotation
extends SourceAnnotation<Member>
implements GeneratorAnnotation {
    final DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter = this.getNameAdapter();
    final AnnotationElementAdapter<String> nameAdapter = this.buildAdapter(this.nameDeclarationAdapter);
    String name;
    final DeclarationAnnotationElementAdapter<Integer> initialValueDeclarationAdapter = this.getInitialValueAdapter();
    final AnnotationElementAdapter<Integer> initialValueAdapter = this.buildIntegerAdapter(this.initialValueDeclarationAdapter);
    Integer initialValue;
    final DeclarationAnnotationElementAdapter<Integer> allocationSizeDeclarationAdapter = this.getAllocationSizeAdapter();
    final AnnotationElementAdapter<Integer> allocationSizeAdapter = this.buildIntegerAdapter(this.allocationSizeDeclarationAdapter);
    Integer allocationSize;

    SourceGeneratorAnnotation(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa) {
        super(parent, member, daa);
    }

    protected AnnotationElementAdapter<String> buildAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new MemberAnnotationElementAdapter<String>(this.member, daea);
    }

    protected AnnotationElementAdapter<Integer> buildIntegerAdapter(DeclarationAnnotationElementAdapter<Integer> daea) {
        return new MemberAnnotationElementAdapter<Integer>(this.member, daea);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.name = this.buildName(astRoot);
        this.initialValue = this.buildInitialValue(astRoot);
        this.allocationSize = this.buildAllocationSize(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncName(this.buildName(astRoot));
        this.syncInitialValue(this.buildInitialValue(astRoot));
        this.syncAllocationSize(this.buildAllocationSize(astRoot));
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.attributeValueHasChanged(this.name, name)) {
            this.name = name;
            this.nameAdapter.setValue(name);
        }
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(CompilationUnit astRoot) {
        return this.nameAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astRoot);
    }

    abstract DeclarationAnnotationElementAdapter<String> getNameAdapter();

    @Override
    public Integer getInitialValue() {
        return this.initialValue;
    }

    @Override
    public void setInitialValue(Integer initialValue) {
        if (this.attributeValueHasChanged(this.initialValue, initialValue)) {
            this.initialValue = initialValue;
            this.initialValueAdapter.setValue(initialValue);
        }
    }

    private void syncInitialValue(Integer astIinitialValue) {
        Integer old = this.initialValue;
        this.initialValue = astIinitialValue;
        this.firePropertyChanged("initialValue", old, astIinitialValue);
    }

    private Integer buildInitialValue(CompilationUnit astRoot) {
        return this.initialValueAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getInitialValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.initialValueDeclarationAdapter, astRoot);
    }

    abstract DeclarationAnnotationElementAdapter<Integer> getInitialValueAdapter();

    @Override
    public Integer getAllocationSize() {
        return this.allocationSize;
    }

    @Override
    public void setAllocationSize(Integer allocationSize) {
        if (this.attributeValueHasChanged(this.allocationSize, allocationSize)) {
            this.allocationSize = allocationSize;
            this.allocationSizeAdapter.setValue(allocationSize);
        }
    }

    private void syncAllocationSize(Integer astAllocationSize) {
        Integer old = this.allocationSize;
        this.allocationSize = astAllocationSize;
        this.firePropertyChanged("allocationSize", old, astAllocationSize);
    }

    private Integer buildAllocationSize(CompilationUnit astRoot) {
        return this.allocationSizeAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getAllocationSizeTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.allocationSizeDeclarationAdapter, astRoot);
    }

    abstract DeclarationAnnotationElementAdapter<Integer> getAllocationSizeAdapter();

    static DeclarationAnnotationElementAdapter<String> buildAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(annotationAdapter, elementName);
    }

    static DeclarationAnnotationElementAdapter<Integer> buildIntegerAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter<Integer>(annotationAdapter, elementName, NumberIntegerExpressionConverter.instance());
    }
}

