/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import org.eclipse.jpt.core.internal.resource.java.source.SourceBaseJoinColumnAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberIndexedAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.NestableJoinColumnAnnotation;
import org.eclipse.jpt.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;

public final class SourceJoinColumnAnnotation
extends SourceBaseJoinColumnAnnotation
implements NestableJoinColumnAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.JoinColumn");

    public SourceJoinColumnAnnotation(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, member, daa, annotationAdapter);
    }

    public SourceJoinColumnAnnotation(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa) {
        this(parent, member, daa, (AnnotationAdapter)new MemberAnnotationAdapter(member, daa));
    }

    public SourceJoinColumnAnnotation(JavaResourceNode parent, Member member, IndexedDeclarationAnnotationAdapter idaa) {
        this(parent, member, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)new MemberIndexedAnnotationAdapter(member, idaa));
    }

    public String getAnnotationName() {
        return "javax.persistence.JoinColumn";
    }

    protected String getNameElementName() {
        return "name";
    }

    protected String getColumnDefinitionElementName() {
        return "columnDefinition";
    }

    protected String getTableElementName() {
        return "table";
    }

    protected String getUniqueElementName() {
        return "unique";
    }

    protected String getNullableElementName() {
        return "nullable";
    }

    protected String getInsertableElementName() {
        return "insertable";
    }

    protected String getUpdatableElementName() {
        return "updatable";
    }

    protected String getReferencedColumnNameElementName() {
        return "referencedColumnName";
    }

    public static SourceJoinColumnAnnotation createJoinColumn(JavaResourceNode parent, Member member) {
        return new SourceJoinColumnAnnotation(parent, member, DECLARATION_ANNOTATION_ADAPTER);
    }

    static SourceJoinColumnAnnotation createNestedJoinColumn(JavaResourceNode parent, Member member, int index, DeclarationAnnotationAdapter joinColumnsAdapter) {
        IndexedDeclarationAnnotationAdapter idaa = SourceJoinColumnAnnotation.buildNestedDeclarationAnnotationAdapter(index, joinColumnsAdapter);
        MemberIndexedAnnotationAdapter annotationAdapter = new MemberIndexedAnnotationAdapter(member, idaa);
        return new SourceJoinColumnAnnotation(parent, member, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)annotationAdapter);
    }

    private static IndexedDeclarationAnnotationAdapter buildNestedDeclarationAnnotationAdapter(int index, DeclarationAnnotationAdapter joinColumnsAdapter) {
        return new NestedIndexedDeclarationAnnotationAdapter(joinColumnsAdapter, index, "javax.persistence.JoinColumn");
    }

    static NestableJoinColumnAnnotation createAssociationOverrideJoinColumn(DeclarationAnnotationAdapter associationOverrideAdapter, JavaResourceNode parent, Member member, int index) {
        return new SourceJoinColumnAnnotation(parent, member, SourceJoinColumnAnnotation.buildAssociationOverrideAnnotationAdapter(associationOverrideAdapter, index));
    }

    private static IndexedDeclarationAnnotationAdapter buildAssociationOverrideAnnotationAdapter(DeclarationAnnotationAdapter associationOverrideAdapter, int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(associationOverrideAdapter, "joinColumns", index, "javax.persistence.JoinColumn");
    }
}

