/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.selection;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jpt.ui.internal.selection.DefaultJpaSelectionManager;
import org.eclipse.jpt.ui.internal.selection.JpaSelectionManager;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SelectionManagerFactory {
    private static volatile SelectionManagerFactory INSTANCE;
    private static Object MUTEX;
    Map<IWorkbenchWindow, DefaultJpaSelectionManager> managers = new HashMap<IWorkbenchWindow, DefaultJpaSelectionManager>();
    private WindowListener windowListener = new WindowListener();

    static {
        MUTEX = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JpaSelectionManager getSelectionManager(IWorkbenchWindow window) {
        if (INSTANCE == null) {
            Object object = MUTEX;
            synchronized (object) {
                if (INSTANCE == null) {
                    INSTANCE = new SelectionManagerFactory();
                    INSTANCE.init();
                }
            }
        }
        return INSTANCE.internalGetSelectionManager(window);
    }

    private SelectionManagerFactory() {
    }

    private void init() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.addWindowListener((IWindowListener)this.windowListener);
    }

    DefaultJpaSelectionManager internalGetSelectionManager(IWorkbenchWindow window) {
        if (window == null) {
            throw new IllegalArgumentException("The IWorkbenchWindow cannot be null");
        }
        if (!this.managers.containsKey(window)) {
            DefaultJpaSelectionManager manager = new DefaultJpaSelectionManager();
            this.managers.put(window, manager);
            manager.init(window);
        }
        return this.managers.get(window);
    }

    class WindowListener
    implements IWindowListener {
        WindowListener() {
        }

        public void windowOpened(IWorkbenchWindow aWindow) {
        }

        public void windowClosed(IWorkbenchWindow aWindow) {
            DefaultJpaSelectionManager manager = SelectionManagerFactory.this.internalGetSelectionManager(aWindow);
            manager.dispose();
            SelectionManagerFactory.this.managers.remove(aWindow);
        }

        public void windowActivated(IWorkbenchWindow aWindow) {
        }

        public void windowDeactivated(IWorkbenchWindow aWindow) {
        }
    }
}

