/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxrs.core.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.ws.jaxrs.core.internal.JAXRSLibraryClasspathContainer;
import org.eclipse.jst.ws.jaxrs.core.internal.Messages;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrsibraryregistry.JAXRSLibrary;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrslibraryconfig.JAXRSLibraryRegistryUtil;

public class JAXRSLibrariesContainerInitializer
extends ClasspathContainerInitializer {
    private static final String MISSING_LIBRARY = Messages.JAXRSLibrariesContainerInitializer_missing_library;

    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        if (this.isJAXRSLibraryContainer(containerPath)) {
            String libId = containerPath.lastSegment();
            JAXRSLibrary ref = JAXRSLibraryRegistryUtil.getInstance().getJAXRSLibraryRegistry().getJAXRSLibraryByID(libId);
            if (ref != null) {
                JAXRSLibraryClasspathContainer container = new JAXRSLibraryClasspathContainer(ref);
                JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
            }
        }
    }

    private boolean isJAXRSLibraryContainer(IPath path) {
        return path != null && path.segmentCount() == 2 && "org.eclipse.jst.ws.jaxrs.core.internal.jaxrslibrarycontainer".equals(path.segment(0));
    }

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return this.isJAXRSLibraryContainer(containerPath);
    }

    public String getDescription(IPath containerPath, IJavaProject project) {
        if (this.isJAXRSLibraryContainer(containerPath)) {
            String id = containerPath.lastSegment();
            JAXRSLibrary libref = JAXRSLibraryRegistryUtil.getInstance().getJAXRSLibraryRegistry().getJAXRSLibraryByID(id);
            String displayText = id;
            if (libref == null) {
                displayText = String.valueOf(displayText) + " " + MISSING_LIBRARY;
            }
            return displayText;
        }
        return super.getDescription(containerPath, project);
    }

    public Object getComparisonID(IPath containerPath, IJavaProject project) {
        return containerPath;
    }
}

