/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import com.ibm.icu.text.Collator;
import java.util.EventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.datatools.connectivity.ConnectEvent;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.IManagedConnectionListener;
import org.eclipse.datatools.connectivity.IManagedConnectionOfflineListener;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.jpt.db.ConnectionListener;
import org.eclipse.jpt.db.ConnectionProfile;
import org.eclipse.jpt.db.DatabaseFinder;
import org.eclipse.jpt.db.DatabaseObject;
import org.eclipse.jpt.db.internal.DTPCatalogWrapper;
import org.eclipse.jpt.db.internal.DTPColumnWrapper;
import org.eclipse.jpt.db.internal.DTPDatabaseObject;
import org.eclipse.jpt.db.internal.DTPDatabaseWrapper;
import org.eclipse.jpt.db.internal.DTPForeignKeyWrapper;
import org.eclipse.jpt.db.internal.DTPSchemaWrapper;
import org.eclipse.jpt.db.internal.DTPSequenceWrapper;
import org.eclipse.jpt.db.internal.DTPTableWrapper;
import org.eclipse.jpt.utility.internal.ListenerList;
import org.eclipse.jpt.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DTPConnectionProfileWrapper
implements DTPDatabaseObject,
ConnectionProfile {
    private final IConnectionProfile dtpConnectionProfile;
    private final DatabaseFinder finder;
    private final DatabaseFinder.DefaultCallback databaseFinderCallback;
    private final IManagedConnection dtpManagedConnection;
    private final LocalConnectionListener connectionListener;
    private DTPDatabaseWrapper database;
    private static final String LIVE_DTP_CONNECTION_TYPE = "java.sql.Connection";
    private static final String OFFLINE_DTP_CONNECTION_TYPE = ConnectionInfo.class.getName();
    private static final String DATABASE_PRODUCT_PROP_ID = "org.eclipse.datatools.connectivity.server.version";

    DTPConnectionProfileWrapper(IConnectionProfile dtpConnectionProfile, DatabaseFinder finder) {
        this.dtpConnectionProfile = dtpConnectionProfile;
        this.finder = finder;
        this.databaseFinderCallback = new DatabaseFinderCallback();
        this.dtpManagedConnection = this.buildDTPManagedConnection();
        this.connectionListener = new LocalConnectionListener();
    }

    private IManagedConnection buildDTPManagedConnection() {
        String connectionType = this.dtpConnectionProfile.supportsWorkOfflineMode() ? OFFLINE_DTP_CONNECTION_TYPE : LIVE_DTP_CONNECTION_TYPE;
        return this.dtpConnectionProfile.getManagedConnection(connectionType);
    }

    @Override
    public String getName() {
        return this.dtpConnectionProfile.getName();
    }

    @Override
    public String getIdentifier(String javaIdentifier) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getIdentifier() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DTPConnectionProfileWrapper getConnectionProfile() {
        return this;
    }

    @Override
    public synchronized DTPDatabaseWrapper getDatabase() {
        if (this.database == null) {
            this.database = this.buildDatabase();
        }
        return this.database;
    }

    @Override
    public String getProviderID() {
        return this.dtpConnectionProfile.getProviderId();
    }

    @Override
    public String getInstanceID() {
        return this.dtpConnectionProfile.getInstanceID();
    }

    @Override
    public String getDatabaseName() {
        return this.getProperty("org.eclipse.datatools.connectivity.db.databaseName");
    }

    @Override
    public String getDatabaseProduct() {
        return this.getProperty(DATABASE_PRODUCT_PROP_ID);
    }

    @Override
    public String getDatabaseVendor() {
        return this.getProperty("org.eclipse.datatools.connectivity.db.vendor");
    }

    @Override
    public String getDatabaseVersion() {
        return this.getProperty("org.eclipse.datatools.connectivity.db.version");
    }

    @Override
    public String getDriverClassName() {
        return this.getProperty("org.eclipse.datatools.connectivity.db.driverClass");
    }

    @Override
    public String getURL() {
        return this.getProperty("org.eclipse.datatools.connectivity.db.URL");
    }

    @Override
    public String getUserName() {
        String userName = this.getProperty("org.eclipse.datatools.connectivity.db.username");
        String[] names = (userName = userName.trim()).split("\\s+");
        if (names.length == 3 && this.nameIsKeyword(names[1])) {
            return names[0];
        }
        return userName;
    }

    @Override
    public String getUserPassword() {
        return this.getProperty("org.eclipse.datatools.connectivity.db.password");
    }

    @Override
    public String getDriverDefinitionID() {
        return this.getProperty("org.eclipse.datatools.connectivity.driverDefinitionID");
    }

    @Override
    public String getDriverJarList() {
        return DriverManager.getInstance().getDriverInstanceByID(this.getDriverDefinitionID()).getJarList();
    }

    @Override
    public String getDriverName() {
        return DriverManager.getInstance().getDriverInstanceByID(this.getDriverDefinitionID()).getName();
    }

    @Override
    public boolean isActive() {
        return this.isConnected() || this.isWorkingOffline();
    }

    @Override
    public boolean isInactive() {
        return !this.isActive();
    }

    @Override
    public boolean isConnected() {
        return this.dtpManagedConnection.isConnected() && !this.dtpManagedConnection.isWorkingOffline();
    }

    @Override
    public boolean isDisconnected() {
        return !this.isConnected();
    }

    @Override
    public void connect() {
        if (this.isDisconnected()) {
            this.checkStatus(this.dtpConnectionProfile.connect());
        }
    }

    @Override
    public void disconnect() {
        this.checkStatus(this.dtpConnectionProfile.disconnect());
    }

    @Override
    public boolean isWorkingOffline() {
        return this.dtpManagedConnection.isWorkingOffline();
    }

    @Override
    public boolean supportsWorkOfflineMode() {
        return this.dtpConnectionProfile.supportsWorkOfflineMode();
    }

    @Override
    public IStatus saveWorkOfflineData() {
        return this.dtpConnectionProfile.saveWorkOfflineData();
    }

    @Override
    public boolean canWorkOffline() {
        return this.dtpConnectionProfile.canWorkOffline();
    }

    @Override
    public IStatus workOffline() {
        return this.dtpConnectionProfile.workOffline();
    }

    @Override
    public synchronized void addConnectionListener(ConnectionListener listener) {
        if (this.hasNoListeners()) {
            this.startListening();
        }
        this.connectionListener.addConnectionListener(listener);
    }

    private void startListening() {
        this.dtpManagedConnection.addConnectionListener((IManagedConnectionListener)this.connectionListener);
        if (this.database != null && this.isConnected()) {
            this.database.startListening();
        }
    }

    @Override
    public synchronized void removeConnectionListener(ConnectionListener listener) {
        this.connectionListener.removeConnectionListener(listener);
        if (this.hasNoListeners()) {
            this.stopListening();
        }
    }

    private void stopListening() {
        if (this.database != null && this.isConnected()) {
            this.database.stopListening();
        }
        this.dtpManagedConnection.removeConnectionListener((IManagedConnectionListener)this.connectionListener);
    }

    boolean hasNoListeners() {
        return this.connectionListener.hasNoListeners();
    }

    boolean hasAnyListeners() {
        return this.connectionListener.hasAnyListeners();
    }

    private void checkStatus(IStatus status) {
        if (status.isOK()) {
            return;
        }
        if (status.isMultiStatus()) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                this.checkStatus(child);
                ++n2;
            }
        }
        throw new RuntimeException(status.getMessage(), status.getException());
    }

    private DTPDatabaseWrapper buildDatabase() {
        if (this.isInactive()) {
            return null;
        }
        if (this.isWorkingOffline()) {
            ConnectionInfo connectionInfo = (ConnectionInfo)this.dtpManagedConnection.getConnection().getRawConnection();
            return new DTPDatabaseWrapper(this, connectionInfo.getSharedDatabase());
        }
        return new DTPDatabaseWrapper(this, ProfileUtil.getDatabase((DatabaseIdentifier)new DatabaseIdentifier(this.getName(), this.getDatabaseName()), (boolean)true));
    }

    synchronized void clearDatabase() {
        if (this.database != null) {
            if (this.isConnected()) {
                this.database.stopListening();
            }
            this.database = null;
        }
    }

    <T extends DatabaseObject> T selectDatabaseObjectForIdentifier(T[] databaseObjects, String identifier) {
        return (T)this.finder.selectDatabaseObjectForIdentifier((DatabaseObject[])databaseObjects, identifier, this.databaseFinderCallback);
    }

    <T extends DatabaseObject> T selectDatabaseObjectForIdentifier_(T[] databaseObjects, String identifier) {
        return (T)this.database.selectDatabaseObjectForIdentifier_((DatabaseObject[])databaseObjects, identifier);
    }

    void databaseChanged(DTPDatabaseWrapper db) {
        this.connectionListener.databaseChanged(db);
    }

    void catalogChanged(DTPCatalogWrapper catalog) {
        this.connectionListener.catalogChanged(catalog);
    }

    void schemaChanged(DTPSchemaWrapper schema) {
        this.connectionListener.schemaChanged(schema);
    }

    void sequenceChanged(DTPSequenceWrapper sequence) {
        this.connectionListener.sequenceChanged(sequence);
    }

    void tableChanged(DTPTableWrapper table) {
        this.connectionListener.tableChanged(table);
    }

    void columnChanged(DTPColumnWrapper column) {
        this.connectionListener.columnChanged(column);
    }

    void foreignKeyChanged(DTPForeignKeyWrapper foreignKey) {
        this.connectionListener.foreignKeyChanged(foreignKey);
    }

    private String getProperty(String propertyName) {
        return this.dtpConnectionProfile.getBaseProperties().getProperty(propertyName);
    }

    private boolean nameIsKeyword(String name) {
        return name.equalsIgnoreCase("as");
    }

    @Override
    public int compareTo(ConnectionProfile connectionProfile) {
        return Collator.getInstance().compare(this.getName(), connectionProfile.getName());
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DatabaseFinderCallback
    implements DatabaseFinder.DefaultCallback {
        DatabaseFinderCallback() {
        }

        @Override
        public <T extends DatabaseObject> T selectDatabaseObjectForIdentifier(T[] databaseObjects, String identifier) {
            return (T)DTPConnectionProfileWrapper.this.selectDatabaseObjectForIdentifier_((DatabaseObject[])databaseObjects, identifier);
        }
    }

    class LocalConnectionListener
    implements IManagedConnectionOfflineListener {
        private ListenerList<ConnectionListener> listenerList = new ListenerList(ConnectionListener.class);

        LocalConnectionListener() {
        }

        void addConnectionListener(ConnectionListener listener) {
            this.listenerList.add((EventListener)listener);
        }

        void removeConnectionListener(ConnectionListener listener) {
            this.listenerList.remove((EventListener)listener);
        }

        boolean hasNoListeners() {
            return this.listenerList.isEmpty();
        }

        boolean hasAnyListeners() {
            return !this.listenerList.isEmpty();
        }

        public void opened(ConnectEvent event) {
            ConnectionListener[] connectionListenerArray = (ConnectionListener[])this.listenerList.getListeners();
            int n = connectionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConnectionListener listener = connectionListenerArray[n2];
                listener.opened(DTPConnectionProfileWrapper.this);
                ++n2;
            }
        }

        public void modified(ConnectEvent event) {
            ConnectionListener[] connectionListenerArray = (ConnectionListener[])this.listenerList.getListeners();
            int n = connectionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConnectionListener listener = connectionListenerArray[n2];
                listener.modified(DTPConnectionProfileWrapper.this);
                ++n2;
            }
        }

        public boolean okToClose(ConnectEvent event) {
            ConnectionListener[] connectionListenerArray = (ConnectionListener[])this.listenerList.getListeners();
            int n = connectionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConnectionListener listener = connectionListenerArray[n2];
                if (!listener.okToClose(DTPConnectionProfileWrapper.this)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        public void aboutToClose(ConnectEvent event) {
            ConnectionListener[] connectionListenerArray = (ConnectionListener[])this.listenerList.getListeners();
            int n = connectionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConnectionListener listener = connectionListenerArray[n2];
                listener.aboutToClose(DTPConnectionProfileWrapper.this);
                ++n2;
            }
        }

        public void closed(ConnectEvent event) {
            DTPConnectionProfileWrapper.this.clearDatabase();
            ConnectionListener[] connectionListenerArray = (ConnectionListener[])this.listenerList.getListeners();
            int n = connectionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConnectionListener listener = connectionListenerArray[n2];
                listener.closed(DTPConnectionProfileWrapper.this);
                ++n2;
            }
        }

        public boolean okToDetach(ConnectEvent event) {
            return this.okToClose(event);
        }

        public void aboutToDetach(ConnectEvent event) {
            this.closed(event);
        }

        public void workingOffline(ConnectEvent event) {
            this.opened(event);
        }

        public void aboutToAttach(ConnectEvent event) {
            this.closed(event);
        }

        void databaseChanged(DTPDatabaseWrapper db) {
            ConnectionListener[] connectionListenerArray = (ConnectionListener[])this.listenerList.getListeners();
            int n = connectionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConnectionListener listener = connectionListenerArray[n2];
                listener.databaseChanged(DTPConnectionProfileWrapper.this, db);
                ++n2;
            }
        }

        void catalogChanged(DTPCatalogWrapper catalog) {
            ConnectionListener[] connectionListenerArray = (ConnectionListener[])this.listenerList.getListeners();
            int n = connectionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConnectionListener listener = connectionListenerArray[n2];
                listener.catalogChanged(DTPConnectionProfileWrapper.this, catalog);
                ++n2;
            }
        }

        void schemaChanged(DTPSchemaWrapper schema) {
            ConnectionListener[] connectionListenerArray = (ConnectionListener[])this.listenerList.getListeners();
            int n = connectionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConnectionListener listener = connectionListenerArray[n2];
                listener.schemaChanged(DTPConnectionProfileWrapper.this, schema);
                ++n2;
            }
        }

        void sequenceChanged(DTPSequenceWrapper sequence) {
            ConnectionListener[] connectionListenerArray = (ConnectionListener[])this.listenerList.getListeners();
            int n = connectionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConnectionListener listener = connectionListenerArray[n2];
                listener.sequenceChanged(DTPConnectionProfileWrapper.this, sequence);
                ++n2;
            }
        }

        void tableChanged(DTPTableWrapper table) {
            ConnectionListener[] connectionListenerArray = (ConnectionListener[])this.listenerList.getListeners();
            int n = connectionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConnectionListener listener = connectionListenerArray[n2];
                listener.tableChanged(DTPConnectionProfileWrapper.this, table);
                ++n2;
            }
        }

        void columnChanged(DTPColumnWrapper column) {
            ConnectionListener[] connectionListenerArray = (ConnectionListener[])this.listenerList.getListeners();
            int n = connectionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConnectionListener listener = connectionListenerArray[n2];
                listener.columnChanged(DTPConnectionProfileWrapper.this, column);
                ++n2;
            }
        }

        void foreignKeyChanged(DTPForeignKeyWrapper foreignKey) {
            ConnectionListener[] connectionListenerArray = (ConnectionListener[])this.listenerList.getListeners();
            int n = connectionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConnectionListener listener = connectionListenerArray[n2];
                listener.foreignKeyChanged(DTPConnectionProfileWrapper.this, foreignKey);
                ++n2;
            }
        }
    }
}

