/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import com.ibm.icu.text.Collator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.jpt.db.Column;
import org.eclipse.jpt.db.ForeignKey;
import org.eclipse.jpt.db.internal.DTPColumnWrapper;
import org.eclipse.jpt.db.internal.DTPDatabaseObjectWrapper;
import org.eclipse.jpt.db.internal.DTPTableWrapper;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DTPForeignKeyWrapper
extends DTPDatabaseObjectWrapper
implements ForeignKey {
    private final org.eclipse.datatools.modelbase.sql.constraints.ForeignKey dtpForeignKey;
    private DTPTableWrapper referencedTable;
    private LocalColumnPair[] columnPairs;
    private String defaultAttributeName;
    private boolean defaultAttributeNameCalculated = false;

    DTPForeignKeyWrapper(DTPTableWrapper baseTable, org.eclipse.datatools.modelbase.sql.constraints.ForeignKey dtpForeignKey) {
        super(baseTable, dtpForeignKey);
        this.dtpForeignKey = dtpForeignKey;
    }

    @Override
    synchronized void catalogObjectChanged() {
        super.catalogObjectChanged();
        this.getConnectionProfile().foreignKeyChanged(this);
    }

    @Override
    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)(String.valueOf(this.getName()) + ": " + Arrays.asList(this.getColumnPairs())));
    }

    @Override
    public String getName() {
        return this.dtpForeignKey.getName();
    }

    @Override
    public DTPTableWrapper getBaseTable() {
        return (DTPTableWrapper)this.getParent();
    }

    @Override
    public synchronized DTPTableWrapper getReferencedTable() {
        if (this.referencedTable == null) {
            this.referencedTable = this.getBaseTable().getTable((Table)this.dtpForeignKey.getUniqueConstraint().getBaseTable());
        }
        return this.referencedTable;
    }

    @Override
    public boolean referencesSingleColumnPrimaryKey() {
        if (this.columnPairsSize() != 1) {
            return false;
        }
        if (this.getReferencedTable().primaryKeyColumnsSize() != 1) {
            return false;
        }
        return this.getColumnPair().getReferencedColumn() == this.getReferencedTable().getPrimaryKeyColumn();
    }

    @Override
    public Iterator<ForeignKey.ColumnPair> columnPairs() {
        return new ArrayIterator((Object[])this.getColumnPairs());
    }

    @Override
    public LocalColumnPair getColumnPair() {
        LocalColumnPair[] pairs = this.getColumnPairs();
        if (pairs.length != 1) {
            throw new IllegalStateException("multiple column pairs: " + pairs.length);
        }
        return pairs[0];
    }

    private Iterator<LocalColumnPair> localColumnPairs() {
        return new ArrayIterator((Object[])this.getColumnPairs());
    }

    private synchronized LocalColumnPair[] getColumnPairs() {
        if (this.columnPairs == null) {
            this.columnPairs = this.buildColumnPairs();
        }
        return this.columnPairs;
    }

    private LocalColumnPair[] buildColumnPairs() {
        List<org.eclipse.datatools.modelbase.sql.tables.Column> baseColumns = this.getDTPBaseColumns();
        int size = baseColumns.size();
        List<org.eclipse.datatools.modelbase.sql.tables.Column> refColumns = this.getDTPReferenceColumns();
        if (refColumns.size() != size) {
            throw new IllegalStateException(String.valueOf(this.getBaseTable().getName()) + '.' + this.getName() + " - mismatched sizes: " + size + " vs. " + refColumns.size());
        }
        LocalColumnPair[] result = new LocalColumnPair[baseColumns.size()];
        int i = baseColumns.size();
        while (i-- > 0) {
            result[i] = new LocalColumnPair(this.getBaseTable().getColumn(baseColumns.get(i)), this.getBaseTable().getColumn(refColumns.get(i)));
        }
        return result;
    }

    private List<org.eclipse.datatools.modelbase.sql.tables.Column> getDTPBaseColumns() {
        return this.dtpForeignKey.getMembers();
    }

    private List<org.eclipse.datatools.modelbase.sql.tables.Column> getDTPReferenceColumns() {
        return this.dtpForeignKey.getUniqueConstraint().getMembers();
    }

    @Override
    public int columnPairsSize() {
        return this.getColumnPairs().length;
    }

    @Override
    public Iterator<Column> baseColumns() {
        return new TransformationIterator<LocalColumnPair, Column>(this.localColumnPairs()){

            protected Column transform(LocalColumnPair pair) {
                return pair.getBaseColumn();
            }
        };
    }

    boolean baseColumnsContains(Column column) {
        return CollectionTools.contains(this.baseColumns(), (Object)column);
    }

    @Override
    public Iterator<Column> nonPrimaryKeyBaseColumns() {
        return new FilteringIterator<Column, Column>(this.baseColumns()){

            protected boolean accept(Column column) {
                return !column.isPartOfPrimaryKey();
            }
        };
    }

    @Override
    public Iterator<Column> referencedColumns() {
        return new TransformationIterator<LocalColumnPair, Column>(this.localColumnPairs()){

            protected Column transform(LocalColumnPair columnPair) {
                return columnPair.getReferencedColumn();
            }
        };
    }

    @Override
    public String getAttributeName() {
        String defaultName = this.getDefaultAttributeName();
        return defaultName != null ? defaultName : this.getNonDefaultAttributeName();
    }

    @Override
    public synchronized String getDefaultAttributeName() {
        if (!this.defaultAttributeNameCalculated) {
            this.defaultAttributeNameCalculated = true;
            this.defaultAttributeName = this.buildDefaultAttributeName();
        }
        return this.defaultAttributeName;
    }

    private String buildDefaultAttributeName() {
        if (!this.referencesSingleColumnPrimaryKey()) {
            return null;
        }
        LocalColumnPair columnPair = this.getColumnPair();
        String baseColName = columnPair.getBaseColumn().getName();
        String refColName = columnPair.getReferencedColumn().getName();
        if (baseColName.length() <= refColName.length() + 1) {
            return null;
        }
        if (!baseColName.endsWith(refColName)) {
            return null;
        }
        int _index = baseColName.length() - refColName.length() - 1;
        if (baseColName.charAt(_index) != '_') {
            return null;
        }
        return baseColName.substring(0, _index);
    }

    private String getNonDefaultAttributeName() {
        return this.columnPairsSize() == 1 ? this.getNonDefaultAttributeNameFromBaseColumn() : this.getReferencedTable().getName();
    }

    private String getNonDefaultAttributeNameFromBaseColumn() {
        int refLen;
        LocalColumnPair columnPair = this.getColumnPair();
        String baseColName = columnPair.getBaseColumn().getName();
        String refColName = columnPair.getReferencedColumn().getName();
        int len = baseColName.length();
        if (len > (refLen = refColName.length()) && baseColName.endsWith(refColName) && (len -= refLen) > 1 && baseColName.charAt(len - 1) == '_') {
            --len;
        }
        return baseColName.substring(0, len);
    }

    @Override
    public String getJoinColumnAnnotationIdentifier(String attributeName) {
        String baseColumnName = this.getColumnPair().getBaseColumn().getName();
        String defaultBaseColumnName = String.valueOf(attributeName) + '_' + this.getReferencedTable().getPrimaryKeyColumn().getName();
        return this.getDatabase().convertNameToIdentifier(baseColumnName, defaultBaseColumnName);
    }

    @Override
    public int compareTo(ForeignKey foreignKey) {
        return Collator.getInstance().compare(this.getName(), foreignKey.getName());
    }

    boolean wraps(org.eclipse.datatools.modelbase.sql.constraints.ForeignKey foreignKey) {
        return this.dtpForeignKey == foreignKey;
    }

    @Override
    void clear() {
        this.defaultAttributeNameCalculated = false;
        this.defaultAttributeName = null;
        this.columnPairs = null;
        this.referencedTable = null;
    }

    private static class LocalColumnPair
    implements ForeignKey.ColumnPair {
        private final DTPColumnWrapper baseColumn;
        private final DTPColumnWrapper referencedColumn;

        LocalColumnPair(DTPColumnWrapper baseColumn, DTPColumnWrapper referencedColumn) {
            if (baseColumn == null || referencedColumn == null) {
                throw new NullPointerException();
            }
            this.baseColumn = baseColumn;
            this.referencedColumn = referencedColumn;
        }

        public DTPColumnWrapper getBaseColumn() {
            return this.baseColumn;
        }

        public DTPColumnWrapper getReferencedColumn() {
            return this.referencedColumn;
        }

        public int compareTo(ForeignKey.ColumnPair columnPair) {
            return Collator.getInstance().compare(this.getBaseColumn().getName(), columnPair.getBaseColumn().getName());
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)(String.valueOf(this.baseColumn.getName()) + "=>" + this.referencedColumn.getName()));
        }
    }
}

