/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.gen.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.gen.internal.EntityGenerator;
import org.eclipse.jpt.gen.internal.GenTable;
import org.eclipse.jpt.gen.internal.JptGenMessages;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GenScope {
    private final EntityGenerator.Config entityConfig;
    private final HashMap<Table, GenTable> genTables;

    GenScope(EntityGenerator.Config entityConfig, IProgressMonitor progressMonitor) {
        this.entityConfig = entityConfig;
        this.genTables = new HashMap(entityConfig.tablesSize());
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)JptGenMessages.GenScope_taskName, (int)4);
        this.buildGenTables();
        sm.worked(1);
        this.checkCanceled((IProgressMonitor)sm);
        this.buildManyToManyRelations();
        sm.worked(1);
        this.checkCanceled((IProgressMonitor)sm);
        this.buildManyToOneRelations();
        sm.worked(1);
        this.checkCanceled((IProgressMonitor)sm);
        this.buildAttributeNames();
        sm.worked(1);
        this.checkCanceled((IProgressMonitor)sm);
    }

    private void buildGenTables() {
        Iterator<Table> stream = this.entityConfig.tables();
        while (stream.hasNext()) {
            Table table = stream.next();
            this.genTables.put(table, new GenTable(this, table));
        }
    }

    private void buildManyToManyRelations() {
        Iterator<GenTable> stream = this.genTables();
        while (stream.hasNext()) {
            stream.next().buildJoinTableRelation();
        }
        HashSet<GenTable> referencedGenTables = this.buildReferencedGenTables();
        Iterator<GenTable> stream2 = this.joinGenTables();
        while (stream2.hasNext()) {
            GenTable joinGenTable = stream2.next();
            if (!referencedGenTables.contains(joinGenTable)) continue;
            joinGenTable.clearJoinTableRelation();
        }
    }

    private void buildManyToOneRelations() {
        Iterator<GenTable> stream = this.entityGenTables();
        while (stream.hasNext()) {
            stream.next().buildManyToOneRelations();
        }
    }

    private void buildAttributeNames() {
        Iterator<GenTable> stream = this.entityGenTables();
        while (stream.hasNext()) {
            stream.next().buildAttributeNames();
        }
    }

    EntityGenerator.Config getEntityConfig() {
        return this.entityConfig;
    }

    Iterator<GenTable> entityGenTables() {
        return new FilteringIterator<GenTable, GenTable>(this.genTables()){

            protected boolean accept(GenTable genTable) {
                return !genTable.isJoinTable();
            }
        };
    }

    int entityTablesSize() {
        return CollectionTools.size(this.entityGenTables());
    }

    GenTable getGenTable(Table table) {
        return this.genTables.get(table);
    }

    private Iterator<GenTable> genTables() {
        return this.genTables.values().iterator();
    }

    private int genTablesSize() {
        return this.genTables.size();
    }

    private Iterator<GenTable> joinGenTables() {
        return new FilteringIterator<GenTable, GenTable>(this.genTables()){

            protected boolean accept(GenTable genTable) {
                return genTable.isJoinTable();
            }
        };
    }

    private HashSet<GenTable> buildReferencedGenTables() {
        HashSet<GenTable> referencedGenTables = new HashSet<GenTable>(this.genTablesSize());
        Iterator<GenTable> stream = this.genTables();
        while (stream.hasNext()) {
            stream.next().addReferencedGenTablesTo(referencedGenTables);
        }
        return referencedGenTables;
    }

    private void checkCanceled(IProgressMonitor progressMonitor) {
        if (progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, this.genTables);
    }
}

