/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.views;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.ui.JpaPlatformUi;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.details.JpaDetailsPage;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.Tracing;
import org.eclipse.jpt.ui.internal.platform.JpaPlatformUiRegistry;
import org.eclipse.jpt.ui.internal.selection.JpaSelection;
import org.eclipse.jpt.ui.internal.views.AbstractJpaView;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaDetailsView
extends AbstractJpaView {
    private JpaDetailsPage<JpaStructureNode> currentPage;
    private JpaSelection currentSelection;
    private Map<String, Map<IContentType, Map<String, JpaDetailsPage<? extends JpaStructureNode>>>> detailsPages;

    public JpaDetailsView() {
        super(JptUiMessages.JpaDetailsView_viewNotAvailable);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.currentSelection = JpaSelection.NULL_SELECTION;
        this.detailsPages = new HashMap<String, Map<IContentType, Map<String, JpaDetailsPage<? extends JpaStructureNode>>>>();
    }

    private JpaPlatformUi getJpaPlatformUi(JpaStructureNode structureNode) {
        String platformId = structureNode.getJpaProject().getJpaPlatform().getId();
        return JpaPlatformUiRegistry.instance().getJpaPlatformUi(platformId);
    }

    public JpaSelection getSelection() {
        return this.currentSelection;
    }

    private JpaDetailsPage<? extends JpaStructureNode> getDetailsPage(JpaStructureNode structureNode) {
        JpaDetailsPage<? extends JpaStructureNode> page;
        Map<IContentType, Map<String, JpaDetailsPage<? extends JpaStructureNode>>> platformDetailsPages;
        Map<String, JpaDetailsPage<? extends JpaStructureNode>> contentTypeDetailsPages;
        String platformId = structureNode.getJpaProject().getJpaPlatform().getId();
        if (this.detailsPages.containsKey(platformId) && (contentTypeDetailsPages = (platformDetailsPages = this.detailsPages.get(platformId)).get(structureNode.getContentType())) != null && (page = contentTypeDetailsPages.get(structureNode.getId())) != null) {
            if (page.getControl().isDisposed()) {
                platformDetailsPages.remove(structureNode.getId());
            } else {
                return page;
            }
        }
        return this.buildDetailsPage(structureNode);
    }

    private JpaDetailsPage<? extends JpaStructureNode> buildDetailsPage(JpaStructureNode structureNode) {
        IContentType contentType;
        Map<String, JpaDetailsPage<? extends JpaStructureNode>> contentTypeDetailsPages;
        JpaPlatformUi jpaPlatformUi = this.getJpaPlatformUi(structureNode);
        Composite container = this.getWidgetFactory().createComposite((Composite)this.getPageBook());
        container.setLayout((Layout)new FillLayout(256));
        JpaDetailsPage<? extends JpaStructureNode> page = jpaPlatformUi.buildJpaDetailsPage(container, structureNode, this.getWidgetFactory());
        if (page == null) {
            return null;
        }
        String platformId = structureNode.getJpaProject().getJpaPlatform().getId();
        Map<IContentType, Map<String, JpaDetailsPage<? extends JpaStructureNode>>> platformDetailsPages = this.detailsPages.get(platformId);
        if (platformDetailsPages == null) {
            platformDetailsPages = new HashMap<IContentType, Map<String, JpaDetailsPage<? extends JpaStructureNode>>>();
            this.detailsPages.put(platformId, platformDetailsPages);
        }
        if ((contentTypeDetailsPages = platformDetailsPages.get(contentType = structureNode.getContentType())) == null) {
            contentTypeDetailsPages = new HashMap<String, JpaDetailsPage<? extends JpaStructureNode>>();
            platformDetailsPages.put(contentType, contentTypeDetailsPages);
        }
        contentTypeDetailsPages.put(structureNode.getId(), page);
        return page;
    }

    @Override
    public void select(JpaSelection jpaSelection) {
        if (jpaSelection.equals(this.currentSelection)) {
            return;
        }
        this.currentSelection = jpaSelection;
        if (jpaSelection != JpaSelection.NULL_SELECTION) {
            JpaStructureNode newNode = jpaSelection.getSelectedNode();
            JpaDetailsPage<? extends JpaStructureNode> newPage = this.getDetailsPage(newNode);
            this.setCurrentPage(newPage);
        } else {
            this.setCurrentPage(null);
        }
    }

    private void setCurrentPage(JpaDetailsPage<? extends JpaStructureNode> page) {
        if (this.currentPage != null) {
            try {
                this.log("JpaDetailsView.setCurrentPage() : disposing of current page");
                this.currentPage.setSubject(null);
            }
            catch (Exception e) {
                JptUiPlugin.log(e);
            }
        }
        JpaDetailsPage<? extends JpaStructureNode> newPage = page;
        if (page != null) {
            try {
                this.log("JpaDetailsView.setCurrentPage() : populating new page");
                newPage.setSubject((JpaStructureNode)this.currentSelection.getSelectedNode());
            }
            catch (Exception e) {
                page = null;
                JptUiPlugin.log(e);
            }
        } else {
            this.log("JpaDetailsView.setCurrentPage() : No page to populate");
        }
        if (newPage != null && this.currentPage == newPage) {
            return;
        }
        this.currentPage = newPage;
        if (page == null) {
            this.showDefaultPage();
        } else {
            this.showPage(page.getControl());
        }
    }

    public void dispose() {
        this.detailsPages.clear();
        this.currentSelection = JpaSelection.NULL_SELECTION;
        this.currentPage = null;
        super.dispose();
    }

    private void log(String message) {
        if (Tracing.booleanDebugOption("/debug/ui/detailsView")) {
            Tracing.log(message);
        }
    }
}

