/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.widgets;

import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.util.SWTUtil;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationWritablePropertyValueModel;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IntegerCombo<T extends Model>
extends Pane<T> {
    private CCombo comboBox;
    private PropertyValueModel<String> defaultValueHolder;

    protected IntegerCombo(Pane<? extends T> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    protected IntegerCombo(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    public CCombo getCombo() {
        return this.comboBox;
    }

    @Override
    protected void initializeLayout(Composite container) {
        this.defaultValueHolder = this.buildDefaultStringHolder();
        this.comboBox = this.addIntegerCombo(container);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 768;
        gridData.grabExcessHorizontalSpace = false;
        this.comboBox.setLayoutData((Object)gridData);
        this.comboBox.addVerifyListener(this.buildVerifyListener());
        SWTUtil.attachDefaultValueHandler(this.comboBox);
    }

    protected CCombo addIntegerCombo(Composite container) {
        return this.addLabeledEditableCCombo(container, this.getLabelText(), this.buildDefaultListHolder(), this.buildSelectedItemStringHolder(), this.getHelpId());
    }

    protected VerifyListener buildVerifyListener() {
        return new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                IntegerCombo.this.verifyComboBox(e);
            }
        };
    }

    protected ListValueModel<String> buildDefaultListHolder() {
        return new PropertyListValueModelAdapter(this.defaultValueHolder);
    }

    private PropertyValueModel<String> buildDefaultStringHolder() {
        return new TransformationPropertyValueModel<Integer, String>(this.buildDefaultHolder()){

            protected String transform_(Integer value) {
                return IntegerCombo.this.getDefaultValueString(value);
            }
        };
    }

    private String getDefaultValueString(Integer defaultValue) {
        return NLS.bind((String)JptUiMappingsMessages.DefaultWithOneParam, (Object)defaultValue);
    }

    private String getDefaultValueString() {
        return (String)this.defaultValueHolder.getValue();
    }

    protected WritablePropertyValueModel<String> buildSelectedItemStringHolder() {
        return new TransformationWritablePropertyValueModel<Integer, String>(this.buildSelectedItemHolder()){

            protected String transform(Integer value) {
                return value == null ? IntegerCombo.this.getDefaultValueString() : value.toString();
            }

            protected Integer reverseTransform_(String value) {
                int intLength;
                try {
                    intLength = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
                return intLength;
            }
        };
    }

    protected abstract String getLabelText();

    protected abstract String getHelpId();

    protected abstract PropertyValueModel<Integer> buildDefaultHolder();

    protected abstract WritablePropertyValueModel<Integer> buildSelectedItemHolder();

    protected void verifyComboBox(VerifyEvent e) {
        if (e.character == '\b') {
            return;
        }
        if (e.text.equals("") || e.text.equals(this.defaultValueHolder.getValue())) {
            return;
        }
        try {
            Integer.parseInt(e.text);
        }
        catch (NumberFormatException numberFormatException) {
            e.doit = false;
        }
    }
}

