/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.wizards;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jpt.gen.internal.EntityGenTools;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.util.SWTUtil;
import org.eclipse.jpt.ui.internal.util.TableLayoutComposite;
import org.eclipse.jpt.ui.internal.wizards.GenerateEntitiesWizard;
import org.eclipse.jpt.utility.internal.NameTools;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GenerateEntitiesWizardPage
extends NewTypeWizardPage {
    CheckboxTableViewer tableTable;
    Button synchronizeClassesCheckBox;
    private boolean convertToJavaStyleIdentifiers = true;
    private boolean fieldAccessType = true;
    private String collectionTypeName = Set.class.getName();
    private String collectionAttributeNameSuffix = "_collection";
    private int fieldVisibility = 0;
    private int methodVisibility = 3;
    private boolean generateGettersAndSetters = true;
    private boolean generateDefaultConstructor = true;
    private boolean serializable = true;
    private boolean generateSerialVersionUID = true;
    private boolean generateEmbeddedIdForCompoundPK = true;
    private String embeddedIdAttributeName = "pk";
    private String primaryKeyMemberClassName = "PK";
    private HashMap<org.eclipse.jpt.db.Table, String> entityNames;
    private boolean synchronizePersistenceXml = false;
    static final String[] TABLE_TABLE_COLUMN_PROPERTIES = new String[]{"table", "entityName"};
    private static final int TABLE_COLUMN_INDEX = 0;
    private static final int ENTITY_NAME_COLUMN_INDEX = 1;

    GenerateEntitiesWizardPage() {
        super(true, "Generate Entities");
        this.setTitle(JptUiMessages.GenerateEntitiesWizardPage_generateEntities);
        this.setMessage(JptUiMessages.GenerateEntitiesWizardPage_chooseEntityTable);
    }

    void init(IStructuredSelection selection) {
        IJavaElement jelem = this.getInitialJavaElement(selection);
        this.initContainerPage(jelem);
        this.initTypePage(jelem);
        this.doStatusUpdate();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jpt.ui.dialog_generateEntities");
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.synchronizeClassesCheckBox = new Button(composite, 32);
        this.synchronizeClassesCheckBox.setText(JptUiMessages.GenerateEntitiesWizardPage_synchronizeClasses);
        this.synchronizeClassesCheckBox.addSelectionListener(this.buildSynchClassesSelectionListener());
        Group tablesGroup = new Group(composite, 16);
        tablesGroup.setLayout((Layout)new GridLayout(2, false));
        tablesGroup.setText(JptUiMessages.GenerateEntitiesWizardPage_tables);
        GridData data = new GridData();
        data.horizontalSpan = 4;
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        tablesGroup.setLayoutData((Object)data);
        this.createTablesSelectionControl((Composite)tablesGroup);
        this.createButtonComposite(tablesGroup);
        this.initTablesSelectionControl();
        this.synchronizeClassesCheckBox.setSelection(!this.getGenEntitiesWizard().getJpaProject().discoversAnnotatedClasses());
        this.setSynchronizePersistenceXml(this.synchronizeClassesCheckBox.getSelection());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.tableTable.getControl(), "org.eclipse.jpt.ui.dialog_generateEntities_tables");
        this.setControl((Control)composite);
        this.setPageComplete(false);
    }

    private GenerateEntitiesWizard getGenEntitiesWizard() {
        return (GenerateEntitiesWizard)this.getWizard();
    }

    void selectAllTables() {
        this.tableTable.setAllChecked(true);
        this.doStatusUpdate();
    }

    void deselectAllTables() {
        this.tableTable.setAllChecked(false);
        this.doStatusUpdate();
    }

    private void initTablesSelectionControl() {
        this.setPossibleTables(this.getGenEntitiesWizard().getPossibleTables());
    }

    void setPossibleTables(Collection<org.eclipse.jpt.db.Table> possibleTables) {
        if (this.tableTable == null) {
            return;
        }
        this.entityNames = new HashMap(possibleTables.size());
        for (org.eclipse.jpt.db.Table table : possibleTables) {
            String tableName = table.getName();
            String entityName = this.convertToJavaStyleIdentifiers ? EntityGenTools.convertToUniqueJavaStyleClassName((String)tableName, this.entityNames.values()) : NameTools.uniqueNameFor((String)tableName, this.entityNames.values());
            this.entityNames.put(table, entityName);
        }
        this.tableTable.setInput(possibleTables);
    }

    private void createTablesSelectionControl(Composite parent) {
        TableLayoutComposite layout = new TableLayoutComposite(parent, 0);
        this.addColumnLayoutData(layout);
        Table table = new Table((Composite)layout, 68388);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn tableNameColumn = new TableColumn(table, 0, 0);
        tableNameColumn.setText(JptUiMessages.GenerateEntitiesWizardPage_tableColumn);
        tableNameColumn.setResizable(true);
        TableColumn entityNameColumn = new TableColumn(table, 0, 1);
        entityNameColumn.setText(JptUiMessages.GenerateEntitiesWizardPage_entityNameColumn);
        entityNameColumn.setResizable(true);
        GridData gd = new GridData(1808);
        gd.heightHint = SWTUtil.getTableHeightHint(table, 20);
        gd.widthHint = 600;
        layout.setLayoutData(gd);
        this.tableTable = new CheckboxTableViewer(table);
        this.tableTable.setUseHashlookup(true);
        this.tableTable.setLabelProvider(this.buildTableTableLabelProvider());
        this.tableTable.setContentProvider(this.buildTableTableContentProvider());
        this.tableTable.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((org.eclipse.jpt.db.Table)e1).getName().compareTo(((org.eclipse.jpt.db.Table)e2).getName());
            }
        });
        this.tableTable.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GenerateEntitiesWizardPage.this.handleTablesListSelectionChanged();
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000B && e.stateMask == 0) {
                    GenerateEntitiesWizardPage.this.editEntityNameIfPossible();
                    e.doit = false;
                }
            }
        });
        this.addCellEditors();
    }

    private void createButtonComposite(Group tablesGroup) {
        Composite buttonComposite = new Composite((Composite)tablesGroup, 0);
        GridLayout buttonLayout = new GridLayout(1, false);
        buttonComposite.setLayout((Layout)buttonLayout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        buttonComposite.setLayoutData((Object)data);
        Button selectAllButton = new Button(buttonComposite, 8);
        selectAllButton.setText(JptUiMessages.General_selectAll);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        selectAllButton.setLayoutData((Object)gridData);
        selectAllButton.addSelectionListener(this.buildSelectAllButtonSelectionListener());
        Button deselectAllButton = new Button(buttonComposite, 8);
        deselectAllButton.setText(JptUiMessages.General_deselectAll);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        deselectAllButton.setLayoutData((Object)gridData);
        deselectAllButton.addSelectionListener(this.buildDeselectAllButtonSelectionListener());
    }

    private void addColumnLayoutData(TableLayoutComposite layout) {
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
    }

    void editEntityNameIfPossible() {
        Object[] selected = ((IStructuredSelection)this.tableTable.getSelection()).toArray();
        if (selected.length == 1) {
            this.tableTable.editElement(selected[0], 1);
        }
    }

    private void addCellEditors() {
        this.tableTable.setColumnProperties(TABLE_TABLE_COLUMN_PROPERTIES);
        TextCellEditor[] editors = new TextCellEditor[TABLE_TABLE_COLUMN_PROPERTIES.length];
        editors[1] = new TextCellEditor((Composite)this.tableTable.getTable(), 4);
        this.tableTable.setCellEditors((CellEditor[])editors);
        this.tableTable.setCellModifier(this.buildTableTableCellModifier());
    }

    void handleTablesListSelectionChanged() {
        this.setPageComplete(true);
        if (this.noTablesAreSelected()) {
            this.setPageComplete(false);
        }
    }

    private IBaseLabelProvider buildTableTableLabelProvider() {
        return new TableTableLabelProvider();
    }

    private IContentProvider buildTableTableContentProvider() {
        return new TableTableContentProvider();
    }

    private ICellModifier buildTableTableCellModifier() {
        return new TableTableCellModifier();
    }

    Map<org.eclipse.jpt.db.Table, String> getSelectedTables() {
        Object[] checkedElements = this.tableTable.getCheckedElements();
        HashMap<org.eclipse.jpt.db.Table, String> selectedTables = new HashMap<org.eclipse.jpt.db.Table, String>(checkedElements.length);
        Object[] objectArray = checkedElements;
        int n = checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object checkedElement = objectArray[n2];
            org.eclipse.jpt.db.Table table = (org.eclipse.jpt.db.Table)checkedElement;
            selectedTables.put(table, this.entityNames.get(table));
            ++n2;
        }
        return selectedTables;
    }

    private boolean noTablesAreSelected() {
        return this.tableTable == null ? true : this.tableTable.getCheckedElements().length == 0;
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        this.doStatusUpdate();
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.fPackageStatus};
        this.updateStatus(status);
    }

    protected void updateStatus(IStatus status) {
        super.updateStatus(status);
        if (this.isPageComplete() && this.noTablesAreSelected()) {
            this.setPageComplete(false);
        }
    }

    String getEntityName(org.eclipse.jpt.db.Table table) {
        return this.entityNames.get(table);
    }

    boolean setEntityName(org.eclipse.jpt.db.Table table, String entityName) {
        String old = this.entityNames.put(table, entityName);
        return !entityName.equals(old);
    }

    boolean convertToJavaStyleIdentifiers() {
        return this.convertToJavaStyleIdentifiers;
    }

    boolean fieldAccessType() {
        return this.fieldAccessType;
    }

    String getCollectionTypeName() {
        return this.collectionTypeName;
    }

    String getCollectionAttributeNameSuffix() {
        return this.collectionAttributeNameSuffix;
    }

    int getFieldVisibility() {
        return this.fieldVisibility;
    }

    int getMethodVisibility() {
        return this.methodVisibility;
    }

    boolean generateGettersAndSetters() {
        return this.generateGettersAndSetters;
    }

    boolean generateDefaultConstructor() {
        return this.generateDefaultConstructor;
    }

    boolean serializable() {
        return this.serializable;
    }

    boolean generateSerialVersionUID() {
        return this.generateSerialVersionUID;
    }

    boolean generateEmbeddedIdForCompoundPK() {
        return this.generateEmbeddedIdForCompoundPK;
    }

    boolean synchronizePersistenceXml() {
        return this.synchronizePersistenceXml;
    }

    void setSynchronizePersistenceXml(boolean synchronizePersistenceXml) {
        this.synchronizePersistenceXml = synchronizePersistenceXml;
    }

    String getEmbeddedIdAttributeName() {
        return this.embeddedIdAttributeName;
    }

    String getPrimaryKeyMemberClassName() {
        return this.primaryKeyMemberClassName;
    }

    private SelectionListener buildSelectAllButtonSelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }

            public void widgetSelected(SelectionEvent event) {
                GenerateEntitiesWizardPage.this.selectAllTables();
            }
        };
    }

    private SelectionListener buildDeselectAllButtonSelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }

            public void widgetSelected(SelectionEvent event) {
                GenerateEntitiesWizardPage.this.deselectAllTables();
            }
        };
    }

    private SelectionListener buildSynchClassesSelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }

            public void widgetSelected(SelectionEvent event) {
                GenerateEntitiesWizardPage.this.setSynchronizePersistenceXml(GenerateEntitiesWizardPage.this.synchronizeClassesCheckBox.getSelection());
            }
        };
    }

    class TableTableCellModifier
    implements ICellModifier {
        TableTableCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return property.equals(TABLE_TABLE_COLUMN_PROPERTIES[1]);
        }

        public Object getValue(Object element, String property) {
            if (property.equals(TABLE_TABLE_COLUMN_PROPERTIES[1])) {
                return GenerateEntitiesWizardPage.this.getEntityName((org.eclipse.jpt.db.Table)element);
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof TableItem) {
                element = ((TableItem)element).getData();
            }
            if (!(element instanceof org.eclipse.jpt.db.Table)) {
                return;
            }
            org.eclipse.jpt.db.Table table = (org.eclipse.jpt.db.Table)element;
            boolean changed = true;
            if (property.equals(TABLE_TABLE_COLUMN_PROPERTIES[1])) {
                changed = GenerateEntitiesWizardPage.this.setEntityName(table, (String)value);
            }
            if (changed) {
                GenerateEntitiesWizardPage.this.tableTable.update((Object)table, new String[]{property});
            }
        }
    }

    static class TableTableContentProvider
    implements IStructuredContentProvider {
        TableTableContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return ((Collection)inputElement).toArray();
        }
    }

    class TableTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableTableLabelProvider() {
        }

        public String getText(Object element) {
            return ((org.eclipse.jpt.db.Table)element).getName();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element == null) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return ((org.eclipse.jpt.db.Table)element).getName();
                }
                case 1: {
                    return GenerateEntitiesWizardPage.this.getEntityName((org.eclipse.jpt.db.Table)element);
                }
            }
            throw new IllegalArgumentException("invalid column index: " + columnIndex);
        }
    }
}

