/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.ui.views;

import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIPlugin;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsValuesColumnLabelProvider
extends ColumnLabelProvider {
    private TreeViewer annotationTreeViewer;
    private Image true_image;
    private Image false_image;

    public AnnotationsValuesColumnLabelProvider(TreeViewer annotationTreeViewer) {
        this.annotationTreeViewer = annotationTreeViewer;
        this.true_image = JAXWSUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jst.ws.jaxws.ui", (String)"icons/obj16/true.gif").createImage();
        this.false_image = JAXWSUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jst.ws.jaxws.ui", (String)"icons/obj16/false.gif").createImage();
    }

    public String getText(Object element) {
        String text = "";
        if (element instanceof Method) {
            text = this.getTextForMethod((Method)element);
        }
        return text;
    }

    private String getTextForMethod(Method method) {
        String text = "";
        if (this.annotationTreeViewer.getInput() instanceof IAnnotatable) {
            text = this.getTextForMethod(method, (IAnnotatable)this.annotationTreeViewer.getInput());
        } else if (this.annotationTreeViewer.getInput() instanceof SingleVariableDeclaration) {
            text = this.getTextForMethod(method, (SingleVariableDeclaration)this.annotationTreeViewer.getInput());
        }
        return text;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getTextForMethod(Method method, IAnnotatable annotatedElement) {
        Class<?> returnType = method.getReturnType();
        try {
            IAnnotation[] annotations;
            IAnnotation[] iAnnotationArray = annotations = annotatedElement.getAnnotations();
            int n = annotations.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return "";
                }
                IAnnotation annotation = iAnnotationArray[n2];
                Class<?> declaringClass = method.getDeclaringClass();
                if (annotation.getElementName().equals(declaringClass.getSimpleName()) || annotation.getElementName().equals(declaringClass.getCanonicalName())) {
                    IMemberValuePair memberValuePair;
                    IMemberValuePair[] memberValuePairs;
                    IMemberValuePair[] iMemberValuePairArray = memberValuePairs = annotation.getMemberValuePairs();
                    int n3 = memberValuePairs.length;
                    int n4 = 0;
                    while (n4 < n3 && (memberValuePair = iMemberValuePairArray[n4]).getValue() != null) {
                        if (memberValuePair.getMemberName().equals(method.getName())) {
                            if (returnType.equals(String.class)) {
                                return memberValuePair.getValue().toString();
                            }
                            if (returnType.equals(Class.class)) {
                                return String.valueOf(memberValuePair.getValue().toString()) + ".class";
                            }
                            if (returnType.isPrimitive()) {
                                if (returnType.equals(Byte.TYPE)) return memberValuePair.getValue().toString();
                                if (returnType.equals(Short.TYPE)) return memberValuePair.getValue().toString();
                                if (returnType.equals(Integer.TYPE)) return memberValuePair.getValue().toString();
                                if (returnType.equals(Long.TYPE)) return memberValuePair.getValue().toString();
                                if (returnType.equals(Float.TYPE)) return memberValuePair.getValue().toString();
                                if (returnType.equals(Double.TYPE)) {
                                    return memberValuePair.getValue().toString();
                                }
                            }
                            if (returnType.isArray()) {
                                Object[] values = (Object[])memberValuePair.getValue();
                                if (values == null) return "[]{}";
                                if (values.length <= 0) return "[]{}";
                                return "[]{...}";
                            }
                            if (returnType.isEnum()) {
                                String enumValue = memberValuePair.getValue().toString();
                                return enumValue.substring(enumValue.lastIndexOf(".") + 1);
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException jme) {
            JAXWSUIPlugin.log(jme.getStatus());
        }
        return "";
    }

    private String getTextForMethod(Method method, SingleVariableDeclaration singleVariableDeclaration) {
        Class<?> returnType = method.getReturnType();
        List modifiers = singleVariableDeclaration.modifiers();
        for (IExtendedModifier extendedModifier : modifiers) {
            Class<?> declaringClass;
            NormalAnnotation normalAnnotation;
            String annotationName;
            if (!(extendedModifier instanceof NormalAnnotation) || !(annotationName = AnnotationUtils.getAnnotationName((Annotation)(normalAnnotation = (NormalAnnotation)extendedModifier))).equals((declaringClass = method.getDeclaringClass()).getSimpleName()) && !annotationName.equals(declaringClass.getCanonicalName())) continue;
            List memberValuePairs = normalAnnotation.values();
            for (MemberValuePair memberValuePair : memberValuePairs) {
                if (!memberValuePair.getName().toString().equals(method.getName())) continue;
                if (returnType.equals(String.class)) {
                    StringLiteral stringLiteral = (StringLiteral)memberValuePair.getValue();
                    return stringLiteral.getLiteralValue();
                }
                if (returnType.isPrimitive() && (returnType.equals(Byte.TYPE) || returnType.equals(Short.TYPE) || returnType.equals(Integer.TYPE) || returnType.equals(Long.TYPE) || returnType.equals(Float.TYPE) || returnType.equals(Double.TYPE))) {
                    return memberValuePair.getValue().toString();
                }
                if (!returnType.isEnum()) continue;
                String enumValue = memberValuePair.getValue().toString();
                return enumValue.substring(enumValue.lastIndexOf(".") + 1);
            }
        }
        return "";
    }

    public Image getImage(Object element) {
        try {
            if (element instanceof Class) {
                return this.getImageForClass((Class)element);
            }
            if (element instanceof Method) {
                return this.getImageForMethod((Method)element);
            }
        }
        catch (JavaModelException jme) {
            JAXWSUIPlugin.log(jme.getStatus());
        }
        return null;
    }

    private Image getImageForClass(Class<?> aClass) throws JavaModelException {
        if (this.annotationTreeViewer.getInput() instanceof IAnnotatable) {
            return this.getImageForClass(aClass, (IAnnotatable)this.annotationTreeViewer.getInput());
        }
        if (this.annotationTreeViewer.getInput() instanceof SingleVariableDeclaration) {
            return this.getImageForClass(aClass, (SingleVariableDeclaration)this.annotationTreeViewer.getInput());
        }
        return this.false_image;
    }

    private Image getImageForClass(Class<?> aClass, IAnnotatable annotatedElement) throws JavaModelException {
        IAnnotation[] annotations;
        IAnnotation[] iAnnotationArray = annotations = annotatedElement.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            String annotationName = annotation.getElementName();
            if (AnnotationUtils.isAnnotationPresent((IJavaElement)((IJavaElement)annotatedElement), (String)annotationName) && (annotationName.equals(aClass.getSimpleName()) || annotationName.equals(aClass.getCanonicalName()))) {
                return this.true_image;
            }
            ++n2;
        }
        return this.false_image;
    }

    private Image getImageForClass(Class<?> aClass, SingleVariableDeclaration parameter) {
        List modifiers = parameter.modifiers();
        for (IExtendedModifier extendedModifier : modifiers) {
            if (!(extendedModifier instanceof Annotation)) continue;
            Annotation annotation = (Annotation)extendedModifier;
            String annotationName = AnnotationUtils.getAnnotationName((Annotation)annotation);
            if (!AnnotationUtils.isAnnotationPresent((SingleVariableDeclaration)parameter, (Annotation)annotation) || !annotationName.equals(aClass.getSimpleName()) && !annotationName.equals(aClass.getCanonicalName())) continue;
            return this.true_image;
        }
        return this.false_image;
    }

    private Image getImageForMethod(Method method) throws JavaModelException {
        Class<?> returnType = method.getReturnType();
        if (returnType.equals(Boolean.TYPE)) {
            if (this.annotationTreeViewer.getInput() instanceof IAnnotatable) {
                return this.getImageForMethod(method, (IAnnotatable)this.annotationTreeViewer.getInput());
            }
            if (this.annotationTreeViewer.getInput() instanceof SingleVariableDeclaration) {
                return this.getImageForMethod(method, (SingleVariableDeclaration)this.annotationTreeViewer.getInput());
            }
        }
        return null;
    }

    private Image getImageForMethod(Method method, IAnnotatable annotatedElement) throws JavaModelException {
        IAnnotation[] annotations;
        IAnnotation[] iAnnotationArray = annotations = annotatedElement.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> declaringClass;
            IAnnotation annotation = iAnnotationArray[n2];
            String annotationName = annotation.getElementName();
            if (annotationName.equals((declaringClass = method.getDeclaringClass()).getSimpleName()) || annotationName.equals(declaringClass.getCanonicalName())) {
                IMemberValuePair[] memberValuePairs;
                IMemberValuePair[] iMemberValuePairArray = memberValuePairs = annotation.getMemberValuePairs();
                int n3 = memberValuePairs.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemberValuePair memberValuePair = iMemberValuePairArray[n4];
                    if (memberValuePair.getMemberName().equals(method.getName()) && Boolean.parseBoolean(memberValuePair.getValue().toString())) {
                        return this.true_image;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return this.false_image;
    }

    private Image getImageForMethod(Method method, SingleVariableDeclaration singleVariableDeclaration) throws JavaModelException {
        List modifiers = singleVariableDeclaration.modifiers();
        for (IExtendedModifier extendedModifier : modifiers) {
            Class<?> declaringClass;
            NormalAnnotation annotation;
            String annotationName;
            if (!(extendedModifier instanceof NormalAnnotation) || !(annotationName = AnnotationUtils.getAnnotationName((Annotation)(annotation = (NormalAnnotation)extendedModifier))).equals((declaringClass = method.getDeclaringClass()).getSimpleName()) && !annotationName.equals(declaringClass.getCanonicalName())) continue;
            List memberValuePairs = annotation.values();
            for (MemberValuePair memberValuePair : memberValuePairs) {
                BooleanLiteral booleanLiteral;
                if (!memberValuePair.getName().toString().equals(method.getName()) || !(booleanLiteral = (BooleanLiteral)memberValuePair.getValue()).booleanValue()) continue;
                return this.true_image;
            }
        }
        return this.false_image;
    }

    public void dispose() {
        super.dispose();
        this.true_image.dispose();
        this.false_image.dispose();
    }
}

