/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.ui.views;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.AnnotationsManager;
import org.eclipse.jst.ws.annotations.core.initialization.IAnnotationAttributeInitializer;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIMessages;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIPlugin;
import org.eclipse.jst.ws.internal.jaxws.ui.views.AnnotationArrayCellEditor;
import org.eclipse.jst.ws.internal.jaxws.ui.views.AnnotationsView;
import org.eclipse.jst.ws.internal.jaxws.ui.views.ClassDialogCellEditor;
import org.eclipse.jst.ws.jaxws.core.utils.JDTUtils;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.IUndoManager;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsValuesEditingSupport
extends EditingSupport {
    private AnnotationsView annotationsView;
    private TreeViewer treeViewer;
    private TextCellEditor textCellEditor;
    private CheckboxCellEditor checkboxCellEditor;
    private ComboBoxCellEditor comboBoxCellEditor;
    private ClassDialogCellEditor classDialogCellEditor;
    private AnnotationArrayCellEditor annotationArrayCellEditor;

    public AnnotationsValuesEditingSupport(AnnotationsView annotationsView, TreeViewer treeViewer) {
        super((ColumnViewer)treeViewer);
        this.treeViewer = treeViewer;
        this.annotationsView = annotationsView;
        this.textCellEditor = new TextCellEditor((Composite)treeViewer.getTree());
        this.checkboxCellEditor = new CheckboxCellEditor((Composite)treeViewer.getTree());
        this.comboBoxCellEditor = new ComboBoxCellEditor((Composite)treeViewer.getTree(), new String[0]);
        this.classDialogCellEditor = new ClassDialogCellEditor((Composite)treeViewer.getTree());
        this.annotationArrayCellEditor = new AnnotationArrayCellEditor((Composite)treeViewer.getTree(), new Object[0]);
    }

    protected boolean canEdit(Object element) {
        if (element instanceof Method) {
            Method method = (Method)element;
            return (Boolean)this.getValue(method.getDeclaringClass());
        }
        return true;
    }

    protected CellEditor getCellEditor(Object element) {
        if (element instanceof Class) {
            return this.checkboxCellEditor;
        }
        if (element instanceof Method) {
            Method method = (Method)element;
            final Class<?> returnType = method.getReturnType();
            if (returnType.isEnum()) {
                ?[] enumConstants = returnType.getEnumConstants();
                String[] values = new String[enumConstants.length];
                int i = 0;
                while (i < enumConstants.length) {
                    values[i] = enumConstants[i].toString();
                    ++i;
                }
                this.comboBoxCellEditor.setItems(values);
                return this.comboBoxCellEditor;
            }
            if (returnType.equals(Boolean.TYPE)) {
                return this.checkboxCellEditor;
            }
            if (returnType.equals(Class.class)) {
                return this.classDialogCellEditor;
            }
            if (returnType.isArray()) {
                this.annotationArrayCellEditor.setMethod(method);
                return this.annotationArrayCellEditor;
            }
            if (returnType.isPrimitive()) {
                this.textCellEditor.setValidator(new ICellEditorValidator(){

                    public String isValid(Object value) {
                        try {
                            if (returnType.equals(Byte.TYPE)) {
                                Byte.parseByte((String)value);
                            }
                            if (returnType.equals(Short.TYPE)) {
                                Short.parseShort((String)value);
                            }
                            if (returnType.equals(Integer.TYPE)) {
                                Integer.parseInt((String)value);
                            }
                            if (returnType.equals(Long.TYPE)) {
                                Long.parseLong((String)value);
                            }
                            if (returnType.equals(Float.TYPE)) {
                                Float.parseFloat((String)value);
                            }
                            if (returnType.equals(Double.TYPE)) {
                                Double.parseDouble((String)value);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            return String.valueOf(JAXWSUIMessages.ANNOTATION_EDITING_SUPPORT_NOT_VALID_MESSAGE_PREFIX) + returnType.getSimpleName();
                        }
                        return null;
                    }
                });
                return this.textCellEditor;
            }
            return this.textCellEditor;
        }
        return this.checkboxCellEditor;
    }

    protected Object getValue(Object element) {
        if (element instanceof Class) {
            return this.getValueForClass((Class)element);
        }
        if (element instanceof Method) {
            return this.getValueForMethod((Method)element);
        }
        return null;
    }

    private Object getValueForClass(Class<?> aClass) {
        if (this.treeViewer.getInput() instanceof IAnnotatable) {
            return this.getValueForClass(aClass, (IAnnotatable)this.treeViewer.getInput());
        }
        if (this.treeViewer.getInput() instanceof SingleVariableDeclaration) {
            return this.getValueForClass(aClass, (SingleVariableDeclaration)this.treeViewer.getInput());
        }
        return Boolean.FALSE;
    }

    private Object getValueForClass(Class<?> aClass, IAnnotatable annotatedElement) {
        try {
            IAnnotation[] annotations;
            IAnnotation[] iAnnotationArray = annotations = annotatedElement.getAnnotations();
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotation annotation = iAnnotationArray[n2];
                String annotationName = annotation.getElementName();
                if (AnnotationUtils.isAnnotationPresent((IJavaElement)((IJavaElement)annotatedElement), (String)annotationName) && (annotationName.equals(aClass.getSimpleName()) || annotationName.equals(aClass.getCanonicalName()))) {
                    return Boolean.TRUE;
                }
                ++n2;
            }
        }
        catch (JavaModelException jme) {
            JAXWSUIPlugin.log(jme.getStatus());
        }
        return Boolean.FALSE;
    }

    private Object getValueForClass(Class<?> aClass, SingleVariableDeclaration parameter) {
        List modifiers = parameter.modifiers();
        for (IExtendedModifier extendedModifier : modifiers) {
            if (!(extendedModifier instanceof org.eclipse.jdt.core.dom.Annotation)) continue;
            org.eclipse.jdt.core.dom.Annotation annotation = (org.eclipse.jdt.core.dom.Annotation)extendedModifier;
            String annotationName = AnnotationUtils.getAnnotationName((org.eclipse.jdt.core.dom.Annotation)annotation);
            if (!AnnotationUtils.isAnnotationPresent((SingleVariableDeclaration)parameter, (org.eclipse.jdt.core.dom.Annotation)annotation) || !annotationName.equals(aClass.getSimpleName()) && !annotationName.equals(aClass.getCanonicalName())) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Object getValueForMethod(Method method) {
        Object value = null;
        try {
            if (this.treeViewer.getInput() instanceof IAnnotatable) {
                value = this.getValueForMethod(method, (IAnnotatable)this.treeViewer.getInput());
            } else if (this.treeViewer.getInput() instanceof SingleVariableDeclaration) {
                value = this.getValueForMethod(method, (SingleVariableDeclaration)this.treeViewer.getInput());
            }
        }
        catch (JavaModelException jme) {
            JAXWSUIPlugin.log(jme.getStatus());
        }
        return value;
    }

    private Object getValueForMethod(Method method, IAnnotatable annotatedElement) throws JavaModelException {
        IAnnotation[] annotations;
        Class<?> returnType = method.getReturnType();
        IAnnotation[] iAnnotationArray = annotations = annotatedElement.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            Class<?> declaringClass = method.getDeclaringClass();
            String annotationName = annotation.getElementName();
            if (annotationName.equals(declaringClass.getSimpleName()) || annotationName.equals(declaringClass.getCanonicalName())) {
                IMemberValuePair[] memberValuePairs;
                IMemberValuePair[] iMemberValuePairArray = memberValuePairs = annotation.getMemberValuePairs();
                int n3 = memberValuePairs.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemberValuePair memberValuePair = iMemberValuePairArray[n4];
                    if (memberValuePair.getMemberName().equals(method.getName())) {
                        if (returnType.equals(String.class)) {
                            return memberValuePair.getValue();
                        }
                        if (returnType.isEnum()) {
                            String enumValue = memberValuePair.getValue().toString();
                            String literal = enumValue.substring(enumValue.lastIndexOf(".") + 1);
                            ?[] enumConstants = method.getReturnType().getEnumConstants();
                            int i = 0;
                            while (i < enumConstants.length) {
                                if (enumConstants[i].toString().equals(literal)) {
                                    return i;
                                }
                                ++i;
                            }
                        }
                        if (returnType.equals(Class.class)) {
                            return memberValuePair.getValue();
                        }
                        if (returnType.equals(Boolean.TYPE)) {
                            return memberValuePair.getValue();
                        }
                        if (returnType.isPrimitive()) {
                            return "";
                        }
                        if (returnType.isArray()) {
                            if (memberValuePair.getValueKind() == 11) {
                                Object[] arrayValues = (Object[])memberValuePair.getValue();
                                int i = 0;
                                while (i < arrayValues.length) {
                                    String value = arrayValues[i].toString();
                                    arrayValues[i] = String.valueOf(value) + ".class";
                                    ++i;
                                }
                                return arrayValues;
                            }
                            return memberValuePair.getValue();
                        }
                    }
                    ++n4;
                }
                return this.getDefaultValueForMethod(returnType);
            }
            ++n2;
        }
        return null;
    }

    private Object getValueForMethod(Method method, SingleVariableDeclaration parameter) {
        Class<?> returnType = method.getReturnType();
        List modifiers = parameter.modifiers();
        for (IExtendedModifier extendedModifier : modifiers) {
            if (!(extendedModifier instanceof NormalAnnotation)) continue;
            NormalAnnotation normalAnnotation = (NormalAnnotation)extendedModifier;
            Class<?> declaringClass = method.getDeclaringClass();
            String annotationName = AnnotationUtils.getAnnotationName((org.eclipse.jdt.core.dom.Annotation)normalAnnotation);
            if (!annotationName.equals(declaringClass.getSimpleName()) && !annotationName.equals(declaringClass.getCanonicalName())) continue;
            List memberValuePairs = normalAnnotation.values();
            for (MemberValuePair memberValuePair : memberValuePairs) {
                if (!memberValuePair.getName().toString().equals(method.getName())) continue;
                if (returnType.equals(String.class)) {
                    StringLiteral stringLiteral = (StringLiteral)memberValuePair.getValue();
                    return stringLiteral.getLiteralValue();
                }
                if (returnType.isEnum()) {
                    QualifiedName enumValue = (QualifiedName)memberValuePair.getValue();
                    SimpleName literal = enumValue.getName();
                    ?[] enumConstants = method.getReturnType().getEnumConstants();
                    int i = 0;
                    while (i < enumConstants.length) {
                        if (enumConstants[i].toString().equals(literal.getIdentifier())) {
                            return i;
                        }
                        ++i;
                    }
                }
                if (returnType.equals(Class.class)) {
                    return memberValuePair.getValue();
                }
                if (!returnType.equals(Boolean.TYPE)) continue;
                BooleanLiteral booleanLiteral = (BooleanLiteral)memberValuePair.getValue();
                return booleanLiteral.booleanValue();
            }
            return this.getDefaultValueForMethod(returnType);
        }
        return null;
    }

    private Object getDefaultValueForMethod(Class<?> returnType) {
        if (returnType.equals(String.class)) {
            return "";
        }
        if (returnType.equals(Boolean.TYPE)) {
            return Boolean.FALSE;
        }
        if (returnType.isEnum()) {
            return -1;
        }
        if (returnType.isPrimitive()) {
            return "";
        }
        if (returnType.isArray()) {
            return new Object[0];
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        if (value == null) {
            return;
        }
        try {
            Class annotationClass;
            if (element instanceof Class && (annotationClass = AnnotationsManager.getAnnotationDefinitionForClass((Object)element).getAnnotationClass()) != null) {
                this.setValueForClass(annotationClass, (Boolean)value);
            }
            if (element instanceof Method) {
                this.setValueForMethod((Method)element, value);
            }
        }
        catch (CoreException ce) {
            JAXWSUIPlugin.log(ce.getStatus());
        }
    }

    private void setValueForClass(Class<? extends Annotation> annotationClass, Boolean annotate) throws CoreException {
        Object viewerInput = this.treeViewer.getInput();
        IAnnotationAttributeInitializer annotationAttributeInitializer = AnnotationsManager.getAnnotationDefinitionForClass(annotationClass).getAnnotationAttributeInitializer();
        if (viewerInput instanceof IPackageDeclaration) {
            this.setValueForClass(annotationClass, annotate, (IPackageDeclaration)viewerInput, annotationAttributeInitializer);
        } else if (viewerInput instanceof IMember) {
            this.setValueForClass(annotationClass, annotate, (IMember)viewerInput, annotationAttributeInitializer);
        } else if (viewerInput instanceof SingleVariableDeclaration) {
            this.setValueForClass(annotationClass, annotate, (SingleVariableDeclaration)viewerInput, annotationAttributeInitializer);
        }
    }

    private void setValueForClass(Class<? extends Annotation> annotationClass, Boolean annotate, IPackageDeclaration packageDeclaration, IAnnotationAttributeInitializer annotationAttributeInitializer) throws CoreException {
        ICompilationUnit source = JDTUtils.getCompilationUnitFromFile((IFile)((IFile)packageDeclaration.getResource()));
        CompilationUnit compilationUnit = JDTUtils.getCompilationUnit((ICompilationUnit)source);
        PackageDeclaration pkgDeclaration = compilationUnit.getPackage();
        AST ast = pkgDeclaration.getAST();
        ASTRewrite rewriter = ASTRewrite.create((AST)ast);
        List<MemberValuePair> memberValueParis = this.getMemberValuePairs(annotationAttributeInitializer, (ASTNode)pkgDeclaration, ast, annotationClass);
        org.eclipse.jdt.core.dom.Annotation annotation = AnnotationsCore.createAnnotation((AST)ast, annotationClass, (String)annotationClass.getSimpleName(), memberValueParis);
        TextFileChange textFileChange = AnnotationUtils.createTextFileChange((String)"AC", (IFile)((IFile)source.getResource()));
        if (annotate.booleanValue()) {
            AnnotationUtils.addAnnotationToPackageDeclaration((ICompilationUnit)source, (PackageDeclaration)pkgDeclaration, (ASTRewrite)rewriter, (org.eclipse.jdt.core.dom.Annotation)annotation, (TextFileChange)textFileChange);
        } else {
            AnnotationUtils.removeAnnotationFromPackageDeclaration((ICompilationUnit)source, (PackageDeclaration)pkgDeclaration, (ASTRewrite)rewriter, (org.eclipse.jdt.core.dom.Annotation)annotation, (TextFileChange)textFileChange);
        }
        AnnotationUtils.addImportEdit((CompilationUnit)compilationUnit, annotationClass, (TextFileChange)textFileChange, (boolean)annotate);
        this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)textFileChange);
    }

    private void setValueForClass(Class<? extends Annotation> annotationClass, Boolean annotate, IMember member, IAnnotationAttributeInitializer annotationAttributeInitializer) throws CoreException {
        ICompilationUnit source = member.getCompilationUnit();
        CompilationUnit compilationUnit = JDTUtils.getCompilationUnit((ICompilationUnit)source);
        AST ast = compilationUnit.getAST();
        ASTRewrite rewriter = ASTRewrite.create((AST)ast);
        List<MemberValuePair> memberValueParis = this.getMemberValuePairs(annotationAttributeInitializer, (IJavaElement)member, ast, annotationClass);
        org.eclipse.jdt.core.dom.Annotation annotation = AnnotationsCore.createAnnotation((AST)ast, annotationClass, (String)annotationClass.getSimpleName(), memberValueParis);
        TextFileChange textFileChange = AnnotationUtils.createTextFileChange((String)"AC", (IFile)((IFile)source.getResource()));
        if (annotate.booleanValue()) {
            if (member.getElementType() == 7) {
                AnnotationUtils.addAnnotationToType((ICompilationUnit)source, (CompilationUnit)compilationUnit, (ASTRewrite)rewriter, (IType)source.findPrimaryType(), (org.eclipse.jdt.core.dom.Annotation)annotation, (TextFileChange)textFileChange);
            } else if (member.getElementType() == 9) {
                AnnotationUtils.addAnnotationToMethod((ICompilationUnit)source, (CompilationUnit)compilationUnit, (ASTRewrite)rewriter, (IMethod)((IMethod)member), (org.eclipse.jdt.core.dom.Annotation)annotation, (TextFileChange)textFileChange);
            } else if (member.getElementType() == 8) {
                AnnotationUtils.addAnnotationToField((ICompilationUnit)source, (CompilationUnit)compilationUnit, (ASTRewrite)rewriter, (IField)((IField)member), (org.eclipse.jdt.core.dom.Annotation)annotation, (TextFileChange)textFileChange);
            }
        } else {
            member.getElementType();
            if (member.getElementType() == 7) {
                AnnotationUtils.removeAnnotationFromType((ICompilationUnit)source, (CompilationUnit)compilationUnit, (ASTRewrite)rewriter, (IType)source.findPrimaryType(), (org.eclipse.jdt.core.dom.Annotation)annotation, (TextFileChange)textFileChange);
            } else if (member.getElementType() == 9) {
                AnnotationUtils.removeAnnotationFromMethod((ICompilationUnit)source, (CompilationUnit)compilationUnit, (ASTRewrite)rewriter, (IMethod)((IMethod)member), (org.eclipse.jdt.core.dom.Annotation)annotation, (TextFileChange)textFileChange);
            } else if (member.getElementType() == 8) {
                AnnotationUtils.removeAnnotationFromField((ICompilationUnit)source, (CompilationUnit)compilationUnit, (ASTRewrite)rewriter, (IField)((IField)member), (org.eclipse.jdt.core.dom.Annotation)annotation, (TextFileChange)textFileChange);
            }
        }
        AnnotationUtils.addImportEdit((CompilationUnit)compilationUnit, annotationClass, (TextFileChange)textFileChange, (boolean)annotate);
        this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)textFileChange);
    }

    private void setValueForClass(Class<? extends Annotation> annotationClass, Boolean annotate, SingleVariableDeclaration parameter, IAnnotationAttributeInitializer annotationAttributeInitializer) throws CoreException {
        ITextEditor txtEditor = (ITextEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        IFile file = ((IFileEditorInput)txtEditor.getEditorInput()).getFile();
        ICompilationUnit source = JDTUtils.getCompilationUnitFromFile((IFile)file);
        CompilationUnit compilationUnit = JDTUtils.getCompilationUnit((ICompilationUnit)source);
        AST ast = parameter.getAST();
        ASTRewrite rewriter = ASTRewrite.create((AST)ast);
        List<MemberValuePair> memberValueParis = this.getMemberValuePairs(annotationAttributeInitializer, (ASTNode)parameter, ast, annotationClass);
        org.eclipse.jdt.core.dom.Annotation annotation = AnnotationsCore.createAnnotation((AST)ast, annotationClass, (String)annotationClass.getSimpleName(), memberValueParis);
        TextFileChange textFileChange = AnnotationUtils.createTextFileChange((String)"AC", (IFile)((IFile)source.getResource()));
        if (annotate.booleanValue()) {
            AnnotationUtils.addAnnotationToMethodParameter((ICompilationUnit)source, (ASTRewrite)rewriter, (SingleVariableDeclaration)parameter, (org.eclipse.jdt.core.dom.Annotation)annotation, (TextFileChange)textFileChange);
        } else {
            AnnotationUtils.removeAnnotationFromMethodParameter((ICompilationUnit)source, (ASTRewrite)rewriter, (SingleVariableDeclaration)parameter, (org.eclipse.jdt.core.dom.Annotation)annotation, (TextFileChange)textFileChange);
        }
        AnnotationUtils.addImportEdit((CompilationUnit)compilationUnit, annotationClass, (TextFileChange)textFileChange, (boolean)annotate);
        this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)textFileChange);
    }

    private List<MemberValuePair> getMemberValuePairs(IAnnotationAttributeInitializer annotationAttributeInitializer, ASTNode astNode, AST ast, Class<? extends Annotation> annotationClass) {
        if (annotationAttributeInitializer != null) {
            return annotationAttributeInitializer.getMemberValuePairs(astNode, ast, annotationClass);
        }
        return Collections.emptyList();
    }

    private List<MemberValuePair> getMemberValuePairs(IAnnotationAttributeInitializer annotationAttributeInitializer, IJavaElement javaElement, AST ast, Class<? extends Annotation> annotationClass) {
        if (annotationAttributeInitializer != null) {
            return annotationAttributeInitializer.getMemberValuePairs(javaElement, ast, annotationClass);
        }
        return Collections.emptyList();
    }

    private void setValueForMethod(Method method, Object value) throws CoreException {
        if (((Boolean)this.getValue(method.getDeclaringClass())).booleanValue()) {
            Object viewerInput = this.treeViewer.getInput();
            if (viewerInput instanceof IAnnotatable) {
                this.setValueForMethod(method, value, (IJavaElement)viewerInput);
            } else if (this.treeViewer.getInput() instanceof SingleVariableDeclaration) {
                this.setValueForMethod(method, value, (SingleVariableDeclaration)this.treeViewer.getInput());
            }
        }
    }

    private ICompilationUnit getCompilationUnitForType(IJavaElement javaElement) throws JavaModelException {
        int elementType = javaElement.getElementType();
        if (elementType == 7) {
            IType type = (IType)javaElement.getPrimaryElement();
            return type.getCompilationUnit();
        }
        if (elementType == 9) {
            IMethod method = (IMethod)javaElement.getPrimaryElement();
            return method.getCompilationUnit();
        }
        if (elementType == 8) {
            IField field = (IField)javaElement.getPrimaryElement();
            return field.getCompilationUnit();
        }
        return JDTUtils.getCompilationUnitFromFile((IFile)((IFile)javaElement.getCorrespondingResource()));
    }

    private void setValueForMethod(Method method, Object value, IJavaElement javaElement) throws CoreException {
        IAnnotation[] annotations;
        ICompilationUnit source = this.getCompilationUnitForType(javaElement);
        CompilationUnit compilationUnit = JDTUtils.getCompilationUnit((ICompilationUnit)source);
        AST ast = compilationUnit.getAST();
        ASTRewrite rewriter = ASTRewrite.create((AST)ast);
        TextFileChange textFileChange = AnnotationUtils.createTextFileChange((String)"AC", (IFile)((IFile)source.getResource()));
        IAnnotatable annotatedElement = (IAnnotatable)javaElement;
        IAnnotation[] iAnnotationArray = annotations = annotatedElement.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            Class<?> declaringClass = method.getDeclaringClass();
            String annotationName = annotation.getElementName();
            if (annotationName.equals(declaringClass.getSimpleName()) || annotationName.equals(declaringClass.getCanonicalName())) {
                IMemberValuePair memberValuePair;
                IMemberValuePair[] memberValuePairs = annotation.getMemberValuePairs();
                boolean hasMemberValuePair = false;
                IMemberValuePair[] iMemberValuePairArray = memberValuePairs;
                int n3 = memberValuePairs.length;
                int n4 = 0;
                while (n4 < n3) {
                    ASTNode memberValue;
                    memberValuePair = iMemberValuePairArray[n4];
                    if (memberValuePair.getMemberName().equals(method.getName()) && (memberValue = this.getMemberValuePairValue(ast, method, value)) != null) {
                        AnnotationUtils.updateMemberValuePairValue((ICompilationUnit)source, (CompilationUnit)compilationUnit, (ASTRewrite)rewriter, (IJavaElement)javaElement, (IAnnotation)annotation, (IMemberValuePair)memberValuePair, (ASTNode)memberValue, (TextFileChange)textFileChange);
                        hasMemberValuePair = true;
                        break;
                    }
                    ++n4;
                }
                if (!hasMemberValuePair && (memberValuePair = this.getMemberValuePair(ast, method, value)) != null) {
                    AnnotationUtils.addMemberValuePairToAnnotation((ICompilationUnit)source, (CompilationUnit)compilationUnit, (ASTRewrite)rewriter, (IJavaElement)javaElement, (IAnnotation)annotation, (ASTNode)memberValuePair, (TextFileChange)textFileChange);
                    break;
                }
            }
            ++n2;
        }
        this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)textFileChange);
    }

    private void setValueForMethod(Method method, Object value, SingleVariableDeclaration parameter) throws CoreException {
        ITextEditor txtEditor = (ITextEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        IFile file = ((IFileEditorInput)txtEditor.getEditorInput()).getFile();
        ICompilationUnit source = JDTUtils.getCompilationUnitFromFile((IFile)file);
        CompilationUnit compilationUnit = JDTUtils.getCompilationUnit((ICompilationUnit)source);
        AST ast = parameter.getAST();
        ASTRewrite rewriter = ASTRewrite.create((AST)ast);
        TextFileChange textFileChange = AnnotationUtils.createTextFileChange((String)"AC", (IFile)((IFile)source.getResource()));
        List modifiers = parameter.modifiers();
        for (IExtendedModifier extendedModifier : modifiers) {
            MemberValuePair memberValuePair2;
            Class<?> declaringClass;
            NormalAnnotation normalAnnotation;
            String annotationName;
            if (!(extendedModifier instanceof NormalAnnotation) || !(annotationName = AnnotationUtils.getAnnotationName((org.eclipse.jdt.core.dom.Annotation)(normalAnnotation = (NormalAnnotation)extendedModifier))).equals((declaringClass = method.getDeclaringClass()).getSimpleName()) && !annotationName.equals(declaringClass.getCanonicalName())) continue;
            List memberValuePairs = normalAnnotation.values();
            boolean hasMemberValuePair = false;
            for (MemberValuePair memberValuePair2 : memberValuePairs) {
                ASTNode memberValue;
                if (!memberValuePair2.getName().toString().equals(method.getName()) || (memberValue = this.getMemberValuePairValue(ast, method, value)) == null) continue;
                AnnotationUtils.updateMemberValuePairValue((ICompilationUnit)source, (CompilationUnit)compilationUnit, (ASTRewrite)rewriter, (NormalAnnotation)normalAnnotation, (MemberValuePair)memberValuePair2, (ASTNode)memberValue, (TextFileChange)textFileChange);
                hasMemberValuePair = true;
                break;
            }
            if (hasMemberValuePair || (memberValuePair2 = this.getMemberValuePair(ast, method, value)) == null) continue;
            AnnotationUtils.addMemberValuePairToAnnotation((ICompilationUnit)source, (CompilationUnit)compilationUnit, (ASTRewrite)rewriter, (NormalAnnotation)normalAnnotation, (ASTNode)memberValuePair2, (TextFileChange)textFileChange);
            break;
        }
        this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)textFileChange);
    }

    private ASTNode getMemberValuePairValue(AST ast, Method method, Object value) {
        int selected;
        Class<?> returnType = method.getReturnType();
        if (returnType.equals(String.class)) {
            return AnnotationsCore.createStringLiteral((AST)ast, (String)value.toString());
        }
        if (returnType.equals(Boolean.TYPE)) {
            return AnnotationsCore.createBooleanLiteral((AST)ast, (boolean)((Boolean)value));
        }
        if (returnType.isPrimitive() && (returnType.equals(Byte.TYPE) || returnType.equals(Short.TYPE) || returnType.equals(Integer.TYPE) || returnType.equals(Long.TYPE) || returnType.equals(Float.TYPE) || returnType.equals(Double.TYPE))) {
            return AnnotationsCore.createNumberLiteral((AST)ast, (String)value.toString());
        }
        if (returnType.isArray()) {
            return AnnotationsCore.createArrayValueLiteral((AST)ast, (Method)method, (Object[])((Object[])value));
        }
        if (returnType.equals(Class.class)) {
            return AnnotationsCore.createTypeLiteral((AST)ast, (String)value.toString());
        }
        if (returnType.isEnum() && (selected = ((Integer)value).intValue()) != -1) {
            return AnnotationsCore.createEnumLiteral((AST)ast, (String)method.getDeclaringClass().getCanonicalName(), method.getReturnType().getEnumConstants()[selected]);
        }
        return null;
    }

    private ASTNode getMemberValuePair(AST ast, Method method, Object value) {
        int selected;
        Class<?> returnType = method.getReturnType();
        if (returnType.equals(String.class)) {
            return AnnotationsCore.createStringMemberValuePair((AST)ast, (String)method.getName(), (Object)value);
        }
        if (returnType.equals(Boolean.TYPE)) {
            return AnnotationsCore.createBooleanMemberValuePair((AST)ast, (String)method.getName(), (Object)value);
        }
        if (returnType.isPrimitive() && (returnType.equals(Byte.TYPE) || returnType.equals(Short.TYPE) || returnType.equals(Integer.TYPE) || returnType.equals(Long.TYPE) || returnType.equals(Float.TYPE) || returnType.equals(Double.TYPE))) {
            return AnnotationsCore.createNumberMemberValuePair((AST)ast, (String)method.getName(), (Object)value.toString());
        }
        if (returnType.isArray()) {
            return AnnotationsCore.createArrayMemberValuePair((AST)ast, (Method)method, (Object[])((Object[])value));
        }
        if (returnType.equals(Class.class)) {
            return AnnotationsCore.createTypeMemberValuePair((AST)ast, (String)method.getName(), (Object)value.toString());
        }
        if (returnType.isEnum() && (selected = ((Integer)value).intValue()) != -1) {
            return AnnotationsCore.createEnumMemberValuePair((AST)ast, (String)method.getDeclaringClass().getCanonicalName(), (String)method.getName(), method.getReturnType().getEnumConstants()[selected]);
        }
        return null;
    }

    private void executeChange(IProgressMonitor monitor, Change change) {
        Change undoChange;
        IUndoManager manager;
        block8: {
            if (change == null) {
                return;
            }
            manager = RefactoringCore.getUndoManager();
            boolean successful = false;
            undoChange = null;
            try {
                try {
                    change.initializeValidationData(monitor);
                    RefactoringStatus valid = change.isValid(monitor);
                    if (valid.isOK()) {
                        manager.aboutToPerformChange(change);
                        undoChange = change.perform(monitor);
                        successful = true;
                    }
                }
                catch (CoreException ce) {
                    JAXWSUIPlugin.log(ce.getStatus());
                    manager.changePerformed(change, successful);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                manager.changePerformed(change, successful);
                throw throwable;
            }
            manager.changePerformed(change, successful);
        }
        if (undoChange != null) {
            undoChange.initializeValidationData(monitor);
            manager.addUndo(undoChange.getName(), undoChange);
        }
        this.annotationsView.refresh();
    }
}

