﻿// --------------------------------------------------------------------------------------------------------------------
// <copyright file="HBPreset.cs" company="HandBrake Project (http://handbrake.fr)">
//   This file is part of the HandBrake source code - It may be used under the terms of the GNU General Public License.
// </copyright>
// <summary>
//   The preset.
// </summary>
// --------------------------------------------------------------------------------------------------------------------

namespace HandBrake.Interop.Interop.Json.Presets
{
    using System.Collections.Generic;

    /// <summary>
    ///     The preset.
    /// </summary>
    public class HBPreset
    {
        public bool AlignAVStart { get; set; }

        /// <summary>
        /// Gets or sets the audio copy mask.
        /// </summary>
        public List<string> AudioCopyMask { get; set; }

        /// <summary>
        /// Gets or sets the audio encoder fallback.
        /// </summary>
        public string AudioEncoderFallback { get; set; }

        /// <summary>
        /// Gets or sets the audio language list.
        /// </summary>
        public List<string> AudioLanguageList { get; set; }

        /// <summary>
        /// Gets or sets the audio list.
        /// </summary>
        public List<AudioList> AudioList { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether audio secondary encoder mode.
        /// </summary>
        public bool AudioSecondaryEncoderMode { get; set; }

        /// <summary>
        /// Gets or sets the audio track selection behavior.
        /// </summary>
        public string AudioTrackSelectionBehavior { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether chapter markers.
        /// </summary>
        public bool ChapterMarkers { get; set; }

        /// <summary>
        /// Gets or sets the children array.
        /// </summary>
        public List<object> ChildrenArray { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether default.
        /// </summary>
        public bool Default { get; set; }

        /// <summary>
        /// Gets or sets the file format.
        /// </summary>
        public string FileFormat { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether folder.
        /// </summary>
        public bool Folder { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether folder open.
        /// </summary>
        public bool FolderOpen { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether mp 4 http optimize.
        /// </summary>
        public bool Mp4HttpOptimize { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether mp 4 i pod compatible.
        /// </summary>
        public bool Mp4iPodCompatible { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether picture auto crop.
        /// </summary>
        public bool PictureAutoCrop { get; set; }

        /// <summary>
        /// Gets or sets the picture bottom crop.
        /// </summary>
        public int PictureBottomCrop { get; set; }

        /// <summary>
        /// Gets or sets the picture left crop.
        /// </summary>
        public int PictureLeftCrop { get; set; }

        /// <summary>
        /// Gets or sets the picture right crop.
        /// </summary>
        public int PictureRightCrop { get; set; }

        /// <summary>
        /// Gets or sets the picture top crop.
        /// </summary>
        public int PictureTopCrop { get; set; }

        /// <summary>
        /// Gets or sets the picture dar width.
        /// </summary>
        public int PictureDARWidth { get; set; }

        /// <summary>
        /// Gets or sets the picture deblock.
        /// </summary>
        public int PictureDeblock { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether picture decomb deinterlace.
        /// </summary>
        public string PictureDeinterlaceFilter { get; set; }

        /// <summary>
        /// Gets or sets the picture comb detect preset.
        /// </summary>
        public string PictureCombDetectPreset { get; set; }

        /// <summary>
        /// Gets or sets the picture comb detect custom.
        /// </summary>
        public string PictureCombDetectCustom { get; set; }

        /// <summary>
        /// Gets or sets the picture deinterlace preset.
        /// </summary>
        public string PictureDeinterlacePreset { get; set; }

        /// <summary>
        /// Gets or sets the picture deinterlace custom.
        /// </summary>
        public string PictureDeinterlaceCustom { get; set; }

        /// <summary>
        /// Gets or sets the picture denoise custom.
        /// </summary>
        public string PictureDenoiseCustom { get; set; }

        /// <summary>
        /// Gets or sets the picture denoise filter.
        /// </summary>
        public string PictureDenoiseFilter { get; set; }

        /// <summary>
        /// Gets or sets the picture denoise preset.
        /// </summary>
        public string PictureDenoisePreset { get; set; }

        /// <summary>
        /// Gets or sets the picture denoise tune.
        /// </summary>
        public string PictureDenoiseTune { get; set; }

        public string PictureSharpenCustom { get; set; }
        public string PictureSharpenFilter { get; set; }
        public string PictureSharpenPreset { get; set; }
        public string PictureSharpenTune { get; set; }

        /// <summary>
        /// Gets or sets the picture detelecine.
        /// </summary>
        public string PictureDetelecine { get; set; }

        /// <summary>
        /// Gets or sets the picture detelecine custom.
        /// </summary>
        public string PictureDetelecineCustom { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether picture itu par.
        /// </summary>
        public bool PictureItuPAR { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether picture keep ratio.
        /// </summary>
        public bool PictureKeepRatio { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether picture loose crop.
        /// </summary>
        public bool PictureLooseCrop { get; set; }

        /// <summary>
        /// Gets or sets the picture modulus.
        /// </summary>
        public int PictureModulus { get; set; }

        /// <summary>
        /// Gets or sets the picture par.
        /// </summary>
        public string PicturePAR { get; set; }

        /// <summary>
        /// Gets or sets the picture par width.
        /// </summary>
        public int PicturePARWidth { get; set; }

        /// <summary>
        /// Gets or sets the picture par height.
        /// </summary>
        public int PicturePARHeight { get; set; }

        /// <summary>
        /// Gets or sets the picture rotate.
        /// </summary>
        public string PictureRotate { get; set; }

        /// <summary>
        /// Gets or sets the picture width.
        /// </summary>
        public int? PictureWidth { get; set; }

        /// <summary>
        /// Gets or sets the picture height.
        /// </summary>
        public int? PictureHeight { get; set; }

        /// <summary>
        /// Gets or sets the picture force height.
        /// </summary>
        public int PictureForceHeight { get; set; }

        /// <summary>
        /// Gets or sets the picture force width.
        /// </summary>
        public int PictureForceWidth { get; set; }

        /// <summary>
        /// Gets or sets the preset description.
        /// </summary>
        public string PresetDescription { get; set; }

        /// <summary>
        /// Gets or sets the preset name.
        /// </summary>
        public string PresetName { get; set; }

        /// <summary>
        /// Gets or sets the type.
        /// </summary>
        public int Type { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether uses picture filters.
        /// </summary>
        public bool UsesPictureFilters { get; set; }

        /// <summary>
        /// Gets or sets the uses picture settings.
        /// </summary>
        public int UsesPictureSettings { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether subtitle add cc.
        /// </summary>
        public bool SubtitleAddCC { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether subtitle add foreign audio search.
        /// </summary>
        public bool SubtitleAddForeignAudioSearch { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether subtitle add foreign audio subtitle.
        /// </summary>
        public bool SubtitleAddForeignAudioSubtitle { get; set; }

        /// <summary>
        /// Gets or sets the subtitle burn behavior.
        /// </summary>
        public string SubtitleBurnBehavior { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether subtitle burn bd sub.
        /// </summary>
        public bool SubtitleBurnBDSub { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether subtitle burn dvd sub.
        /// </summary>
        public bool SubtitleBurnDVDSub { get; set; }

        /// <summary>
        /// Gets or sets the subtitle language list.
        /// </summary>
        public List<string> SubtitleLanguageList { get; set; }

        /// <summary>
        /// Gets or sets the subtitle track selection behavior.
        /// </summary>
        public string SubtitleTrackSelectionBehavior { get; set; }

        /// <summary>
        /// Gets or sets the video avg bitrate.
        /// </summary>
        public int? VideoAvgBitrate { get; set; }

        /// <summary>
        /// Gets or sets the video color matrix code.
        /// </summary>
        public int VideoColorMatrixCode { get; set; }

        /// <summary>
        /// Gets or sets the video encoder.
        /// </summary>
        public string VideoEncoder { get; set; }

        /// <summary>
        /// Gets or sets the video framerate.
        /// </summary>
        public string VideoFramerate { get; set; }

        /// <summary>
        /// Gets or sets the video framerate mode.
        /// </summary>
        public string VideoFramerateMode { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether video gray scale.
        /// </summary>
        public bool VideoGrayScale { get; set; }

        /// <summary>
        /// Gets or sets the video scaler.
        /// </summary>
        public string VideoScaler { get; set; }

        /// <summary>
        /// Gets or sets the video preset.
        /// </summary>
        public string VideoPreset { get; set; }

        /// <summary>
        /// Gets or sets the video tune.
        /// </summary>
        public string VideoTune { get; set; }

        /// <summary>
        /// Gets or sets the video profile.
        /// </summary>
        public string VideoProfile { get; set; }

        /// <summary>
        /// Gets or sets the video level.
        /// </summary>
        public string VideoLevel { get; set; }

        /// <summary>
        /// Gets or sets the video option extra.
        /// </summary>
        public string VideoOptionExtra { get; set; }

        /// <summary>
        /// Gets or sets the video quality type.
        /// </summary>
        public int VideoQualityType { get; set; }

        /// <summary>
        /// Gets or sets the video quality slider.
        /// </summary>
        public double VideoQualitySlider { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether video qsv decode.
        /// </summary>
        public bool VideoQSVDecode { get; set; }

        /// <summary>
        /// Gets or sets the video qsv async depth.
        /// </summary>
        public int VideoQSVAsyncDepth { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether video two pass.
        /// </summary>
        public bool VideoTwoPass { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether video turbo two pass.
        /// </summary>
        public bool VideoTurboTwoPass { get; set; }

        /// <summary>
        /// Gets or sets the x 264 option.
        /// </summary>
        public string x264Option { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether x 264 use advanced options.
        /// </summary>
        public bool x264UseAdvancedOptions { get; set; }
    }
}