/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.AbstractEclipseWriter;
import org.apache.maven.plugin.ide.IdeDependency;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class EclipseOSGiManifestWriter
extends AbstractEclipseWriter {
    private static final String NEWLINE = "\n";
    public static final String ENTRY_BUNDLE_CLASSPATH = "Bundle-ClassPath:";
    public static final String ENTRY_BUNDLE_NAME = "Bundle-Name:";
    public static final String ENTRY_BUNDLE_SYMBOLICNAME = "Bundle-SymbolicName:";
    public static final String ENTRY_BUNDLE_VERSION = "Bundle-Version:";
    public static final String ENTRY_BUNDLE_VENDOR = "Bundle-Vendor:";

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write() throws MojoExecutionException {
        if (!this.config.getOSGIManifestFile().exists()) {
            this.log.warn((CharSequence)Messages.getString("EclipseOSGiManifestWriter.nomanifestfile", this.config.getOSGIManifestFile().getAbsolutePath()));
            return;
        }
        StringBuffer manifestSb = this.rewriteManifest(this.config.getOSGIManifestFile());
        OutputStreamWriter out = null;
        try {
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(this.config.getOSGIManifestFile()), "UTF-8");
            out.write(manifestSb.toString());
        }
        catch (FileNotFoundException e) {
            try {
                throw new MojoExecutionException(Messages.getString("EclipsePlugin.cantwritetofile", this.config.getOSGIManifestFile().getAbsolutePath()));
                catch (IOException e2) {
                    throw new MojoExecutionException(Messages.getString("EclipsePlugin.cantwritetofile", this.config.getOSGIManifestFile().getAbsolutePath()), (Exception)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(out);
                throw throwable;
            }
        }
        IOUtil.close((Writer)out);
    }

    protected StringBuffer rewriteManifest(File manifestFile) throws MojoExecutionException {
        boolean inBundleClasspathEntry = false;
        StringBuffer manifestSb = new StringBuffer();
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(manifestFile), "UTF-8"));
            while ((line = in.readLine()) != null) {
                if (inBundleClasspathEntry && line.indexOf(":") > -1) {
                    inBundleClasspathEntry = false;
                } else if (inBundleClasspathEntry) continue;
                String name = line.substring(0, line.indexOf(":") + 1);
                if (name.equalsIgnoreCase(ENTRY_BUNDLE_CLASSPATH)) {
                    inBundleClasspathEntry = true;
                    continue;
                }
                if (name.equalsIgnoreCase(ENTRY_BUNDLE_NAME)) {
                    manifestSb.append(ENTRY_BUNDLE_NAME);
                    manifestSb.append(" ");
                    manifestSb.append(this.config.getProject().getName());
                    manifestSb.append(NEWLINE);
                    continue;
                }
                if (name.equalsIgnoreCase(ENTRY_BUNDLE_SYMBOLICNAME)) {
                    manifestSb.append(ENTRY_BUNDLE_SYMBOLICNAME);
                    manifestSb.append(" ");
                    manifestSb.append(this.config.getEclipseProjectName());
                    manifestSb.append(";singleton:=true");
                    manifestSb.append(NEWLINE);
                    continue;
                }
                if (name.equalsIgnoreCase(ENTRY_BUNDLE_VERSION)) {
                    manifestSb.append(ENTRY_BUNDLE_VERSION);
                    manifestSb.append(" ");
                    manifestSb.append(EclipseOSGiManifestWriter.getNormalizedVersion(this.config.getProject().getVersion()));
                    manifestSb.append(NEWLINE);
                    continue;
                }
                if (name.equalsIgnoreCase(ENTRY_BUNDLE_VENDOR) && this.config.getProject().getOrganization() != null) {
                    manifestSb.append(ENTRY_BUNDLE_VENDOR);
                    manifestSb.append(" ");
                    manifestSb.append(this.config.getProject().getOrganization().getName());
                    manifestSb.append(NEWLINE);
                    continue;
                }
                manifestSb.append(line + NEWLINE);
            }
            IOUtil.close((Reader)in);
        }
        catch (IOException e) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.cantreadfile", manifestFile.getAbsolutePath()));
        }
        manifestSb.append(this.addBundleClasspathEntries());
        manifestSb.append(NEWLINE);
        return manifestSb;
    }

    protected static String getNormalizedVersion(String version) {
        if (version.endsWith("-SNAPSHOT")) {
            int j;
            String[] versionTokens = StringUtils.split((String)StringUtils.stripEnd((String)version, (String)"-SNAPSHOT"), (String)".");
            StringBuffer newVersion = new StringBuffer(20);
            for (j = 0; j < versionTokens.length; ++j) {
                newVersion.append(versionTokens[j]);
                newVersion.append(".");
            }
            while (j < 3) {
                newVersion.append("0.");
                ++j;
            }
            newVersion.append("SNAPSHOT");
            version = newVersion.toString();
        }
        return version;
    }

    protected String addBundleClasspathEntries() {
        StringBuffer bundleClasspathSb = new StringBuffer(ENTRY_BUNDLE_CLASSPATH);
        bundleClasspathSb.append(" .");
        IdeDependency[] deps = this.config.getDeps();
        for (int j = 0; j < deps.length; ++j) {
            IdeDependency dep = deps[j];
            if (dep.isProvided() || dep.isReferencedProject() || dep.isTestDependency() || dep.isOsgiBundle()) continue;
            bundleClasspathSb.append(",\n");
            this.log.debug((CharSequence)("Adding artifact to manifest: " + dep.getArtifactId()));
            bundleClasspathSb.append(" " + dep.getFile().getName());
        }
        return bundleClasspathSb.toString();
    }
}

