/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-project-manager.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-project-manager
 * @title: IAnjutaProjectManager
 * @short_description: Interface for project managers
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-project-manager.h
 * 
 */

#include "ianjuta-project-manager.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_project_manager_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-project-manager-quark");
	}
	
	return quark;
}

/**
* ianjuta_project_manager_add_group:
* @obj: Self
* @group_name_to_add: fixme
* @default_location_uri: fixme
* @err: Error propagation and reporting.
* 
* fixme
* 
* Returns: fixme
*/
gchar*
ianjuta_project_manager_add_group (IAnjutaProjectManager *obj, const gchar *group_name_to_add,   const gchar *default_location_uri, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT_MANAGER(obj), NULL);
	return IANJUTA_PROJECT_MANAGER_GET_IFACE (obj)->add_group (obj, group_name_to_add, default_location_uri, err);
}

/* Default implementation */
static gchar*
ianjuta_project_manager_add_group_default (IAnjutaProjectManager *obj, const gchar *group_name_to_add,   const gchar *default_location_uri, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_project_manager_add_source:
* @obj: Self
* @source_uri_to_add: fixme
* @default_location_uri: fixme
* @err: Error propagation and reporting.
*
* Prompt the user to add a file to the project. If the user selects
* multiple files only the first uri is returned.
*
* Returns: element URIs. Must be freed when no longer required.
*/
gchar*
ianjuta_project_manager_add_source (IAnjutaProjectManager *obj, const gchar *source_uri_to_add,   const gchar *default_location_uri, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT_MANAGER(obj), NULL);
	return IANJUTA_PROJECT_MANAGER_GET_IFACE (obj)->add_source (obj, source_uri_to_add, default_location_uri, err);
}

/* Default implementation */
static gchar*
ianjuta_project_manager_add_source_default (IAnjutaProjectManager *obj, const gchar *source_uri_to_add,   const gchar *default_location_uri, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_project_manager_add_sources:
* @obj: Self
* @source_uris_to_add: fixme
* @default_location_uri: fixme
* @err: Error propagation and reporting.
*
* Prompt the user to add a file to the project. If the user selects
* multiple files only the first uri is returned.
*
* Returns: element URIs. Must be freed when no longer required.
*/
GList*
ianjuta_project_manager_add_sources (IAnjutaProjectManager *obj, GList* source_uris_to_add,   const gchar *default_location_uri, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT_MANAGER(obj), 0);
	return IANJUTA_PROJECT_MANAGER_GET_IFACE (obj)->add_sources (obj, source_uris_to_add, default_location_uri, err);
}

/* Default implementation */
static GList*
ianjuta_project_manager_add_sources_default (IAnjutaProjectManager *obj, GList* source_uris_to_add,   const gchar *default_location_uri, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_project_manager_add_target:
* @obj: Self
* @target_name_to_add: fixme
* @default_location_uri: fixme
* @err: Error propagation and reporting.
* 
* fixme
* 
* Returns:
*/
gchar*
ianjuta_project_manager_add_target (IAnjutaProjectManager *obj, const gchar *target_name_to_add,   const gchar *default_location_uri, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT_MANAGER(obj), NULL);
	return IANJUTA_PROJECT_MANAGER_GET_IFACE (obj)->add_target (obj, target_name_to_add, default_location_uri, err);
}

/* Default implementation */
static gchar*
ianjuta_project_manager_add_target_default (IAnjutaProjectManager *obj, const gchar *target_name_to_add,   const gchar *default_location_uri, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_project_manager_get_capabilities:
* @obj: Self
* @err: Error propagation and reporting.
*
* Returns the capabilites of project whether it can add group, target
* sources etc.
*
* Returns: Supported capabilites.
*/
IAnjutaProjectManagerCapabilities
ianjuta_project_manager_get_capabilities (IAnjutaProjectManager *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT_MANAGER(obj), 0);
	return IANJUTA_PROJECT_MANAGER_GET_IFACE (obj)->get_capabilities (obj, err);
}

/* Default implementation */
static IAnjutaProjectManagerCapabilities
ianjuta_project_manager_get_capabilities_default (IAnjutaProjectManager *obj, GError **err)
{
	g_return_val_if_reached (0);
}

/**
* ianjuta_project_manager_get_children:
* @obj: Self
* @element_uri: fixme
* @err: Error propagation and reporting.
* 
* fixme
*
* Returns: fixme
*/
GList*
ianjuta_project_manager_get_children (IAnjutaProjectManager *obj, const gchar *element_uri, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT_MANAGER(obj), 0);
	return IANJUTA_PROJECT_MANAGER_GET_IFACE (obj)->get_children (obj, element_uri, err);
}

/* Default implementation */
static GList*
ianjuta_project_manager_get_children_default (IAnjutaProjectManager *obj, const gchar *element_uri, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_project_manager_get_element_type:
* @obj: Self
* @element_uri: fixme
* @err: Error propagation and reporting.
* 
* fixme
*
* Returns: fixme
*/
IAnjutaProjectManagerElementType
ianjuta_project_manager_get_element_type (IAnjutaProjectManager *obj, const gchar *element_uri, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT_MANAGER(obj), 0);
	return IANJUTA_PROJECT_MANAGER_GET_IFACE (obj)->get_element_type (obj, element_uri, err);
}

/* Default implementation */
static IAnjutaProjectManagerElementType
ianjuta_project_manager_get_element_type_default (IAnjutaProjectManager *obj, const gchar *element_uri, GError **err)
{
	g_return_val_if_reached (0);
}

/**
* ianjuta_project_manager_get_elements:
* @obj: Self
* @element_type: fixme
* @err: Error propagation and reporting.
* 
* fixme
* 
* Returns: fixme
*/
GList*
ianjuta_project_manager_get_elements (IAnjutaProjectManager *obj, IAnjutaProjectManagerElementType element_type, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT_MANAGER(obj), 0);
	return IANJUTA_PROJECT_MANAGER_GET_IFACE (obj)->get_elements (obj, element_type, err);
}

/* Default implementation */
static GList*
ianjuta_project_manager_get_elements_default (IAnjutaProjectManager *obj, IAnjutaProjectManagerElementType element_type, GError **err)
{
	g_return_val_if_reached (NULL);
}

/*
 * ianjuta_project_manager_get_packages
 * @obj: Self
 * @err: Error propagation and reporting.
 *
 * Returns: the list of pkg-config packages that this projects
 * requires in it's configure.ac or NULL
 */
GList*
ianjuta_project_manager_get_packages (IAnjutaProjectManager *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT_MANAGER(obj), 0);
	return IANJUTA_PROJECT_MANAGER_GET_IFACE (obj)->get_packages (obj, err);
}

/* Default implementation */
static GList*
ianjuta_project_manager_get_packages_default (IAnjutaProjectManager *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_project_manager_get_parent:
* @obj: Self
* @element_uri: fixme
* @err: Error propagation and reporting.
* 
* fixme
*
* Returns: fixme
*/
gchar*
ianjuta_project_manager_get_parent (IAnjutaProjectManager *obj, const gchar *element_uri, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT_MANAGER(obj), NULL);
	return IANJUTA_PROJECT_MANAGER_GET_IFACE (obj)->get_parent (obj, element_uri, err);
}

/* Default implementation */
static gchar*
ianjuta_project_manager_get_parent_default (IAnjutaProjectManager *obj, const gchar *element_uri, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_project_manager_get_selected:
* @obj: Self
* @err: Error propagation and reporting.
* 
* fixme
*/
gchar*
ianjuta_project_manager_get_selected (IAnjutaProjectManager *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT_MANAGER(obj), NULL);
	return IANJUTA_PROJECT_MANAGER_GET_IFACE (obj)->get_selected (obj, err);
}

/* Default implementation */
static gchar*
ianjuta_project_manager_get_selected_default (IAnjutaProjectManager *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_project_manager_get_target_type:
* @obj: Self
* @target_uri: fixme
* @err: Error propagation and reporting.
* 
* fixme
* 
* Returns: fixme
*/
IAnjutaProjectManagerTargetType
ianjuta_project_manager_get_target_type (IAnjutaProjectManager *obj, const gchar *target_uri, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT_MANAGER(obj), 0);
	return IANJUTA_PROJECT_MANAGER_GET_IFACE (obj)->get_target_type (obj, target_uri, err);
}

/* Default implementation */
static IAnjutaProjectManagerTargetType
ianjuta_project_manager_get_target_type_default (IAnjutaProjectManager *obj, const gchar *target_uri, GError **err)
{
	g_return_val_if_reached (0);
}

/**
* ianjuta_project_manager_get_targets:
* @obj: Self
* @target_type: fixme
* @err: Error propagation and reporting.
* 
* fixme
* 
* Returns: fixme
*/
GList*
ianjuta_project_manager_get_targets (IAnjutaProjectManager *obj, IAnjutaProjectManagerTargetType target_type, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT_MANAGER(obj), 0);
	return IANJUTA_PROJECT_MANAGER_GET_IFACE (obj)->get_targets (obj, target_type, err);
}

/* Default implementation */
static GList*
ianjuta_project_manager_get_targets_default (IAnjutaProjectManager *obj, IAnjutaProjectManagerTargetType target_type, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_project_manager_is_open:
* @obj: Self
* @err: Error propagation and reporting.
* 
* fixme
*/ 
gboolean
ianjuta_project_manager_is_open (IAnjutaProjectManager *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT_MANAGER(obj), FALSE);
	return IANJUTA_PROJECT_MANAGER_GET_IFACE (obj)->is_open (obj, err);
}

/* Default implementation */
static gboolean
ianjuta_project_manager_is_open_default (IAnjutaProjectManager *obj, GError **err)
{
	g_return_val_if_reached (FALSE);
}

static void
ianjuta_project_manager_base_init (IAnjutaProjectManagerIface* klass)
{
	static gboolean initialized = FALSE;

	klass->add_group = ianjuta_project_manager_add_group_default;
	klass->add_source = ianjuta_project_manager_add_source_default;
	klass->add_sources = ianjuta_project_manager_add_sources_default;
	klass->add_target = ianjuta_project_manager_add_target_default;
	klass->get_capabilities = ianjuta_project_manager_get_capabilities_default;
	klass->get_children = ianjuta_project_manager_get_children_default;
	klass->get_element_type = ianjuta_project_manager_get_element_type_default;
	klass->get_elements = ianjuta_project_manager_get_elements_default;
	klass->get_packages = ianjuta_project_manager_get_packages_default;
	klass->get_parent = ianjuta_project_manager_get_parent_default;
	klass->get_selected = ianjuta_project_manager_get_selected_default;
	klass->get_target_type = ianjuta_project_manager_get_target_type_default;
	klass->get_targets = ianjuta_project_manager_get_targets_default;
	klass->is_open = ianjuta_project_manager_is_open_default;
	
	if (!initialized) {
		/* Signal */
		g_signal_new ("element-added",
			IANJUTA_TYPE_PROJECT_MANAGER,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaProjectManagerIface, element_added),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__STRING,
			G_TYPE_NONE,
			1,
			G_TYPE_STRING);

		/* Signal */
		g_signal_new ("element-removed",
			IANJUTA_TYPE_PROJECT_MANAGER,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaProjectManagerIface, element_removed),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__STRING,
			G_TYPE_NONE,
			1,
			G_TYPE_STRING);

		/* Signal */
		g_signal_new ("element-selected",
			IANJUTA_TYPE_PROJECT_MANAGER,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaProjectManagerIface, element_selected),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__STRING,
			G_TYPE_NONE,
			1,
			G_TYPE_STRING);


		initialized = TRUE;
	}
}

GType
ianjuta_project_manager_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaProjectManagerIface),
			(GBaseInitFunc) ianjuta_project_manager_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaProjectManager", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}

GType
ianjuta_project_manager_capabilities_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_PROJECT_MANAGER_CAN_ADD_NONE, "IANJUTA_PROJECT_MANAGER_CAN_ADD_NONE", "can-add-none" }, 
		{ IANJUTA_PROJECT_MANAGER_CAN_ADD_GROUP, "IANJUTA_PROJECT_MANAGER_CAN_ADD_GROUP", "can-add-group" }, 
		{ IANJUTA_PROJECT_MANAGER_CAN_ADD_TARGET, "IANJUTA_PROJECT_MANAGER_CAN_ADD_TARGET", "can-add-target" }, 
		{ IANJUTA_PROJECT_MANAGER_CAN_ADD_SOURCE, "IANJUTA_PROJECT_MANAGER_CAN_ADD_SOURCE", "can-add-source" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaProjectManagerCapabilities", values);
	}

	return type;
}

GType
ianjuta_project_manager_element_type_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_PROJECT_MANAGER_UNKNOWN, "IANJUTA_PROJECT_MANAGER_UNKNOWN", "unknown" }, 
		{ IANJUTA_PROJECT_MANAGER_SOURCE, "IANJUTA_PROJECT_MANAGER_SOURCE", "source" }, 
		{ IANJUTA_PROJECT_MANAGER_TARGET, "IANJUTA_PROJECT_MANAGER_TARGET", "target" }, 
		{ IANJUTA_PROJECT_MANAGER_GROUP, "IANJUTA_PROJECT_MANAGER_GROUP", "group" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaProjectManagerElementType", values);
	}

	return type;
}

GType
ianjuta_project_manager_target_type_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_PROJECT_MANAGER_TARGET_UNKNOWN, "IANJUTA_PROJECT_MANAGER_TARGET_UNKNOWN", "target-unknown" }, 
		{ IANJUTA_PROJECT_MANAGER_TARGET_SHAREDLIB, "IANJUTA_PROJECT_MANAGER_TARGET_SHAREDLIB", "target-sharedlib" }, 
		{ IANJUTA_PROJECT_MANAGER_TARGET_STATICLIB, "IANJUTA_PROJECT_MANAGER_TARGET_STATICLIB", "target-staticlib" }, 
		{ IANJUTA_PROJECT_MANAGER_TARGET_EXECUTABLE, "IANJUTA_PROJECT_MANAGER_TARGET_EXECUTABLE", "target-executable" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaProjectManagerTargetType", values);
	}

	return type;
}
