/* This is -*- C -*- */
/* vim: set sw=2: */

/*
 * guppi-chart-selector.h
 *
 * Copyright (C) 2000 Helix Code, Inc.
 *
 * Developed by Jody Goldberg <jgoldberg@home.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_CHART_SELECTOR_H
#define _INC_GUPPI_CHART_SELECTOR_H

#include <gtk/gtkwidget.h>
#include <guppi-chart-type.h>
#include <guppi-defs.h>

BEGIN_GUPPI_DECLS

typedef struct {
  GuppiRootGroupView *plot;
  GuppiMinorChartType const *current_minor;
  GuppiSeqData   *series;
  GuppiSeqData   *labels;
  GuppiSeqString *series_names;
} GuppiChartSelector;

void       guppi_chart_selector_init (GuppiChartSelector *selector);
GtkWidget *guppi_chart_selector_widget (GuppiChartSelector *selector);
GuppiRootGroupView *guppi_chart_selector_get_plot (gpointer user_data);

END_GUPPI_DECLS

#endif /* _INC_GUPPI_CHART_SELECTOR_H */
