/* This is -*- C -*- */
/* $Id: guppi-curve-impl.h,v 1.10 2001/01/16 23:36:12 trow Exp $ */

/*
 * guppi-curve-impl.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_CURVE_IMPL_H
#define _INC_GUPPI_CURVE_IMPL_H

/* #include <gtk/gtk.h> */
#include <libart_lgpl/libart.h>
#include "guppi-data-impl.h"

#include <guppi-defs.h>

BEGIN_GUPPI_DECLS

typedef struct _GuppiCurveImpl GuppiCurveImpl;

struct _GuppiCurveImpl {
  GuppiDataImpl parent;
};

typedef struct {
  GuppiDataImplClass parent_class;

  /* Mandatory functions */

  void (*bounds) (GuppiCurveImpl *, double *, double *);
  void (*get) (GuppiCurveImpl *, double, double *, double *);


  /* Optional functions */

  void (*bbox) (GuppiCurveImpl *, double, double,
		double *, double *, double *, double *);

  gboolean (*clamp) (GuppiCurveImpl *, double *, double *,
		     double, double, double, double);

  void (*sample) (GuppiCurveImpl *,
		  gconstpointer t_vec, gint t_stride, gsize N,
		  gpointer x_vec, gint x_stride,
		  gpointer y_vec, gint y_stride);
  void (*sample_uniformly) (GuppiCurveImpl *,
			    double t0, double t1, gsize N,
			    double *x_vec, gint x_stride,
			    double *y_vec, gint y_stride);

  ArtVpath *(*approx_to_path) (GuppiCurveImpl *, double t0, double t1,
			       double x_error, double y_error);

} GuppiCurveImplClass;

#define GUPPI_TYPE_CURVE_IMPL (guppi_curve_impl_get_type())
#define GUPPI_CURVE_IMPL(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_CURVE_IMPL,GuppiCurveImpl))
#define GUPPI_CURVE_IMPL0(obj) ((obj) ? (GUPPI_CURVE_IMPL(obj)) : NULL)
#define GUPPI_CURVE_IMPL_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_CURVE_IMPL,GuppiCurveImplClass))
#define GUPPI_IS_CURVE_IMPL(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_CURVE_IMPL))
#define GUPPI_IS_CURVE_IMPL0(obj) (((obj) == NULL) || (GUPPI_IS_CURVE_IMPL(obj)))
#define GUPPI_IS_CURVE_IMPL_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_CURVE_IMPL))

GtkType guppi_curve_impl_get_type (void);

END_GUPPI_DECLS

#endif /* _INC_GUPPI_CURVE_IMPL_H */

/* $Id: guppi-curve-impl.h,v 1.10 2001/01/16 23:36:12 trow Exp $ */
