/* This is -*- C -*- */
/* $Id: guppi-struct-impl.c,v 1.9 2001/01/16 23:36:22 trow Exp $ */

/*
 * guppi-struct-impl.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>

#include <string.h>

/* #include <gnome.h> */

#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-config.h>
#include <libgnome/gnome-i18n.h>

#include <guppi-memory.h>
#include "guppi-struct-impl.h"

static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_struct_impl_get_arg (GtkObject * obj, GtkArg * arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_struct_impl_set_arg (GtkObject * obj, GtkArg * arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_struct_impl_finalize (GtkObject * obj)
{
  if (parent_class->finalize)
    parent_class->finalize (obj);
}

static gint
v_size_in_bytes (GuppiDataImpl * data_impl)
{
  GuppiStructImpl *impl;
  GuppiStructImplClass *klass;
  gchar **stringv;
  gint i = 0;
  gint tally = sizeof (GuppiStructImpl), mem;
  GuppiData *data;

  impl = GUPPI_STRUCT_IMPL (data_impl);
  klass = GUPPI_STRUCT_IMPL_CLASS (GTK_OBJECT (impl)->klass);

  g_assert (klass->get_names);
  stringv = (klass->get_names) (impl);
  if (stringv == NULL)
    return -1;

  g_assert (klass->get);
  while (tally != -1 && stringv[i] != NULL) {
    data = (klass->get) (impl, stringv[i]);
    mem = guppi_data_get_size_in_bytes (data);
    if (mem == -1)
      tally = -1;
    else
      tally += mem;
    ++i;
  }

  guppi_strfreev (stringv);
  return tally;
}

static void
v_size_info (GuppiDataImpl * data_impl, gchar * buf, gsize N)
{
  GuppiStructImpl *impl;
  GuppiStructImplClass *klass;
  gsize slots;

  impl = GUPPI_STRUCT_IMPL (data_impl);
  klass = GUPPI_STRUCT_IMPL_CLASS (GTK_OBJECT (impl)->klass);

  g_assert (klass->get_size);
  slots = (klass->get_size) (impl);

  if (slots == 0)
    strncpy (buf, _("empty"), slots);
  else
    g_snprintf (buf, N, _("%u slots"), slots);
}

struct foreach_adapter {
  void (*fn) (GuppiData *, gpointer);
  gpointer user_data;
};

static void
foreach_data_fn (const gchar *name, GuppiData *d, gpointer ud)
{
  struct foreach_adapter *fa = (struct foreach_adapter *)ud;

  fa->fn (d, fa->user_data);
}


static void
v_data_foreach (GuppiDataImpl *data_impl,
		void (*fn) (GuppiData *, gpointer),
		gpointer user_data)
{
  GuppiStructImpl *impl;
  GuppiStructImplClass *klass;

  struct foreach_adapter fa;
  fa.fn = fn;
  fa.user_data = user_data;
  
  impl = GUPPI_STRUCT_IMPL (data_impl);
  klass = GUPPI_STRUCT_IMPL_CLASS (GTK_OBJECT (impl)->klass);

  g_assert (klass->foreach);
  klass->foreach (impl, foreach_data_fn, &fa);
}

static void
guppi_struct_impl_class_init (GuppiStructImplClass * klass)
{
  GtkObjectClass *object_class = (GtkObjectClass *) klass;
  GuppiDataImplClass *data_class = GUPPI_DATA_IMPL_CLASS (klass);

  parent_class = gtk_type_class (GUPPI_TYPE_DATA_IMPL);

  data_class->get_size_in_bytes = v_size_in_bytes;
  data_class->get_size_info = v_size_info;
  data_class->foreach_subdata = v_data_foreach;

  object_class->get_arg = guppi_struct_impl_get_arg;
  object_class->set_arg = guppi_struct_impl_set_arg;
  object_class->finalize = guppi_struct_impl_finalize;
}

static void
guppi_struct_impl_init (GuppiStructImpl * obj)
{

}

GtkType guppi_struct_impl_get_type (void)
{
  static GtkType guppi_struct_impl_type = 0;
  if (!guppi_struct_impl_type) {
    static const GtkTypeInfo guppi_struct_impl_info = {
      "GuppiStructImpl",
      sizeof (GuppiStructImpl),
      sizeof (GuppiStructImplClass),
      (GtkClassInitFunc) guppi_struct_impl_class_init,
      (GtkObjectInitFunc) guppi_struct_impl_init,
      NULL, NULL, (GtkClassInitFunc) NULL
    };
    guppi_struct_impl_type =
      gtk_type_unique (GUPPI_TYPE_DATA_IMPL, &guppi_struct_impl_info);
  }
  return guppi_struct_impl_type;
}

GtkObject *
guppi_struct_impl_new (void)
{
  return GTK_OBJECT (guppi_type_new (guppi_struct_impl_get_type ()));
}



/* $Id: guppi-struct-impl.c,v 1.9 2001/01/16 23:36:22 trow Exp $ */
