/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-cpu-debugger.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "ianjuta-cpu-debugger.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_cpu_debugger_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-cpu-debugger-quark");
	}
	
	return quark;
}

/**
* ianjuta_debugger_disassemble:
* @obj: Self
* @address: fixme
* @length: fixme
* @callback: fixme
* @user_data: fixme
* @err: Error propagation and reporting.
* 
* Disassemble a part of the memory
*
* Returns: TRUE if sucessful else FALSE and check err to get more
*          detail.
*/
gboolean
ianjuta_cpu_debugger_disassemble (IAnjutaCpuDebugger *obj, guint address,   guint length,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_CPU_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_CPU_DEBUGGER_GET_IFACE (obj)->disassemble (obj, address, length, callback, user_data, err);
}

/**
* ianjuta_debugger_inspect_memory:
* @obj: Self
* @address: fixme
* @length: fixme
* @callback: fixme
* @user_data: fixme
* @err: Error propagation and reporting.
* 
* fixme
*
* Returns: fixme
*/
gboolean
ianjuta_cpu_debugger_inspect_memory (IAnjutaCpuDebugger *obj, guint address,   guint length,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_CPU_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_CPU_DEBUGGER_GET_IFACE (obj)->inspect_memory (obj, address, length, callback, user_data, err);
}

/**
* ianjuta_debugger_list_register:
* @obj: Self
* @callback: fixme
* @user_data: fixme
* @err: Error propagation and reporting.
* 
* fixme
*
* Returns: fixme
*/
gboolean
ianjuta_cpu_debugger_list_register (IAnjutaCpuDebugger *obj, IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_CPU_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_CPU_DEBUGGER_GET_IFACE (obj)->list_register (obj, callback, user_data, err);
}

/**
* ianjuta_debugger_update_register:
* @obj: Self
* @callback: fixme
* @user_data: fixme
* @err: Error propagation and reporting.
* 
* fixme
*
* Returns: fixme
*/
gboolean
ianjuta_cpu_debugger_update_register (IAnjutaCpuDebugger *obj, IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_CPU_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_CPU_DEBUGGER_GET_IFACE (obj)->update_register (obj, callback, user_data, err);
}

/**
* ianjuta_debugger_write_register:
* @obj: Self
* @value: fixme
* @err: Error propagation and reporting.
* 
* fixme
*
* Returns: fixme
*/
gboolean
ianjuta_cpu_debugger_write_register (IAnjutaCpuDebugger *obj, IAnjutaDebuggerRegister *value, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_CPU_DEBUGGER(obj), FALSE);
	return IANJUTA_CPU_DEBUGGER_GET_IFACE (obj)->write_register (obj, value, err);
}

static void
ianjuta_cpu_debugger_base_init (gpointer gclass)
{
	static gboolean initialized = FALSE;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_cpu_debugger_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaCpuDebuggerIface),
			ianjuta_cpu_debugger_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaCpuDebugger", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}
