/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-editor-selection.h -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _IANJUTA_EDITOR_SELECTION_H_
#define _IANJUTA_EDITOR_SELECTION_H_

#include <glib-object.h>
#include <libanjuta/interfaces/ianjuta-editor.h>

G_BEGIN_DECLS

#define IANJUTA_TYPE_EDITOR_SELECTION (ianjuta_editor_selection_get_type ())
#define IANJUTA_EDITOR_SELECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IANJUTA_TYPE_EDITOR_SELECTION, IAnjutaEditorSelection))
#define IANJUTA_IS_EDITOR_SELECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IANJUTA_TYPE_EDITOR_SELECTION))
#define IANJUTA_EDITOR_SELECTION_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), IANJUTA_TYPE_EDITOR_SELECTION, IAnjutaEditorSelectionIface))

#define IANJUTA_EDITOR_SELECTION_ERROR ianjuta_editor_selection_error_quark()

typedef struct _IAnjutaEditorSelection IAnjutaEditorSelection;
typedef struct _IAnjutaEditorSelectionIface IAnjutaEditorSelectionIface;

struct _IAnjutaEditorSelectionIface {
	IAnjutaEditorIface g_iface;
	

	void (*clear) (IAnjutaEditorSelection *obj, GError **err);
	void (*copy) (IAnjutaEditorSelection *obj, GError **err);
	void (*cut) (IAnjutaEditorSelection *obj, GError **err);
	gchar* (*get) (IAnjutaEditorSelection *obj, GError **err);
	gint (*get_end) (IAnjutaEditorSelection *obj, GError **err);
	gint (*get_start) (IAnjutaEditorSelection *obj, GError **err);
	void (*paste) (IAnjutaEditorSelection *obj, GError **err);
	void (*replace) (IAnjutaEditorSelection *obj, const gchar *text,  gint length, GError **err);
	void (*select_all) (IAnjutaEditorSelection *obj, GError **err);
	void (*select_block) (IAnjutaEditorSelection *obj, GError **err);
	void (*select_function) (IAnjutaEditorSelection *obj, GError **err);
	void (*select_to_brace) (IAnjutaEditorSelection *obj, GError **err);
	void (*set) (IAnjutaEditorSelection *obj, gint start,  gint end,  gboolean backward, GError **err);

};

GQuark ianjuta_editor_selection_error_quark     (void);
GType  ianjuta_editor_selection_get_type        (void);

void ianjuta_editor_selection_clear (IAnjutaEditorSelection *obj, GError **err);

void ianjuta_editor_selection_copy (IAnjutaEditorSelection *obj, GError **err);

void ianjuta_editor_selection_cut (IAnjutaEditorSelection *obj, GError **err);

gchar* ianjuta_editor_selection_get (IAnjutaEditorSelection *obj, GError **err);

gint ianjuta_editor_selection_get_end (IAnjutaEditorSelection *obj, GError **err);

gint ianjuta_editor_selection_get_start (IAnjutaEditorSelection *obj, GError **err);

void ianjuta_editor_selection_paste (IAnjutaEditorSelection *obj, GError **err);

void ianjuta_editor_selection_replace (IAnjutaEditorSelection *obj, const gchar *text,  gint length, GError **err);

void ianjuta_editor_selection_select_all (IAnjutaEditorSelection *obj, GError **err);

void ianjuta_editor_selection_select_block (IAnjutaEditorSelection *obj, GError **err);

void ianjuta_editor_selection_select_function (IAnjutaEditorSelection *obj, GError **err);

void ianjuta_editor_selection_select_to_brace (IAnjutaEditorSelection *obj, GError **err);

void ianjuta_editor_selection_set (IAnjutaEditorSelection *obj, gint start,  gint end,  gboolean backward, GError **err);


G_END_DECLS

#endif
