// -*- C++ -*-

/* appexample.cc
 * 
 * Copyright (C) 2000 Murray Cumming 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "appexample.h"

AppExample::AppExample()
  : Bakery::App("WithoutDoc", "WithoutDoc"),
  m_Label("Filename"),
  m_Button("Choose File")
{
 m_Box.pack_start(m_Label, false);
 m_Box.pack_start(m_Entry, false);
 m_Box.pack_start(m_Button, false);

 m_Button.clicked.connect(slot(this, &AppExample::on_Button_clicked));
  
 m_Box.show_all();
}

AppExample::~AppExample()
{
 
}

void AppExample::init()
{
  type_vecStrings vecAuthors;
  vecAuthors.push_back("Murray Cumming <murrayc@usa.net>");
  set_about_information("0.1", vecAuthors, _("(C) 2000 Murray Cumming"), _("A Bakery example"));

  //Call base method:
  Bakery::App::init();

  set_contents(m_Box);
}

Bakery::App* AppExample::new_instance()
{
  AppExample* pApp = manage(new AppExample());
  return pApp;
}

void AppExample::on_Button_clicked()
{ 
  bool bSuccess = m_FileSelection.run();
  if(bSuccess)
  {
    string strFilePath = m_FileSelection.get_filename();
    m_Entry.set_text(strFilePath);
  }
}
