#include <bakery/App/Dialog_OverwriteFile.h>
#include <bakery/App/App_Gtk.h>
#include <gtkmm/box.h>
#include <libintl.h>

namespace
{
  Glib::ustring get_confirmation_message(const Glib::ustring& filepath)
  {
    Glib::ustring message = gettext("Do you want to overwrite the existing file?");
    if(!filepath.empty())
      message += gettext("\n\nDocument:\n") + Glib::filename_display_basename(filepath);
    return message;
  }
}

namespace Bakery
{


Dialog_OverwriteFile::Dialog_OverwriteFile(const Glib::ustring& filepath)
#ifdef BAKERY_MAEMO_ENABLED
: Hildon::Note(Hildon::NOTE_TYPE_CONFIRMATION, get_confirmation_message(filepath))
#else
: Gtk::MessageDialog( App_Gtk::util_bold_message(gettext("Overwrite File?")), true /* use markup */, Gtk::MESSAGE_QUESTION, Gtk::BUTTONS_NONE)
#endif
{
  set_title(""); //The HIG says that alert dialogs should not have titles. The default comes from the message type.

#ifndef BAKERY_MAEMO_ENABLED
  set_secondary_text(get_confirmation_message(filepath));
#endif

  add_button(gettext("Overwrite"), BUTTON_Overwrite);
  add_button(gettext("Choose New FileName"), BUTTON_ChooseNewFilename);
}

Dialog_OverwriteFile::~Dialog_OverwriteFile()
{

}


} //namespace
