//
// IIndexer.cs
//
// Copyright (C) 2005 Novell, Inc.
//

//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//

using System;
using System.Collections;

namespace Beagle.Daemon {
	
	// Renamed Uris are interleaved: old uri #1, new uri #1, old uri #2, new uri #2, ...
	// Yes, I know that is ugly.
	public delegate void IIndexerChangedHandler (IIndexer source,
						     ICollection list_of_added_uris,
						     ICollection list_of_removed_uris,
						     ICollection list_of_renamed_uris);

	public delegate void IIndexerChildIndexableHandler (Indexable[] child_indexables);
	public delegate void IIndexerUrisFilteredHandler (FilteredStatus[] list_of_filtered_uris);

	public interface IIndexer {

		void Add (Indexable indexable);

		void Remove (Uri uri);

		void Rename (Uri old_uri, Uri new_uri);

		void Flush ();

		int GetItemCount ();
		
		event IIndexerChangedHandler ChangedEvent;

		event IIndexerChildIndexableHandler ChildIndexableEvent;

		// FIXME: Merge this with ChangedEvent and use some better datastructures
		event IIndexerUrisFilteredHandler UrisFilteredEvent;
	}
}
