//
// LauncherCrawler.cs
//
// Copyright (C) 2005 Novell, Inc.
//

//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//

using System;
using System.Collections;
using System.IO;

using Beagle.Util;
using Beagle.Daemon;

namespace Beagle.Daemon.LauncherQueryable {
	
	class LauncherCrawler {

		ICollection dirs;

		ArrayList launchers = new ArrayList ();

		public LauncherCrawler (ICollection dirs)
		{
			this.dirs = dirs;
		}

		public void Crawl ()
		{
			this.launchers.Clear ();

			Queue pending = new Queue ();

			foreach (string d in this.dirs)
				pending.Enqueue (new DirectoryInfo (d));

			while (pending.Count > 0) {

				DirectoryInfo dir = pending.Dequeue () as DirectoryInfo;

				if (!dir.Exists)
					continue;

				foreach (DirectoryInfo subdir in dir.GetDirectories ())
					pending.Enqueue (subdir);

				foreach (FileInfo file in dir.GetFiles ())
					this.launchers.Add (file);
			}
		}

		public ICollection Launchers {
			get { return this.launchers; } 
		}
	}
}
