/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2005 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.freedesktop.cairo;

import org.gnu.glib.Enum;

public class FillRule extends Enum {

    static final private int _WINDING = 0;
    static final public FillRule WINDING = new FillRule (_WINDING);
    static final private int _EVEN_ODD = 1;
    static final public FillRule EVEN_ODD = new FillRule (_EVEN_ODD);
    static final private FillRule[] theInterned = new FillRule[] {
        WINDING, EVEN_ODD
    };
    static private java.util.Hashtable theInternedExtras;
    static final private FillRule theSacrificialOne = new FillRule (0);
    static public FillRule intern (int value) {
        if (value < theInterned.length) {
            return theInterned[value];
        }
        theSacrificialOne.value_ = value;
        if (theInternedExtras == null) {
            theInternedExtras = new java.util.Hashtable();
        }
        FillRule already = (FillRule) theInternedExtras.get(theSacrificialOne);
        if (already == null) {
            already = new FillRule(value);
            theInternedExtras.put(already, already);
        }
        return already;
    }

    private FillRule(int value) {
        value_ = value;
    }

    public boolean test (FillRule other) {
        return (value_ & other.value_) == other.value_;
    }
}
