/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2005 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.freedesktop.cairo;

public class SurfacePattern extends Pattern {

    public SurfacePattern(Surface surface) {
        super(cairo_pattern_create_for_surface(surface.getHandle()));
    }
    
    /**
     * Sets the extend option for the pattern.
     * @param extend The Extend to use. 
     */
    public void setExtend(Extend extend) {
        cairo_pattern_set_extend(getHandle(), extend.getValue());
    }
    
    /**
     * Returns the current extend option for the pattern.
     * @return The current extend option
     */
    public Extend getExtend() {
        return Extend.intern(cairo_pattern_get_extend(getHandle()));
    }
    
    /**
     * Sets the filter option for the pattern.
     * @param filter  
     */
    public void setFilter(Filter filter) {
        cairo_pattern_set_filter(getHandle(), filter.getValue());
    }
    
    /**
     * Returns the current filter option for the pattern.
     * @return The current filter option (One of the Cairo.FILTER_xxx options).
     */
    public Filter getFilter() {
        return Filter.intern(cairo_pattern_get_filter(getHandle()));
    }
    
}
