/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <stdlib.h>
#include <jni.h>
#include <cairo.h>
#include <jg_jnu.h>

#ifndef _Included_org_freedesktop_cairo_FontOptions
#define _Included_org_freedesktop_cairo_FontOptions
#ifdef __cplusplus
extern "C" {
#endif


/*
 * Class:     org_freedesktop_cairo_FontOptions
 * Method:    cairo_font_options_create
 * Signature: ()Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_freedesktop_cairo_FontOptions_cairo_1font_1options_1create
  (JNIEnv *env, jclass cls)
{
	return getHandleFromPointer(env, cairo_font_options_create());
}

/*
 * Class:     org_freedesktop_cairo_FontOptions
 * Method:    cairo_font_options_set_antialias
 * Signature: (Lorg/gnu/glib/Handle;I)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_FontOptions_cairo_1font_1options_1set_1antialias
  (JNIEnv *env, jclass cls, jobject obj, jint antialias)
{
	cairo_font_options_t *options;
	
	options = (cairo_font_options_t*)getPointerFromHandle(env, obj);
	cairo_font_options_set_antialias(options, (cairo_antialias_t)antialias);
}
/*
 * Class:     org_freedesktop_cairo_FontOptions
 * Method:    cairo_font_options_get_antialias
 * Signature: (Lorg/gnu/glib/Handle;)I
 */
JNIEXPORT jint JNICALL Java_org_freedesktop_cairo_FontOptions_cairo_1font_1options_1get_1antialias
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_font_options_t *options;
	
	options = (cairo_font_options_t*)getPointerFromHandle(env, obj);
	return (jint)cairo_font_options_get_antialias(options);
}

/*
 * Class:     org_freedesktop_cairo_FontOptions
 * Method:    cairo_font_options_set_subpixel_order
 * Signature: (Lorg/gnu/glib/Handle;I)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_FontOptions_cairo_1font_1options_1set_1subpixel_1order
  (JNIEnv *env, jclass cls, jobject obj, jint order)
{
	cairo_font_options_t *options;
	
	options = (cairo_font_options_t*)getPointerFromHandle(env, obj);
	cairo_font_options_set_subpixel_order(options, (cairo_subpixel_order_t)order);
}

/*
 * Class:     org_freedesktop_cairo_FontOptions
 * Method:    cairo_font_options_get_subpixel_order
 * Signature: (Lorg/gnu/glib/Handle;)I
 */
JNIEXPORT jint JNICALL Java_org_freedesktop_cairo_FontOptions_cairo_1font_1options_1get_1subpixel_1order
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_font_options_t *options;
	
	options = (cairo_font_options_t*)getPointerFromHandle(env, obj);
	return (jint)cairo_font_options_get_subpixel_order(options);
}

/*
 * Class:     org_freedesktop_cairo_FontOptions
 * Method:    cairo_font_options_set_hint_style
 * Signature: (Lorg/gnu/glib/Handle;I)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_FontOptions_cairo_1font_1options_1set_1hint_1style
  (JNIEnv *env, jclass cls, jobject obj, jint hint)
{
	cairo_font_options_t *options;
	
	options = (cairo_font_options_t*)getPointerFromHandle(env, obj);
	cairo_font_options_set_hint_style(options, (cairo_hint_style_t)hint);
}

/*
 * Class:     org_freedesktop_cairo_FontOptions
 * Method:    cairo_font_options_get_hint_style
 * Signature: (Lorg/gnu/glib/Handle;)I
 */
JNIEXPORT jint JNICALL Java_org_freedesktop_cairo_FontOptions_cairo_1font_1options_1get_1hint_1style
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_font_options_t *options;
	
	options = (cairo_font_options_t*)getPointerFromHandle(env, obj);
	return (jint)cairo_font_options_get_hint_style(options);
}

/*
 * Class:     org_freedesktop_cairo_FontOptions
 * Method:    cairo_font_options_set_hint_metrics
 * Signature: (Lorg/gnu/glib/Handle;I)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_FontOptions_cairo_1font_1options_1set_1hint_1metrics
  (JNIEnv *env, jclass cls, jobject obj, jint metrics)
{
	cairo_font_options_t *options;
	
	options = (cairo_font_options_t*)getPointerFromHandle(env, obj);
	cairo_font_options_set_hint_metrics(options, (cairo_hint_metrics_t)metrics);
}

/*
 * Class:     org_freedesktop_cairo_FontOptions
 * Method:    cairo_font_options_get_hint_metrics
 * Signature: (Lorg/gnu/glib/Handle;)I
 */
JNIEXPORT jint JNICALL Java_org_freedesktop_cairo_FontOptions_cairo_1font_1options_1get_1hint_1metrics
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_font_options_t *options;
	
	options = (cairo_font_options_t*)getPointerFromHandle(env, obj);
	return (jint)cairo_font_options_get_hint_metrics(options);
}

/*
 * Class:     org_freedesktop_cairo_FontOptions
 * Method:    cairo_font_options_destroy
 * Signature: (Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_FontOptions_cairo_1font_1options_1destroy
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_font_options_t *options;
	
	options = (cairo_font_options_t*)getPointerFromHandle(env, obj);
	cairo_font_options_destroy(options);
}

/*
 * Class:     org_freedesktop_cairo_FontOptions
 * Method:    cairo_font_options_merge
 * Signature: (Lorg/gnu/glib/Handle;Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_FontOptions_cairo_1font_1options_1merge
  (JNIEnv *env, jclass cls, jobject obj, jobject other)
{
	cairo_font_options_t *options;
	cairo_font_options_t *other_g;
	
	options = (cairo_font_options_t*)getPointerFromHandle(env, obj);
	other_g = (cairo_font_options_t*)getPointerFromHandle(env, other);
	cairo_font_options_merge(options, other_g);
	updateHandle(env, obj, options);
} 

/*
 * Class:     org_freedesktop_cairo_FontOptions
 * Method:    cairo_font_options_equal
 * Signature: (Lorg/gnu/glib/Handle;Lorg/gnu/glib/Handle;)Z
 */
JNIEXPORT jboolean JNICALL Java_org_freedesktop_cairo_FontOptions_cairo_1font_1options_1equal
  (JNIEnv *env, jclass cls, jobject obj, jobject other)
{
	cairo_font_options_t *options;
	cairo_font_options_t *other_g;
	
	options = (cairo_font_options_t*)getPointerFromHandle(env, obj);
	other_g = (cairo_font_options_t*)getPointerFromHandle(env, other);
	return cairo_font_options_equal(options, other_g);
}

/*
 * Class:     org_freedesktop_cairo_FontOptions
 * Method:    cairo_font_options_hash
 * Signature: (Lorg/gnu/glib/Handle;)J
 */
JNIEXPORT jlong JNICALL Java_org_freedesktop_cairo_FontOptions_cairo_1font_1options_1hash
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_font_options_t *options;
	
	options = (cairo_font_options_t*)getPointerFromHandle(env, obj);
	return cairo_font_options_hash(options);
}



#ifdef __cplusplus
}
#endif
#endif
