/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2005 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <cairo.h>
#include <jg_jnu.h>

#ifndef _Included_org_freedesktop_cairo_Status
#define _Included_org_freedesktop_cairo_Status
#ifdef __cplusplus
extern "C" {
#endif

/*
 * Class:     org_freedesktop_cairo_Status
 * Method:    cairo_status_to_string
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_freedesktop_cairo_Status_cairo_1status_1to_1string
  (JNIEnv *env, jclass cls, jint status)
{
	return (*env)->NewStringUTF(env, cairo_status_to_string(status));
}

#ifdef __cplusplus
}
#endif
#endif
