#include "cv.h"
#include "highgui.h"
#include "stdio.h"

//http://myopencv.blogspot.com/2008/05/playing-with-images-in-open-computer.html
//gcc `pkg-config --cflags --libs opencv` channels.c -o channels
//test:
// ./channels ~/Desktop/kneeAngle_i_videos/videos/meus/2n_intent/video_full.avi

int main( int argc, char** argv )
{

	int height,width,step,channels;/*We use these variables to work with IplImage Structure Members*/
	uchar *data,*data1,*data2,*data3;
	int i,j,k;/*Variables for Iterations*/

/*
	CvCapture* capture = cvCaptureFromCAM( CV_CAP_ANY );//Read about this function in the help file
	if( !capture ) {//If no capture then Exit from the program.
		fprintf( stderr, "ERROR: capture is NULL \n" );
		getchar();
		exit(0);
	}
	//This is a simple Camera capture framework which you can get it by a google Search.
	IplImage* frame = cvQueryFrame( capture );//Get a frame and store in Iplstructure "frame"
	if (frame==NULL){
		exit(0);
	}
*/

	CvCapture* capture = NULL;
        capture = cvCaptureFromAVI(argv[1]);
	IplImage* frame;
		frame = cvQueryFrame( capture );


	/*Now we create initialize 3 IplImage variables in order to store Three images*/
	IplImage* img1 = cvCreateImage( cvGetSize(frame), 8, 3 );/*for Red */
	IplImage* img2 = cvCreateImage( cvGetSize(frame), 8, 3 );/*for Green*/
	IplImage* img3 = cvCreateImage( cvGetSize(frame), 8, 3 );/*for Blue*/


	/*Initialize windows to show up the frames after all the operations */
	cvNamedWindow( "mywindow", CV_WINDOW_AUTOSIZE );
	cvNamedWindow( "mywindow1", CV_WINDOW_AUTOSIZE );
	cvNamedWindow( "mywindow2", CV_WINDOW_AUTOSIZE );
	cvNamedWindow( "mywindow3", CV_WINDOW_AUTOSIZE );

	// Show the image captured from the camera in the window and repeat
	while( 1 ) {
		// Get one frame
		frame = cvQueryFrame( capture );
		if( !frame ) {
			fprintf( stderr, "ERROR: frame is null...\n" );
			getchar();
			break;
		}
		height = frame->height;/*Height of frame stored in height*/
		width = frame->width;/*width of frame stored in width and the same way below*/
		step = frame->widthStep;
		channels = frame->nChannels;
		data = (uchar *)frame->imageData;
		data1 = (uchar *)img1->imageData;
		data2 = (uchar *)img2->imageData;
		data3 = (uchar *)img3->imageData;
		if( (cvWaitKey(10) & 255) == 27 ) break;

		for(k=0;k<(channels);k++)/*Operating channel wise */
		{
			for(i=0;i<(height);i++)/*operating height wise*/
			{
				for(j=0;j<(width);j++)/*operating Width wise*/
				{
					if(k==0)/*If in Zeroth channel Means Red Channel, copy the image data of red channel,in first channel of img1*/
					{
						data1[i*step+j*channels+k]=data[(i)*step+j*channels+k];
					}
					else data1[i*step+j*channels+k]=0;/*Make data in other channels zero*/
				}
			}
			for(i=0;i<(height);i++)
			{
				for(j=0;j<(width);j++)
				{
					if(k==1)/*Second channel copied */
					{
						data2[i*step+j*channels+k]=data[(i)*step+j*channels+k];
					}
					else data2[i*step+j*channels+k]=0;/*Other than the Required Channel make image data Zero.*/
				}
			}
			for(i=0;i<(height);i++)
			{
				for(j=0;j<(width);j++)
				{
					if (k==2)
					{
						data3[i*step+j*channels+k]=data[(height-i)*step+j*channels+k];
					}
					else data3[i*step+j*channels+k]=0;
				}

			}
			cvShowImage( "mywindow", frame );
			cvShowImage( "mywindow1", img1 );
			cvShowImage( "mywindow2", img2 );
			cvShowImage( "mywindow3", img3 );


		}

	}
	// Release the capture device housekeeping
	cvReleaseCapture( &capture );
	cvDestroyWindow( "mywindow" );/*Releasing all the Initialized sturctures*/
	cvDestroyWindow( "mywindow1" );
	cvDestroyWindow( "mywindow2" );
	cvDestroyWindow( "mywindow3" );
	return 0;
}


/*End of Program*/

