// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_COLOR_H
#define _CLUTTERMM_COLOR_H


#include <glibmm.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/ustring.h>
#include <cluttermm/types.h>
 

#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef struct _ClutterColor ClutterColor; }
#endif

namespace Clutter
{

class Color
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Color CppObjectType;
  typedef ClutterColor BaseObjectType;

  static GType get_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  explicit Color(ClutterColor* gobject, bool make_a_copy = true);

  Color(const Color& other);
  Color& operator=(const Color& other);

  ~Color();

  void swap(Color& other);

  ///Provides access to the underlying C instance.
  ClutterColor*       gobj()       { return gobject_; }

  ///Provides access to the underlying C instance.
  const ClutterColor* gobj() const { return gobject_; }

  ///Provides access to the underlying C instance. The caller is responsible for freeing it. Use when directly setting fields in structs.
  ClutterColor* gobj_copy() const;

protected:
  ClutterColor* gobject_;

private:

  
public:


  // TODO: it'd be nice if these constructors allowed you to specify the alpha
  // value, but the underlying set_from_*() functions don't accept an alpha
  // value so it would have to set the struct member directly.  The struct
  // member is a guint8 type, so the Fixed-point version would need conversions
  // or have an odd signature that takes a guint8 as the last parameter
  
  Color();
  /** Create a new Color object by specifying its value in RGB(A)
   */
  Color(guint8 red, guint8 green, guint8 blue, guint8 alpha=255);

  /** Create a new Color object by specifying its pixel value
   */
  explicit Color(guint32 pixel);

  // TODO: this could fail, just return a 'default' color or throw an exception?
  explicit Color(const Glib::ustring& color);

  void set_from_rgb(guint8 red, guint8 blue, guint8 green);
  void set_from_string(const Glib::ustring& color);
  
  /** Return value: a newly-allocated text string
   * @return A newly-allocated text string
   * 
   * Since: 0.2.
   */
  Glib::ustring to_string() const;
  
  /** Converts a color expressed in HLS (hue, luminance and saturation)
   * values into a Clutter::Color.
   * @param hue Hue value (0 .. 255).
   * @param luminance Luminance value (0 .. 255).
   * @param saturation Saturation value (0 .. 255).
   */
  void set_from_hls(guint8 hue, guint8 luminance, guint8 saturation);
  
  /** Converts a color expressed in HLS (hue, luminance and saturation)
   * values into a Clutter::Color.
   * @param hue Hue value (0 .. 360).
   * @param luminance Luminance value (0 .. 1).
   * @param saturation Saturation value (0 .. 1).
   */
  void set_from_hlsx(Fixed hue, Fixed luminance, Fixed saturation);
  
  /** Converts @a src to the HLS format. Returned HLS values are from interval
   * 0 .. 255.
   * @param hue Return location for the hue value or <tt>0</tt>.
   * @param luminance Return location for the luminance value or <tt>0</tt>.
   * @param saturation Return location for the saturation value or <tt>0</tt>.
   */
  void to_hls(guint8& hue, guint8& luminance, guint8& saturation) const;
  
  /** Converts @a src to the HLS format. Returned hue is in degrees (0 .. 360),
   * luminance and saturation from interval &lt;0 .. 1&gt;.
   * @param hue Return location for the hue value or <tt>0</tt>.
   * @param luminance Return location for the luminance value or <tt>0</tt>.
   * @param saturation Return location for the saturation value or <tt>0</tt>.
   */
  void to_hlsx(Fixed& hue, Fixed& luminance, Fixed& saturation) const;
  
  /** Converts @a pixel from the packed representation of a four 8 bit channel
   * color to a Clutter::Color.
   * @param pixel A 32 bit packed integer containing a color.
   */
  void set_from_pixel(guint32 pixel);
  
  /** Converts @a src into a packed 32 bit integer, containing
   * all the four 8 bit channels used by Clutter::Color.
   * @return A packed color.
   */
  guint32 to_pixel() const;

  
  /** Adds @a src2 to @a src1 and saves the resulting color
   * inside @a dest.
   * 
   * The alpha channel of @a dest is as the maximum value
   * between the alpha channels of @a src1 and @a src2.
   * @param src2 A Clutter::Color.
   * @param dest Return location for the result.
   */

  Color add(const Color& color) const;
  

  /** Subtracts @a src2 from @a src1 and saves the resulting
   * color inside @a dest. This function assumes that the components
   * of @a src1 are greater than the components of @a src2; the result is,
   * otherwise, undefined.
   * 
   * The alpha channel of @a dest is set as the minimum value
   * between the alpha channels of @a src1 and @a src2.
   * @param src2 A Clutter::Color.
   * @param dest Return location for the result.
   */

  Color subtract(const Color& color) const;
  

  // the 'darken', 'lighten', and 'shade' functions modify the source color and
  // store the result in the color object given by the 'dest' argument.  Usually
  // we wrap functions with a 'dest' argument to return a copy by value.
  // However, this means that we could never apply 'darken' directly to this
  // object (as we could in C by doing something like clutter_color_darken(&foo,
  // &foo)).  So I think it makes more sense in the C++ wrappers to darken
  // 'this' by default and if the user wants to darken a different color, they
  // can aways create the copy first and then call darken on it
  // (e.g. Color c2 = c1; c1.darken();).  I think this is more flexible than the
  // alternative.
  
  /** Darkens @a src by a fixed amount, and saves the changed color
   * in @a dest.
   * @param dest Return location for the darker color.
   */

  void darken();
  
  
  /** Lightens @a src by a fixed amount, and saves the changed
   * color in @a dest.
   * @param dest Return location for the lighter color.
   */

  void lighten();
  

  /** Shades @a src by the factor of @a shade and saves the modified
   * color into @a dest.
   * @param dest Return location for the shaded color.
   * @param shade The shade factor to apply.
   */

  void shade(double shade);
  
  
  /** Fixed point version of clutter_color_shade().
   * 
   * Shades @a src by the factor of @a shade and saves the modified
   * color into @a dest.
   * 
   * Since: 0.2
   * @param dest Return location for the shaded color.
   * @param shade Clutter::Fixed the shade factor to apply.
   */

  void shadex(Fixed shade);
  

  // provide accessors/mutators to modify the individual members like you could
  // do in C by directly modifying the struct members
   guint8 get_red() const;
    void set_red(const guint8& value);
    guint8 get_green() const;
    void set_green(const guint8& value);
    guint8 get_blue() const;
    void set_blue(const guint8& value);
    guint8 get_alpha() const;
    void set_alpha(const guint8& value);
 

};

/** @relates Clutter::Color
 * @return the sum of color1 and color2
 */
Color operator+(const Color& color1, const Color& color2);

/** @relates Clutter::Color
 * @return the color resulting from subtracting color2 from color1
 */
Color operator-(const Color& color1, const Color& color2);

} // namespace Clutter


namespace Clutter
{

/** @relates Clutter::Color
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 * @result The result
 */
bool operator==(const Color& lhs, const Color& rhs);

/** @relates Clutter::Color
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 * @result The result
 */
bool operator!=(const Color& lhs, const Color& rhs);


} // namespace Clutter


namespace Clutter
{

/** @relates Clutter::Color
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 */
inline void swap(Color& lhs, Color& rhs)
  { lhs.swap(rhs); }

} // namespace Clutter

namespace Glib
{

/** A Glib::wrap() method for this object.
 * 
 * @param object The C instance.
 * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Clutter::Color
 */
Clutter::Color wrap(ClutterColor* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Clutter::Color> : public Glib::Value_Boxed<Clutter::Color>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


#endif /* _CLUTTERMM_COLOR_H */

