// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_TYPES_H
#define _CLUTTERMM_TYPES_H


#include <glibmm.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <clutter/clutter-types.h>
#include <clutter/clutter-event.h>
#include <clutter/clutter-units.h>
#include <clutter/clutter-color.h>
#include <clutter/clutter-main.h>


namespace Clutter
{

typedef ClutterEvent Event;
typedef ClutterButtonEvent ButtonEvent;
typedef ClutterKeyEvent KeyEvent;
typedef ClutterMotionEvent MotionEvent;
typedef ClutterScrollEvent ScrollEvent;
typedef ClutterCrossingEvent CrossingEvent;

//TODO: Maybe redefine these, to avoid including a C header in our C++ header:
typedef ClutterUnit Unit;
typedef ClutterFixed Fixed;
typedef ClutterAngle Angle;

class InitError : public Glib::Error
{
public:
  enum Code
  {
    INIT_SUCCESS = 1,
    UNKNOWN = 0,
    THREADS = -1,
    BACKEND = -2,
    INTERNAL = -3
  };

  InitError(Code error_code, const Glib::ustring& error_message);
  explicit InitError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static void throw_func(GError* gobject);
#else
  //When not using exceptions, we just pass the Exception object around without throwing it:
  static std::auto_ptr<Glib::Error> throw_func(GError* gobject);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  friend void wrap_init(); // uses throw_func()
#endif
};


/** @addtogroup cluttermmEnums Enums and Flags */

/**
 * @ingroup cluttermmEnums
 */
enum RotateDirection
{
  ROTATE_CW,
  ROTATE_CCW
};


/**
 * @ingroup cluttermmEnums
 */
enum RotateAxis
{
  X_AXIS,
  Y_AXIS,
  Z_AXIS
};


/**
 * @ingroup cluttermmEnums
 */
enum Gravity
{
  GRAVITY_NONE,
  GRAVITY_NORTH,
  GRAVITY_NORTH_EAST,
  GRAVITY_EAST,
  GRAVITY_SOUTH_EAST,
  GRAVITY_SOUTH,
  GRAVITY_SOUTH_WEST,
  GRAVITY_WEST,
  GRAVITY_NORTH_WEST,
  GRAVITY_CENTER
};


/**
 * @ingroup cluttermmEnums
 */
enum RequestMode
{
  REQUEST_HEIGHT_FOR_WIDTH,
  REQUEST_WIDTH_FOR_HEIGHT
};


class Knot
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Knot CppObjectType;
  typedef ClutterKnot BaseObjectType;

  static GType get_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  Knot();

  explicit Knot(const ClutterKnot* gobject); // always takes a copy

  ///Provides access to the underlying C instance.
  ClutterKnot*       gobj()       { return &gobject_; }

  ///Provides access to the underlying C instance.
  const ClutterKnot* gobj() const { return &gobject_; }

protected:
  ClutterKnot gobject_;

private:
  
public:
  Knot(int x, int y);

   int get_x() const;
    void set_x(const int& value);
    int get_y() const;
    void set_y(const int& value);
 
  bool operator==(const Knot& knot) const;


};

class Vertex
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Vertex CppObjectType;
  typedef ClutterVertex BaseObjectType;

  static GType get_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  Vertex();

  explicit Vertex(const ClutterVertex* gobject); // always takes a copy

  ///Provides access to the underlying C instance.
  ClutterVertex*       gobj()       { return &gobject_; }

  ///Provides access to the underlying C instance.
  const ClutterVertex* gobj() const { return &gobject_; }

protected:
  ClutterVertex gobject_;

private:
  
public:
  Vertex(Unit x, Unit y, Unit z = 0);

   Unit get_x() const;
    void set_x(const Unit& value);
    Unit get_y() const;
    void set_y(const Unit& value);
    Unit get_z() const;
    void set_z(const Unit& value);
 

};

class Geometry
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Geometry CppObjectType;
  typedef ClutterGeometry BaseObjectType;

  static GType get_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  Geometry();

  explicit Geometry(const ClutterGeometry* gobject); // always takes a copy

  ///Provides access to the underlying C instance.
  ClutterGeometry*       gobj()       { return &gobject_; }

  ///Provides access to the underlying C instance.
  const ClutterGeometry* gobj() const { return &gobject_; }

protected:
  ClutterGeometry gobject_;

private:
  
public:
  Geometry(int x, int y, unsigned int width = 0, unsigned int height = 0);

   int get_x() const;
    void set_x(const int& value);
    int get_y() const;
    void set_y(const int& value);
    unsigned int get_width() const;
    void set_width(const unsigned int& value);
    unsigned int get_height() const;
    void set_height(const unsigned int& value);
 

};

}


namespace Glib
{

/** @relates Clutter::Knot
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */
Clutter::Knot& wrap(ClutterKnot* object);

/** @relates Clutter::Knot
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */
const Clutter::Knot& wrap(const ClutterKnot* object);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Clutter::Knot> : public Glib::Value_Boxed<Clutter::Knot>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Glib
{

/** @relates Clutter::Vertex
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */
Clutter::Vertex& wrap(ClutterVertex* object);

/** @relates Clutter::Vertex
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */
const Clutter::Vertex& wrap(const ClutterVertex* object);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Clutter::Vertex> : public Glib::Value_Boxed<Clutter::Vertex>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Glib
{

/** @relates Clutter::Geometry
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */
Clutter::Geometry& wrap(ClutterGeometry* object);

/** @relates Clutter::Geometry
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */
const Clutter::Geometry& wrap(const ClutterGeometry* object);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Clutter::Geometry> : public Glib::Value_Boxed<Clutter::Geometry>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


#endif /* _CLUTTERMM_TYPES_H */

