// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_ACTOR_H
#define _CLUTTERMM_ACTOR_H


#include <glibmm.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <cluttermm/color.h>
#include <cluttermm/scriptable.h>
#include <cluttermm/shader.h>
#include <cluttermm/types.h> // For Event*
#include <clutter/clutter.h> // For ClutterActorBox
 

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterActor ClutterActor;
typedef struct _ClutterActorClass ClutterActorClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Actor_Class; } // namespace Clutter
namespace Clutter
{

class ActorBox
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef ActorBox CppObjectType;
  typedef ClutterActorBox BaseObjectType;

  static GType get_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  ActorBox();

  explicit ActorBox(const ClutterActorBox* gobject); // always takes a copy

  ///Provides access to the underlying C instance.
  ClutterActorBox*       gobj()       { return &gobject_; }

  ///Provides access to the underlying C instance.
  const ClutterActorBox* gobj() const { return &gobject_; }

protected:
  ClutterActorBox gobject_;

private:
  
public:
  ActorBox(Unit x1, Unit y1, Unit x2, Unit y2);

   Unit get_x1() const;
    void set_x1(const Unit& value);
    Unit get_y1() const;
    void set_y1(const Unit& value);
    Unit get_x2() const;
    void set_x2(const Unit& value);
    Unit get_y2() const;
    void set_y2(const Unit& value);
 

};

/** @addtogroup cluttermmEnums Enums and Flags */

/**
 * @ingroup cluttermmEnums
 * @par Bitwise operators:
 * <tt>%ActorFlags operator|(ActorFlags, ActorFlags)</tt><br>
 * <tt>%ActorFlags operator&(ActorFlags, ActorFlags)</tt><br>
 * <tt>%ActorFlags operator^(ActorFlags, ActorFlags)</tt><br>
 * <tt>%ActorFlags operator~(ActorFlags)</tt><br>
 * <tt>%ActorFlags& operator|=(ActorFlags&, ActorFlags)</tt><br>
 * <tt>%ActorFlags& operator&=(ActorFlags&, ActorFlags)</tt><br>
 * <tt>%ActorFlags& operator^=(ActorFlags&, ActorFlags)</tt><br>
 */
enum ActorFlags
{
  ACTOR_MAPPED = 1 << 1,
  ACTOR_REALIZED = 1 << 2,
  ACTOR_REACTIVE = 1 << 3
};

/** @ingroup cluttermmEnums */
inline ActorFlags operator|(ActorFlags lhs, ActorFlags rhs)
  { return static_cast<ActorFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline ActorFlags operator&(ActorFlags lhs, ActorFlags rhs)
  { return static_cast<ActorFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline ActorFlags operator^(ActorFlags lhs, ActorFlags rhs)
  { return static_cast<ActorFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline ActorFlags operator~(ActorFlags flags)
  { return static_cast<ActorFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup cluttermmEnums */
inline ActorFlags& operator|=(ActorFlags& lhs, ActorFlags rhs)
  { return (lhs = static_cast<ActorFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup cluttermmEnums */
inline ActorFlags& operator&=(ActorFlags& lhs, ActorFlags rhs)
  { return (lhs = static_cast<ActorFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup cluttermmEnums */
inline ActorFlags& operator^=(ActorFlags& lhs, ActorFlags rhs)
  { return (lhs = static_cast<ActorFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::ActorFlags> : public Glib::Value_Flags<Clutter::ActorFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{


class Actor : public Glib::Object, public Scriptable
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Actor CppObjectType;
  typedef Actor_Class CppClassType;
  typedef ClutterActor BaseObjectType;
  typedef ClutterActorClass BaseClassType;

private:  friend class Actor_Class;
  static CppClassType actor_class_;

private:
  // noncopyable
  Actor(const Actor&);
  Actor& operator=(const Actor&);

protected:
  explicit Actor(const Glib::ConstructParams& construct_params);
  explicit Actor(ClutterActor* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Actor();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterActor*       gobj()       { return reinterpret_cast<ClutterActor*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterActor* gobj() const { return reinterpret_cast<ClutterActor*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterActor* gobj_copy();

private:

  
protected:
  Actor();

public:
  //There is no create() because this is an abstract base class.
  //_WRAP_CREATE()

  void set_flags(ActorFlags flags);
  void unset_flags(ActorFlags flags);
   ActorFlags get_flags() const;
 
  bool is_mapped() const;
  bool is_realized() const;
  bool is_visible() const;
  bool is_reactive() const;

  
  /** Flags an actor to be displayed. An actor that isn't shown will not
   * be rendered on the stage.
   * 
   * Actors are visible by default.
   * 
   * If this function is called on an actor without a parent, the
   * Clutter::Actor:show-on-set-parent will be set to <tt>true</tt> as a side
   * effect.
   */
  void show();
  
  /** Calls show() on all children of an actor (if any).
   * 
   * Since: 0.2
   */
  void show_all();
  
  /** Flags an actor to be hidden. A hidden actor will not be
   * rendered on the stage.
   * 
   * Actors are visible by default.
   * 
   * If this function is called on an actor without a parent, the
   * Clutter::Actor:show-on-set-parent property will be set to <tt>false</tt>
   * as a side-effect.
   */
  void hide();
  
  /** Calls hide() on all child actors (if any).
   * 
   * Since: 0.2
   */
  void hide_all();
  
  /** Creates any underlying graphics resources needed by the actor to be
   * displayed.
   */
  void realize();
  
  /** Frees up any underlying graphics resources needed by the actor to be
   * displayed.
   */
  void unrealize();
  
  /** Renders the actor to display.
   * 
   * This function should not be called directly by applications.
   * Call queue_redraw() to queue paints, instead.
   */
  void paint();
  
  /** Queues up a redraw of an actor and any children. The redraw occurs
   * once the main loop becomes idle (after the current batch of events
   * has been processed, roughly).
   * 
   * Applications rarely need to call this, as redraws are handled
   * automatically by modification functions.
   */
  void queue_redraw();
  
  /** Indicates that the actor's size request or other layout-affecting
   * properties may have changed. This function is used inside Clutter::Actor
   * subclass implementations, not by applications directly.
   * 
   * Queueing a new layout automatically queues a redraw as well.
   * 
   * Since: 0.8
   */
  void queue_relayout();

  //TODO: Check that we don't want to wrap this: _WRAP_METHOD(void destroy(), clutter_actor_destroy)
  //__IGNORE(clutter_actor_destroy)

  
  /** Retrieves the Clutter::Stage where @a actor is contained.
   * @return The stage containing the actor, or <tt>0</tt>
   * 
   * Since: 0.8.
   */
  Glib::RefPtr<Actor> get_stage();
  
  /** Retrieves the Clutter::Stage where @a actor is contained.
   * @return The stage containing the actor, or <tt>0</tt>
   * 
   * Since: 0.8.
   */
  Glib::RefPtr<const Actor> get_stage() const;
 

  /** Sets the actor's fixed position and forces its minimum and natural
   * size, in pixels. This means the untransformed actor will have the
   * given geometry. This is the same as calling set_position()
   * and set_size().
   * @param geometry A Clutter::Geometry.
   */
  void set_geometry(const Geometry& geometry);
  
  /** Gets the size and position of an actor relative to its parent
   * actor. This is the same as calling get_position() and
   * get_size(). It tries to "do what you mean" and get the
   * requested size and position if the actor's allocation is invalid.
   * @param geometry A location to store actors Clutter::Geometry.
   */

  Geometry get_geometry() const;
  //_WRAP_METHOD(void get_coords(int *x_1, int *y_1, int *x_2, int *y_2) const, clutter_actor_get_coords)
  
  /** Sets the actor's size request in pixels. This overrides any
   * "normal" size request the actor would have. For example
   * a text actor might normally request the size of the text;
   * this function would force a specific size instead.
   * 
   * If @a width and/or @a height are -1 the actor will use its
   * "normal" size request instead of overriding it, i.e.
   * you can "unset" the size with -1.
   * 
   * This function sets or unsets both the minimum and natural size.
   * @param width New width of actor in pixels, or -1.
   * @param height New height of actor in pixels, or -1.
   */
  void set_size(int width, int height);
  
  /** Overrides the actor's size request in Clutter::Unit&lt;!-- --&gt;s. If @a width
   * and/or @a height are -1 the actor will use its normal size request (the
   * override is removed).
   * 
   * This function sets or unsets both the minimum and natural size.
   * 
   * Since: 0.6
   * @param width New width of actor in Clutter::Unit&lt;!-- --&gt;s, or -1.
   * @param height New height of actor in Clutter::Unit&lt;!-- --&gt;s, or -1.
   */
  void set_sizeu(Unit width, Unit height);
  
  /** This function tries to "do what you mean" and tell you where the
   * actor is, prior to any transformations. Retrieves the fixed
   * position of an actor in pixels, if one has been set; otherwise, if
   * the allocation is valid, returns the actor's allocated position;
   * otherwise, returns 0,0.
   * 
   * The returned position is in pixels.
   * 
   * Since: 0.6
   * @param x Return location for the X coordinate, or <tt>0</tt>.
   * @param y Return location for the Y coordinate, or <tt>0</tt>.
   */
  void get_position(int& x, int& y);
  
  /** This function tries to "do what you mean" and tell you where the
   * actor is, prior to any transformations. Retrieves the fixed
   * position of an actor in pixels, if one has been set; otherwise, if
   * the allocation is valid, returns the actor's allocated position;
   * otherwise, returns 0,0.
   * 
   * The returned position is in Clutter::Unit&lt;!-- --&gt;s.
   * 
   * Since: 0.6
   * @param x Return location for the X coordinate, or <tt>0</tt>.
   * @param y Return location for the Y coordinate, or <tt>0</tt>.
   */
  void get_positionu(Unit& x, Unit& y);
  
  /** Sets the actor's fixed position in pixels relative to any parent
   * actor.
   * 
   * If a layout manager is in use, this position will override the
   * layout manager and force a fixed position.
   * @param x New left position of actor in pixels.
   * @param y New top position of actor in pixels.
   */
  void set_position(int x, int y);
  
  /** Sets the actor's position in Clutter::Unit&lt;!-- --&gt;s relative to any
   * parent actor.
   * 
   * If a layout manager is in use, this position will override the
   * layout manager and force a fixed position.
   * 
   * Since: 0.6
   * @param x New left position of actor in Clutter::Unit&lt;!-- --&gt;s.
   * @param y New top position of actor in Clutter::Unit&lt;!-- --&gt;s.
   */
  void set_positionu(Unit x, Unit y);
  //_WRAP_METHOD(void get_abs_position(int& x, int& y) const, clutter_actor_get_abs_position)
  
  /** Retrieves the width of a Clutter::Actor.
   * 
   * This function tries to "do what you mean", by returning the correct
   * value depending on the actor's state.
   * 
   * If the actor has a valid allocation, this function will return the
   * width of the allocation box.
   * 
   * If the actor does not have a valid allocation, this function will
   * return the actor's natural width request.
   * 
   * If you care whether you get the width request or the allocation,
   * you should probably call a different function like
   * get_allocation_coords() to retrieve the allocation
   * or get_preferred_width() to retrieve the preferred
   * width.
   * @return The width of the actor, in pixels.
   */
  guint get_width() const;
  
  /** Retrieves the width of a Clutter::Actor, in Clutter::Unit&lt;!-- --&gt;s.
   * 
   * This function tries to "do what you mean", by returning the correct
   * value depending on the actor's state.
   * 
   * If the actor has a valid allocation, this function will return the
   * width of the allocation box.
   * 
   * If the actor does not have a valid allocation, this function will
   * return the actor's natural width request.
   * 
   * If you care whether you get the width request or the allocation,
   * you should probably call a different function like
   * get_allocation_coords() to retrieve the allocation
   * or get_preferred_width() to retrieve the preferred
   * width.
   * @return The width of the actor, in Clutter::Unit&lt;!-- --&gt;s
   * 
   * since: 0.6.
   */
  Unit get_widthu() const;
  
  /** Retrieves the height of a Clutter::Actor.
   * 
   * This function tries to "do what you mean", by returning the correct
   * value depending on the actor's state.
   * 
   * If the actor has a valid allocation, this function will return the
   * height of the allocation box.
   * 
   * If the actor does not have a valid allocation, this function will
   * return the actor's natural height request.
   * 
   * If you care whether you get the height request or the allocation,
   * you should probably call a different function like
   * get_allocation_coords() to retrieve the allocation
   * or get_preferred_height() to retrieve the
   * preferred height.
   * @return The height of the actor, in pixels.
   */
  guint get_height() const;
  
  /** Retrieves the height of a Clutter::Actor, in Clutter::Unit&lt;!-- --&gt;s.
   * 
   * This function tries to "do what you mean", by returning the correct
   * value depending on the actor's state.
   * 
   * If the actor has a valid allocation, this function will return the
   * height of the allocation box.
   * 
   * If the actor does not have a valid allocation, this function will
   * return the actor's natural height request.
   * 
   * If you care whether you get the height request or the allocation,
   * you should probably call a different function like
   * get_allocation_coords() to retrieve the allocation
   * or get_preferred_height() to retrieve the
   * preferred height.
   * @return The height of the actor, in Clutter::Unit&lt;!-- --&gt;s
   * 
   * since: 0.6.
   */
  Unit get_heightu() const;
  
  /** Forces a width request on an actor, causing the actor's
   * normal width and height (if any) to be ignored. This function
   * sets both the minimum and natural size request of the actor.
   * 
   * since: 0.2
   * @param width Requested new width for the actor, in pixels.
   */
  void set_width(guint width);
  
  /** Forces a width request on an actor, causing the actor's
   * normal width and height (if any) to be ignored. This function
   * sets both the minimum and natural size request of the actor.
   * 
   * since: 0.6
   * @param width Requested new width for the actor, in Clutter::Unit&lt;!-- --&gt;s.
   */
  void set_widthu(Unit width);
  
  /** Forces a height request on an actor, causing the actor's
   * normal width and height (if any) to be ignored. This function
   * sets both the minimum and natural size request of the actor.
   * 
   * since: 0.2
   * @param height Requested new height for the actor, in pixels.
   */
  void set_height(guint height);
  
  /** Forces a height request on an actor, causing the actor's
   * normal width and height (if any) to be ignored. This function
   * sets both the minimum and natural size request of the actor.
   * 
   * since: 0.6
   * @param height Requested new height for the actor, in Clutter::Unit&lt;!-- --&gt;s.
   */
  void set_heightu(Unit height);

  
  /** Sets the actor's X coordinate, relative to its parent, in pixels.
   * Overrides any layout manager and forces a fixed position for
   * the actor.
   * 
   * Since: 0.6
   * @param x The actor's position on the X axis.
   */
  void set_x(int x);
  
  /** Sets the actor's X coordinate, relative to its parent.
   * Overrides any layout manager and forces a fixed position for
   * the actor.
   * 
   * Since: 0.6
   * @param x The actor's position on the X axis, in Clutter::Unit&lt;!-- --&gt;s.
   */
  void set_xu(Unit x);
  
  /** Retrieves the X coordinate of a Clutter::Actor.
   * 
   * This function tries to "do what you mean", by returning the
   * correct value depending on the actor's state.
   * 
   * If the actor has a valid allocation, this function will return
   * the X coordinate of the origin of the allocation box.
   * 
   * If the actor has any fixed coordinate set using set_x(),
   * set_position() or set_geometry(), this
   * function will return that coordinate.
   * 
   * If both the allocation and a fixed position are missing, this function
   * will return 0.
   * @return The X coordinate, in pixels, ignoring any
   * transformation (i.e. scaling, rotation).
   */
  int get_x() const;
  
  /** Retrieves the X coordinate of a Clutter::Actor, in Clutter::Unit&lt;!-- --&gt;s.
   * 
   * This function tries to "do what you mean", by returning the
   * correct value depending on the actor's state.
   * 
   * If the actor has a valid allocation, this function will return
   * the X coordinate of the origin of the allocation box.
   * 
   * If the actor has any fixed coordinate set using set_x(),
   * set_position() or set_geometry(), this
   * function will return that coordinate.
   * 
   * If both the allocation and a fixed position are missing, this function
   * will return 0.
   * @return The X coordinate, in Clutter::Unit&lt;!-- --&gt;s, ignoring
   * any transformation (i.e. scaling, rotation)
   * 
   * Since: 0.6.
   */
  Unit get_xu() const;
  
  /** Sets the actor's Y coordinate, relative to its parent, in pixels.
   * Overrides any layout manager and forces a fixed position for
   * the actor.
   * 
   * Since: 0.6
   * @param y The actor's position on the Y axis.
   */
  void set_y(int y);
  
  /** Sets the actor's Y coordinate, relative to its parent.
   * Overrides any layout manager and forces a fixed position for
   * the actor.
   * 
   * Since: 0.6
   * @param y The actor's position on the Y axis, in Clutter::Unit&lt;!-- --&gt;s.
   */
  void set_yu(Unit y);
  
  /** Retrieves the Y coordinate of a Clutter::Actor.
   * 
   * This function tries to "do what you mean", by returning the
   * correct value depending on the actor's state.
   * 
   * If the actor has a valid allocation, this function will return
   * the Y coordinate of the origin of the allocation box.
   * 
   * If the actor has any fixed coordinate set using set_y(),
   * set_position() or set_geometry(), this
   * function will return that coordinate.
   * 
   * If both the allocation and a fixed position are missing, this function
   * will return 0.
   * @return The Y coordinate, in pixels, ignoring any
   * transformation (i.e. scaling, rotation).
   */
  int get_y() const;
  
  /** Retrieves the Y coordinate of a Clutter::Actor, in Clutter::Unit&lt;!-- --&gt;s.
   * 
   * This function tries to "do what you mean", by returning the
   * correct value depending on the actor's state.
   * 
   * If the actor has a valid allocation, this function will return
   * the Y coordinate of the origin of the allocation box.
   * 
   * If the actor has any fixed coordinate set using set_y(),
   * set_position() or set_geometry(), this
   * function will return that coordinate.
   * 
   * If both the allocation and a fixed position are missing, this function
   * will return 0.
   * @return The Y coordinate, in Clutter::Unit&lt;!-- --&gt;s, ignoring
   * any transformation (i.e. scaling, rotation)
   * 
   * Since: 0.6.
   */
  Unit get_yu() const;
  
  /** Sets @a actor as reactive. Reactive actors will receive events.
   * 
   * Since: 0.6
   * @param reactive Whether the actor should be reactive to events.
   */
  void set_reactive(bool reactive = true);
  
  /** Checks whether @a actor is marked as reactive.
   * @return <tt>true</tt> if the actor is reactive
   * 
   * Since: 0.6.
   */
  bool get_reactive() const;

  
  /** Sets the rotation angle of @a self around the given axis.
   * 
   * The rotation center coordinates used depend on the value of @a axis:
   * &lt;itemizedlist&gt;
   * &lt;listitem&gt;Clutter::X_AXIS requires @a y and @a z&lt;/listitem&gt;
   * &lt;listitem&gt;Clutter::Y_AXIS requires @a x and @a z&lt;/listitem&gt;
   * &lt;listitem&gt;Clutter::Z_AXIS requires @a x and @a y&lt;/listitem&gt;
   * &lt;/itemizedlist&gt;
   * 
   * The rotation coordinates are relative to the anchor point of the
   * actor, set using set_anchor_point(). If no anchor
   * point is set, the upper left corner is assumed as the origin.
   * 
   * Since: 0.6
   * @param axis The axis of rotation.
   * @param angle The angle of rotation.
   * @param x X coordinate of the rotation center.
   * @param y Y coordinate of the rotation center.
   * @param z Z coordinate of the rotation center.
   */
  void set_rotation(RotateAxis axis, double angle, int x, int y, int z);
  
  /** Sets the rotation angle of @a self around the given axis.
   * 
   * This function is the fixed point variant of set_rotation().
   * 
   * Since: 0.6
   * @param axis The axis of rotation.
   * @param angle The angle of rotation.
   * @param x X coordinate of the rotation center.
   * @param y Y coordinate of the rotation center.
   * @param z Z coordinate of the rotation center.
   */
  void set_rotationx(RotateAxis axis, Fixed angle, int x, int y, int z);
  
  /** Sets the rotation angle of @a self around the given axis.
   * 
   * This function is the units based variant of set_rotation().
   * 
   * Since: 0.8
   * @param axis The axis of rotation.
   * @param angle The angle of rotation.
   * @param x X coordinate of the rotation center, in Clutter::Unit&lt;!-- --&gt;s.
   * @param y Y coordinate of the rotation center, in Clutter::Unit&lt;!-- --&gt;s.
   * @param z Z coordinate of the rotation center, in Clutter::Unit&lt;!-- --&gt;s.
   */
  void set_rotationu(RotateAxis axis, double angle, Unit x, Unit y, Unit z);
  
  /** Retrieves the angle and center of rotation on the given axis,
   * set using clutter_actor_set_angle().
   * 
   * The coordinates of the center returned by this function depend on
   * the axis passed.
   * @param axis The axis of rotation.
   * @param x Return value for the X coordinate of the center of rotation.
   * @param y Return value for the Y coordinate of the center of rotation.
   * @param z Return value for the Z coordinate of the center of rotation.
   * @return The angle of rotation.
   * 
   * Since: 0.6.
   */
  double get_rotation(RotateAxis axis, int& x, int& y, int& z) const;
  
  /** Retrieves the angle and center of rotation on the given axis,
   * set using set_rotation().
   * 
   * This function is the fixed point variant of get_rotation().
   * @param axis The axis of rotation.
   * @param x Return value for the X coordinate of the center of rotation.
   * @param y Return value for the Y coordinate of the center of rotation.
   * @param z Return value for the Z coordinate of the center of rotation.
   * @return The angle of rotation as a fixed point value.
   * 
   * Since: 0.6.
   */
  Fixed get_rotationx(RotateAxis axis, int& x, int& y, int& z) const;
  
  /** Retrieves the angle and center of rotation on the given axis,
   * set using set_rotation().
   * 
   * This function is the units based variant of get_rotation().
   * @param axis The axis of rotation.
   * @param x Return value for the X coordinate of the center of rotation,
   * in Clutter::Unit&lt;!-- --&gt;s.
   * @param y Return value for the Y coordinate of the center of rotation,
   * in Clutter::Unit&lt;!-- --&gt;s.
   * @param z Return value for the Z coordinate of the center of rotation,
   * in Clutter::Unit&lt;!-- --&gt;s.
   * @return The angle of rotation
   * 
   * Since: 0.8.
   */
  double get_rotationu(RotateAxis axis, Unit& x, Unit& y, Unit& z) const;
  
  /** Sets the actor's opacity, with zero being completely transparent and
   * 255 (0xff) being fully opaque.
   * @param opacity New opacity value for the actor.
   */
  void set_opacity (guint8 opacity);
  
  /** Retrieves the opacity value of an actor, as set by
   * set_opacity().
   * 
   * For retrieving the absolute opacity of the actor inside a paint
   * virtual function, see get_paint_opacity().
   * @return The opacity of the actor.
   */
  guint8 get_opacity() const;
  
  /** Sets the given name to @a self. The name can be used to identify
   * a Clutter::Actor.
   * @param name Textual tag to apply to actor.
   */
  void set_name(const gchar           *name);
  
  /** Retrieves the name of @a self.
   * @return The name of the actor, or <tt>0</tt>. The returned string is
   * owned by the actor and should not be modified or freed.
   */
  Glib::ustring get_name() const;
  
  /** Retrieves the unique id for @a self.
   * @return Globally unique value for this object instance.
   * 
   * Since: 0.6.
   */
  guint32 get_gid() const;
  
  /** Sets clip area in pixels for @a self. The clip area is always computed
   * from the upper left corner of the actor, even if the anchor point is
   * set otherwise.
   * @param xoff X offset of the clip rectangle, in pixels.
   * @param yoff Y offset of the clip rectangle, in pixels.
   * @param width Width of the clip rectangle, in pixels.
   * @param height Height of the clip rectangle, in pixels.
   */
  void set_clip(int xoff, int yoff, int width, int height);
  
  /** Gets the clip area for @a self, in pixels.
   * 
   * Since: 0.6
   * @param xoff Return location for the X offset of the clip rectangle, or <tt>0</tt>.
   * @param yoff Return location for the Y offset of the clip rectangle, or <tt>0</tt>.
   * @param width Return location for the width of the clip rectangle, or <tt>0</tt>.
   * @param height Return location for the height of the clip rectangle, or <tt>0</tt>.
   */
  void get_clip(int& xoff, int& yoff, int& width, int& height);
  
  /** Unit-based variant of set_clip()
   * 
   * Sets clip area for @a self. The clip area is always computed from the
   * upper left corner of the actor, even if the anchor point is set
   * otherwise.
   * 
   * Since: 0.6
   * @param xoff X offset of the clip rectangle, in Clutter::Unit&lt;!-- --&gt;s.
   * @param yoff Y offset of the clip rectangle, in Clutter::Unit&lt;!-- --&gt;s.
   * @param width Width of the clip rectangle, in Clutter::Unit&lt;!-- --&gt;s.
   * @param height Height of the clip rectangle, in Clutter::Unit&lt;!-- --&gt;s.
   */
  void set_clipu(Unit xoff, Unit yoff, Unit width, Unit height);
  
  /** Unit-based variant of get_clip().
   * 
   * Gets the clip area for @a self, in Clutter::Unit&lt;!-- --&gt;s.
   * 
   * Since: 0.6
   * @param xoff Return location for the X offset of the clip rectangle, or <tt>0</tt>.
   * @param yoff Return location for the Y offset of the clip rectangle, or <tt>0</tt>.
   * @param width Return location for the width of the clip rectangle, or <tt>0</tt>.
   * @param height Return location for the height of the clip rectangle, or <tt>0</tt>.
   */
  void get_clipu(Unit& xoff, Unit& yoff, Unit& width, Unit& height);
  
  /** Removes clip area from @a self.
   */
  void remove_clip();
  
  /** Determines whether the actor has a clip area set or not.
   * @return <tt>true</tt> if the actor has a clip area set.
   * 
   * Since: 0.1.1.
   */
  bool has_clip() const;
  
  /** Sets the parent of @a self to @a parent.  The opposite function is
   * unparent().
   * 
   * This function should not be used by applications, but by custom
   * 'composite' actor subclasses.
   * @param parent A new Clutter::Actor parent.
   */
  void set_parent(const Glib::RefPtr<Actor>& parent);
  
  /** Retrieves the parent of @a self.
   * @return The Clutter::Actor parent, or <tt>0</tt> if no parent is set.
   */
  Glib::RefPtr<Actor> get_parent();
  
  /** Retrieves the parent of @a self.
   * @return The Clutter::Actor parent, or <tt>0</tt> if no parent is set.
   */
  Glib::RefPtr<const Actor> get_parent() const;
  
  /** This function resets the parent actor of @a self.  It is
   * logically equivalent to calling unparent()
   * and set_parent().
   * 
   * Since: 0.2
   * @param new_parent The new Clutter::Actor parent.
   */
  void reparent(const Glib::RefPtr<Actor>& new_parent);
  
  /** This function should not be used in applications.  It should be called by
   * implementations of container actors, to dissociate a child from the
   * container.
   * 
   * Since: 0.1.1
   */
  void unparent();
  
  /** Puts @a self above @a below.
   * 
   * Both actors must have the same parent.
   * @param below A Clutter::Actor to raise above.
   */
  void raise(const Glib::RefPtr<Actor>& below);
  
  /** Puts @a self below @a above.
   * Both actors must have the same parent.
   * @param above A Clutter::Actor to lower below.
   */
  void lower(const Glib::RefPtr<Actor>& above);
  
  /** Raises @a self to the top.
   */
  void raise_top ();
  
  /** Lowers @a self to the bottom.
   */
  void lower_bottom();

  
  /** Queries the currently set Clutter::Shader on @a self.
   * @return The currently set Clutter::Shader or <tt>0</tt> if no
   * shader is set.
   * 
   * Since: 0.6.
   */
  Glib::RefPtr<Shader> get_shader();
  
  /** Queries the currently set Clutter::Shader on @a self.
   * @return The currently set Clutter::Shader or <tt>0</tt> if no
   * shader is set.
   * 
   * Since: 0.6.
   */
  Glib::RefPtr<const Shader> get_shader() const;
  
  /** Sets the Clutter::Shader to be used when rendering @a self.
   * If @a shader is <tt>0</tt> it will unset any currently set shader
   * for the actor.
   * @param shader A Clutter::Shader or <tt>0</tt> to unset the shader.
   * @return <tt>true</tt> if the shader was successfully applied
   * 
   * Since: 0.6.
   */
  void set_shader(const Glib::RefPtr<Shader>& shader);
  
  /** Sets the value for a named parameter of the shader applied
   * to @a actor.
   * 
   * Since: 0.6
   * @param param The name of the parameter.
   * @param value The value of the parameter.
   */

  template <class ParamType> void set_shader_param(const Glib::ustring& param, const ParamType& value);
  //_WRAP_METHOD_DOCS_ONLY(clutter_actor_get_paint_area)
  //ActorBox get_paint_area() const;
  
  /** Checks whether any rotation is applied to the actor.
   * @return <tt>true</tt> if the actor is rotated.
   * 
   * Since: 0.6.
   */
  bool is_rotated() const;
  
  /** Checks whether the actor is scaled in either dimension.
   * @return <tt>true</tt> if the actor is scaled.
   * 
   * Since: 0.6.
   */
  bool is_scaled() const;
  
  /** Calculates the transformed coordinates of the four corners of the
   * actor in the plane of @a ancestor. The returned vertices relate to
   * the Clutter::ActorBox coordinates as follows:
   * &lt;itemizedlist&gt;
   * &lt;listitem&gt;v[0] contains (x1, y1)&lt;/listitem&gt;
   * &lt;listitem&gt;v[1] contains (x2, y1)&lt;/listitem&gt;
   * &lt;listitem&gt;v[2] contains (x1, y2)&lt;/listitem&gt;
   * &lt;listitem&gt;v[3] contains (x2, y2)&lt;/listitem&gt;
   * &lt;/itemizedlist&gt;
   * 
   * If @a ancestor is <tt>0</tt> the ancestor will be the Clutter::Stage. In
   * this case, the coordinates returned will be the coordinates on
   * the stage before the projection is applied. This is different from
   * the behaviour of get_abs_allocation_vertices().
   * 
   * Since: 0.6
   * @param ancestor A Clutter::Actor to calculate the vertices against, or <tt>0</tt>
   * to use the default Clutter::Stage.
   * @param verts Return location for an array of 4 Clutter::Vertex in which
   * to store the result.
   */

  void get_allocation_vertices(Vertex vertices[4]) const;
  
  /** Calculates the transformed coordinates of the four corners of the
   * actor in the plane of @a ancestor. The returned vertices relate to
   * the Clutter::ActorBox coordinates as follows:
   * &lt;itemizedlist&gt;
   * &lt;listitem&gt;v[0] contains (x1, y1)&lt;/listitem&gt;
   * &lt;listitem&gt;v[1] contains (x2, y1)&lt;/listitem&gt;
   * &lt;listitem&gt;v[2] contains (x1, y2)&lt;/listitem&gt;
   * &lt;listitem&gt;v[3] contains (x2, y2)&lt;/listitem&gt;
   * &lt;/itemizedlist&gt;
   * 
   * If @a ancestor is <tt>0</tt> the ancestor will be the Clutter::Stage. In
   * this case, the coordinates returned will be the coordinates on
   * the stage before the projection is applied. This is different from
   * the behaviour of get_abs_allocation_vertices().
   * 
   * Since: 0.6
   * @param ancestor A Clutter::Actor to calculate the vertices against, or <tt>0</tt>
   * to use the default Clutter::Stage.
   * @param verts Return location for an array of 4 Clutter::Vertex in which
   * to store the result.
   */

  void get_allocation_vertices(const Glib::RefPtr<Actor>& ancestor, Vertex vertices[4]) const;
  
  /** Calculates the transformed screen coordinates of the four corners of
   * the actor; the returned vertices relate to the Clutter::ActorBox
   * coordinates  as follows:
   * &lt;itemizedlist&gt;
   * &lt;listitem&gt;v[0] contains (x1, y1)&lt;/listitem&gt;
   * &lt;listitem&gt;v[1] contains (x2, y1)&lt;/listitem&gt;
   * &lt;listitem&gt;v[2] contains (x1, y2)&lt;/listitem&gt;
   * &lt;listitem&gt;v[3] contains (x2, y2)&lt;/listitem&gt;
   * &lt;/itemizedlist&gt;
   * 
   * Since: 0.4
   * @param verts Pointer to a location of an array of 4 Clutter::Vertex where to
   * store the result.
   */

  void get_abs_allocation_vertices(Vertex vertices[4]) const;
  
  /** Gets the layout box an actor has been assigned. The allocation can
   * only be assumed valid inside a paint() method; anywhere else, it
   * may be out-of-date.
   * 
   * An allocation does not incorporate the actor's scale or anchor point;
   * those transformations do not affect layout, only rendering.
   * 
   * &lt;note&gt;Do not call any of the clutter_actor_get_allocation_*() family
   * of functions inside the implementation of the get_preferred_width()
   * or get_preferred_height() virtual functions.&lt;/note&gt;
   * 
   * Since: 0.8
   * @param box The function fills this in with the actor's allocation.
   */

  ActorBox get_allocation_box() const;
 

  /** Called by the parent of an actor to assign the actor its size.
   * Should never be called by applications (except when implementing
   * a container or layout manager).
   * 
   * Actors can know from their allocation box whether they have moved
   * with respect to their parent actor. The absolute_origin_changed
   * parameter additionally indicates whether the parent has moved with
   * respect to the stage, for example because a grandparent's origin
   * has moved.
   * 
   * Since: 0.8
   * @param box New allocation of the actor, in parent-relative coordinates.
   * @param absolute_origin_changed Whether the position of the parent has
   * changed in stage coordinates.
   */
  void allocate(const ActorBox& box, bool absolute_origin_changed);

 
  /** Transforms @a point in coordinates relative to the actor into
   * ancestor-relative coordinates using the relevant transform
   * stack (i.e.\ scale, rotation, etc).
   * 
   * If @a ancestor is <tt>0</tt> the ancestor will be the Clutter::Stage. In
   * this case, the coordinates returned will be the coordinates on
   * the stage before the projection is applied. This is different from
   * the behaviour of apply_transform_to_point().
   * 
   * Since: 0.6
   * @param ancestor A Clutter::Actor ancestor, or <tt>0</tt> to use the
   * default Clutter::Stage.
   * @param point A point as Clutter::Vertex.
   * @param vertex The translated Clutter::Vertex.
   */
  void apply_relative_transform_to_point(const Glib::RefPtr<Actor>& ancestor, const Vertex& point, Vertex& vertex) const;
  
  /** Calculates the transformed coordinates of the four corners of the
   * actor in the plane of @a ancestor. The returned vertices relate to
   * the Clutter::ActorBox coordinates as follows:
   * &lt;itemizedlist&gt;
   * &lt;listitem&gt;v[0] contains (x1, y1)&lt;/listitem&gt;
   * &lt;listitem&gt;v[1] contains (x2, y1)&lt;/listitem&gt;
   * &lt;listitem&gt;v[2] contains (x1, y2)&lt;/listitem&gt;
   * &lt;listitem&gt;v[3] contains (x2, y2)&lt;/listitem&gt;
   * &lt;/itemizedlist&gt;
   * 
   * If @a ancestor is <tt>0</tt> the ancestor will be the Clutter::Stage. In
   * this case, the coordinates returned will be the coordinates on
   * the stage before the projection is applied. This is different from
   * the behaviour of get_abs_allocation_vertices().
   * 
   * Since: 0.6
   * @param ancestor A Clutter::Actor to calculate the vertices against, or <tt>0</tt>
   * to use the default Clutter::Stage.
   * @param verts Return location for an array of 4 Clutter::Vertex in which
   * to store the result.
   */

  void apply_relative_transform_to_point(const Vertex& point, Vertex& vertex) const;

  
  /** Computes the preferred minimum and natural size of an actor, taking into
   * account the actor's geometry management (either height-for-width
   * or width-for-height).
   * 
   * The width and height used to compute the preferred height and preferred
   * width are the actor's natural ones.
   * 
   * If you need to control the height for the preferred width, or the width for
   * the preferred height, you should use get_preferred_width()
   * and get_preferred_height(), and check the actor's preferred
   * geometry management using the Clutter::Actor:request-mode property.
   * 
   * Since: 0.8
   * @param min_width_p Return location for the minimum width, or <tt>0</tt>.
   * @param min_height_p Return location for the minimum height, or <tt>0</tt>.
   * @param natural_width_p Return location for the natural width, or <tt>0</tt>.
   * @param natural_height_p Return location for the natural height, or <tt>0</tt>.
   */
  void get_preferred_size(Unit& min_width_p, Unit& min_height_p, Unit& natural_width_p, Unit& natural_height_p) const;
  
  /** Computes the requested minimum and natural widths for an actor,
   * optionally depending on the specified height, or if they are
   * already computed, returns the cached values.
   * 
   * An actor may not get its request - depending on the layout
   * manager that's in effect.
   * 
   * A request should not incorporate the actor's scale or anchor point;
   * those transformations do not affect layout, only rendering.
   * 
   * Since: 0.8
   * @param for_height Available height when computing the preferred width,
   * or a negative value to indicate that no height is defined.
   * @param min_width_p Return location for min width, or <tt>0</tt>.
   * @param natural_width_p Return location for min width, or <tt>0</tt>.
   */
  void get_preferred_width(Unit for_height, Unit& min_width_p, Unit& natural_width_p) const;
  
  /** Computes the requested minimum and natural heights for an actor,
   * or if they are already computed, returns the cached values.
   * 
   * An actor may not get its request - depending on the layout
   * manager that's in effect.
   * 
   * A request should not incorporate the actor's scale or anchor point;
   * those transformations do not affect layout, only rendering.
   * 
   * Since: 0.8
   * @param for_width Available width to assume in computing desired height,
   * or a negative value to indicate that no width is defined.
   * @param min_height_p Return location for min height, or <tt>0</tt>.
   * @param natural_height_p Return location for natural height, or <tt>0</tt>.
   */
  void get_preferred_height(Unit for_width, Unit& min_height_p, Unit& natural_height_p) const;
  
  /** Retrieves the absolute opacity of the actor, as it appears on the stage.
   * 
   * This function traverses the hierarchy chain and composites the opacity of
   * the actor with that of its parents.
   * 
   * This function is intended for subclasses to use in the paint virtual
   * function, to paint themselves with the correct opacity.
   * @return The actor opacity value.
   * 
   * Since: 0.8.
   */
  guint8 get_paint_opacity() const;
  
  /** Sets an anchor point on the actor based on the given gravity, adjusting the
   * actor postion so that its relative position within its parent remains
   * unchanged.
   * 
   * Since: 0.6
   * @param gravity Clutter::Gravity.
   */
  void move_anchor_point_from_gravity(Gravity gravity);
  
  /** Sets an anchor point for the @a actor, and adjusts the actor postion so
   * that the relative position of the actor toward its parent remains the
   * same.
   * 
   * Since: 0.6
   * @param anchor_x X coordinate of the anchor point.
   * @param anchor_y Y coordinate of the anchor point.
   */
  void move_anchor_point(int anchor_x, int anchor_y);
  
  /** Sets an anchor point for the actor, and adjusts the actor postion so that
   * the relative position of the actor toward its parent remains the same.
   * 
   * Since: 0.6
   * @param anchor_x X coordinate of the anchor point.
   * @param anchor_y Y coordinate of the anchor point.
   */
  void move_anchor_pointu(Unit anchor_x, Unit anchor_y);

  
  /** Checks whether an actor has a fixed position set (and will thus be
   * unaffected by any layout manager).
   * @return <tt>true</tt> if the fixed position is set on the actor
   * 
   * Since: 0.8.
   */
  bool get_fixed_position_set() const;
  
  /** Sets whether an actor has a fixed position set (and will thus be
   * unaffected by any layout manager).
   * 
   * Since: 0.8
   * @param is_set Whether to use fixed position.
   */
  void set_fixed_position_set(bool is_set);
  
  /** Gets the absolute position of an actor, in pixels, relative
   * to the stage.
   * 
   * Since: 0.8
   * @param x Return location for the X coordinate, or <tt>0</tt>.
   * @param y Return location for the Y coordinate, or <tt>0</tt>.
   */
  void get_transformed_position(int& x, int& y) const;
  
  /** Gets the absolute position of an actor, in Clutter::Unit&lt;!-- --&gt;s,
   * relative to the stage.
   * 
   * Since: 0.8
   * @param x Return location for the X coordinate, or <tt>0</tt>.
   * @param y Return location for the Y coordinate, or <tt>0</tt>.
   */
  void get_transformed_positionu(Unit& x, Unit& y) const;
  
  /** Gets the absolute size of an actor taking into account
   * any scaling factors
   * 
   * Since: 0.8
   * @param width Return location for the width, or <tt>0</tt>.
   * @param height Return location for the height, or <tt>0</tt>.
   */
  void get_transformed_size(guint& width, guint& height) const;
  
  /** Gets the absolute size of an actor in Clutter::Units&lt;!-- --&gt;s, taking
   * into account the scaling factors.
   * 
   * &lt;note&gt;When the actor (or one of its ancestors) is rotated around the
   * X or Y axis, it no longer appears as on the stage as a rectangle, but
   * as a generic quadrangle; in that case this function returns the size
   * of the smallest rectangle that encapsulates the entire quad. Please
   * note that in this case no assumptions can be made about the relative
   * position of this envelope to the absolute position of the actor, as
   * returned by get_transformed_position(); if you need this
   * information, you need to use get_abs_allocation_vertices()
   * to get the coords of the actual quadrangle.&lt;/note&gt;
   * 
   * Since: 0.8
   * @param width Return location for the width, or <tt>0</tt>.
   * @param height Return location for the height, or <tt>0</tt>.
   */
  void get_transformed_sizeu(Unit& width, Unit& height) const;
  
  /** Gets the layout box an actor has been assigned.  The allocation can
   * only be assumed valid inside a paint() method; anywhere else, it
   * may be out-of-date.
   * 
   * An allocation does not incorporate the actor's scale or anchor point;
   * those transformations do not affect layout, only rendering.
   * 
   * The returned coordinates are in pixels.
   * 
   * Since: 0.8
   * @param x1 X1 coord.
   * @param y1 Y1 coord.
   * @param x2 X2 coord.
   * @param y2 Y2 coord.
   */
  void get_allocation_coords(int& x1, int& y1, int& x2, int& y2) const;
  
  /** Gets the layout box an actor has been assigned.  The allocation can
   * only be assumed valid inside a paint() method; anywhere else, it
   * may be out-of-date.
   * 
   * An allocation does not incorporate the actor's scale or anchor point;
   * those transformations do not affect layout, only rendering.
   * 
   * The returned rectangle is in pixels.
   * 
   * Since: 0.8
   * @param geom Allocation geometry in pixels.
   */

  Geometry get_allocation_geometry() const;

  
  /** Sets the Z co-ordinate of @a self to @a depth. The Units of which are dependant
   * on the perspective setup.
   * @param depth Z co-ord.
   */
  void set_depth(int depth);
  
  /** Sets the Z co-ordinate of @a self to @a depth in Clutter::Unit&lt;!-- --&gt;s, the
   * units of which are dependant on the perspective setup.
   * @param depth Z co-ordinate, in Clutter::Unit&lt;!-- --&gt;s.
   */
  void set_depthu(Unit depth);
  
  /** Retrieves the depth of @a self.
   * @return The depth of the actor.
   */
  int get_depth() const;
  
  /** Retrieves the depth of @a self.
   * @return The depth of the actor, in Clutter::Unit&lt;!-- --&gt;s
   * 
   * Since: 0.6.
   */
  Unit get_depthu() const;
  
  /** Fixed point version of set_scale().
   * 
   * Scales an actor with the given factors. The scaling is always
   * relative to the anchor point.
   * @param scale_x Clutter::Fixed factor to scale actor by horizontally.
   * @param scale_y Clutter::Fixed factor to scale actor by vertically.
   */
  void set_scalex(Fixed scale_x, Fixed scale_y);
  
  /** Scales an actor with the given factors. The scaling is always
   * relative to the anchor point.
   * 
   * Since: 0.2
   * @param scale_x Double factor to scale actor by horizontally.
   * @param scale_y Double factor to scale actor by vertically.
   */
  void set_scale(double scale_x, double scale_y);
  
  /** Fixed point version of get_scale().
   * 
   * Retrieves the scale factors of an actor.
   * 
   * Since: 0.2
   * @param scale_x Location to store horizonal scale factor, or  <tt>0</tt>.
   * @param scale_y Location to store vertical scale factor, or <tt>0</tt>.
   */
  void get_scalex(Fixed& scale_x, Fixed& scale_y) const;
  
  /** Retrieves an actors scale in floating point.
   * 
   * Since: 0.2
   * @param scale_x Location to store horizonal float scale factor, or <tt>0</tt>.
   * @param scale_y Location to store vertical float scale factor, or <tt>0</tt>.
   */
  void get_scale(double& scale_x, double& scale_y) const;

  //_WRAP_METHOD(void get_abs_size(guint& width, guint& height) const, clutter_actor_get_abs_size)
  
  /** This function tries to "do what you mean" and return
   * the size an actor will have. If the actor has a valid
   * allocation, the allocation will be returned; otherwise,
   * the actors natural size request will be returned.
   * 
   * If you care whether you get the request vs. the allocation, you
   * should probably call a different function like
   * get_allocation_coords() or
   * get_preferred_width().
   * 
   * Since: 0.2
   * @param width Return location for the width, or <tt>0</tt>.
   * @param height Return location for the height, or <tt>0</tt>.
   */
  void get_size(guint& width, guint& height) const;
  
  /** This function tries to "do what you mean" and return
   * the size an actor will have. If the actor has a valid
   * allocation, the allocation will be returned; otherwise,
   * the actors natural size request will be returned.
   * 
   * If you care whether you get the request vs. the allocation, you
   * should probably call a different function like
   * get_allocation_coords() or
   * get_preferred_width().
   * 
   * Since: 0.6
   * @param width Return location for the width, or <tt>0</tt>.
   * @param height Return location for the height, or <tt>0</tt>.
   */
  void get_sizeu(Unit& width, Unit& height) const;
  
  /** Moves an actor by the specified distance relative to its current
   * position in pixels. This function modifies the fixed position of an
   * actor and thus removes it from any layout management. Another way
   * to move an actor is with an anchor point, see
   * set_anchor_point().
   * 
   * Since: 0.2
   * @param dx Distance to move Actor on X axis.
   * @param dy Distance to move Actor on Y axis.
   */
  void move_by(int dx, int dy);
  
  /** Moves an actor by the specified distance relative to its current
   * position.
   * 
   * The move is accomplished by setting a fixed position, overriding
   * any layout manager, see set_positionu().
   * 
   * Since: 0.6
   * @param dx Distance to move Actor on X axis, in Clutter::Unit&lt;!-- --&gt;s.
   * @param dy Distance to move Actor on Y axis, in Clutter::Unit&lt;!-- --&gt;s.
   */
  void move_byu(Unit dx, Unit dy);

  
  /** Transforms @a point in coordinates relative to the actor
   * into screen-relative coordinates with the current actor
   * transformation (i.e.\ scale, rotation, etc)
   * 
   * Since: 0.4
   * @param point A point as Clutter::Vertex.
   * @param vertex The translated Clutter::Vertex.
   */
  void apply_transform_to_point(const Vertex& point, Vertex& vertex) const;
  
  /** This function translates screen coordinates ( @a x, @a y) to
   * coordinates relative to the actor. For example, it can be used to translate
   * screen events from global screen coordinates into actor-local coordinates.
   * 
   * The conversion can fail, notably if the transform stack results in the
   * actor being projected on the screen as a mere line.
   * 
   * The conversion should not be expected to be pixel-perfect due to the
   * nature of the operation. In general the error grows when the skewing
   * of the actor rectangle on screen increases.
   * 
   * @note This function is fairly computationally intensive.
   * 
   * @note This function only works when the allocation is up-to-date, i.e. inside of paint()
   * @param x X screen coordinate of the point to unproject, in Clutter::Unit&lt;!-- --&gt;s.
   * @param y Y screen coordinate of the point to unproject, in Clutter::Unit&lt;!-- --&gt;s.
   * @param x_out Return location for the unprojected x coordinance, in
   * Clutter::Unit&lt;!-- --&gt;s.
   * @param y_out Return location for the unprojected y coordinance, in
   * Clutter::Unit&lt;!-- --&gt;s.
   * @return <tt>true</tt> if conversion was successful.
   * 
   * Since: 0.6.
   */
  void transform_stage_point(Unit x, Unit y, Unit& x_out, Unit& y_out) const;

  
  /** This function is used to emit an event on the main stage.
   * You should rarely need to use this function, except for
   * synthetising events.
   * @param event A Clutter::Event.
   * @param capture <tt>true</tt> if event in in capture phase, <tt>false</tt> otherwise.
   * @return The return value from the signal emission: <tt>true</tt>
   * if the actor handled the event, or <tt>false</tt> if the event was
   * not handled
   * 
   * Since: 0.6.
   */
  bool event(ClutterEvent* event, bool capture);
  
  /** Retrieves the Clutter::Actor with @a id.
   * @param id A Clutter::Actor ID.
   * @return The actor with the passed id or <tt>0</tt>. The returned
   * actor does not have its reference count increased.
   * 
   * Since: 0.6.
   */
  static Glib::RefPtr<Actor> get_actor_by_gid(guint32 id);

  
  /** Sets an anchor point for the @a actor. The anchor point is a point in the
   * coordinate space of an actor to which the actor position within its
   * parent is relative; the default is (0, 0), i.e. the top-left corner of
   * the actor.
   * 
   * Since: 0.6
   * @param anchor_x X coordinate of the anchor point.
   * @param anchor_y Y coordinate of the anchor point.
   */
  void set_anchor_point(int anchor_x, int anchor_y);
  
  /** Gets the current anchor point of the @a actor in pixels.
   * 
   * Since: 0.6
   * @param anchor_x Return location for the X coordinate of the anchor point.
   * @param anchor_y Return location for the y coordinate of the anchor point.
   */
  void get_anchor_point(int& anchor_x, int& anchor_y) const;
  
  /** Sets an anchor point for @a self. The anchor point is a point in the
   * coordinate space of an actor to which the actor position within its
   * parent is relative; the default is (0, 0), i.e. the top-left corner
   * of the actor.
   * 
   * Since: 0.6
   * @param anchor_x X coordinate of the anchor point, in Clutter::Unit&lt;!-- --&gt;s.
   * @param anchor_y Y coordinate of the anchor point, in Clutter::Unit&lt;!-- --&gt;s.
   */
  void set_anchor_pointu(Unit anchor_x, Unit anchor_y);
  
  /** Gets the current anchor point of the @a actor in Clutter::Unit&lt;!-- --&gt;s.
   * 
   * Since: 0.6
   * @param anchor_x Return location for the X coordinace of the anchor point.
   * @param anchor_y Return location for the X coordinace of the anchor point.
   */
  void get_anchor_pointu(Unit& anchor_x, Unit& anchor_y);
  
  /** Sets an anchor point on the actor, based on the given gravity (this is a
   * convenience function wrapping set_anchor_point()).
   * 
   * Since: 0.6
   * @param gravity Clutter::Gravity.
   */
  void set_anchor_point_from_gravity(ClutterGravity gravity);

  // These are needed by custom container implementations and therefore public.
  
  /** Renders a silhouette of the actor using the supplied color. Used
   * internally for mapping pointer events to actors.
   * 
   * This function should never be called directly by applications.
   * 
   * Subclasses overiding the ClutterActor::pick() method should call
   * should_pick_paint() to decide whether to render their
   * silhouette. Containers should always recursively call pick for
   * each child.
   * 
   * Since 0.4
   * @param color A Clutter::Color.
   */
  void pick(const Color& color);
  
  /** Utility call for subclasses overiding the pick method.
   * 
   * This function should never be called directly by applications.
   * @return <tt>true</tt> if the actor should paint its silhouette,
   * <tt>false</tt> otherwise.
   */
  bool should_pick_paint() const;

// signals
  
  /**
   * @par Prototype:
   * <tt>bool on_my_%button_press_event(ButtonEvent* event)</tt>
   */

  Glib::SignalProxy1< bool,ButtonEvent* > signal_button_press_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%button_release_event(ButtonEvent* event)</tt>
   */

  Glib::SignalProxy1< bool,ButtonEvent* > signal_button_release_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%motion_event(MotionEvent* event)</tt>
   */

  Glib::SignalProxy1< bool,MotionEvent* > signal_motion_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%leave_event(CrossingEvent* event)</tt>
   */

  Glib::SignalProxy1< bool,CrossingEvent* > signal_leave_event();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%show()</tt>
   */

  Glib::SignalProxy0< void > signal_show();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%hide()</tt>
   */

  Glib::SignalProxy0< void > signal_hide();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%destroy()</tt>
   */

  Glib::SignalProxy0< void > signal_destroy();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%key_release_event(KeyEvent* event)</tt>
   */

  Glib::SignalProxy1< bool,KeyEvent* > signal_key_release_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%enter_event(CrossingEvent* event)</tt>
   */

  Glib::SignalProxy1< bool,CrossingEvent* > signal_enter_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%event(Event* event)</tt>
   */

  Glib::SignalProxy1< bool,Event* > signal_event();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%focus_out()</tt>
   */

  Glib::SignalProxy0< void > signal_focus_out();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%focus_in()</tt>
   */

  Glib::SignalProxy0< void > signal_focus_in();

   
  /**
   * @par Prototype:
   * <tt>void on_my_%parent_set(const Glib::RefPtr<Actor>& old_parent)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Actor>& > signal_parent_set();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%scroll_event(ScrollEvent* event)</tt>
   */

  Glib::SignalProxy1< bool,ScrollEvent* > signal_scroll_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%key_press_event(KeyEvent* event)</tt>
   */

  Glib::SignalProxy1< bool,KeyEvent* > signal_key_press_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%captured_event(Event* event)</tt>
   */

  Glib::SignalProxy1< bool,Event* > signal_captured_event();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%paint()</tt>
   */

  Glib::SignalProxy0< void > signal_paint();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%realize()</tt>
   */

  Glib::SignalProxy0< void > signal_realize();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%unrealize()</tt>
   */

  Glib::SignalProxy0< void > signal_unrealize();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The actor's allocation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<ActorBox> property_allocation() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** X coordinate of the anchor point.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_anchor_x() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** X coordinate of the anchor point.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_anchor_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Y coordinate of the anchor point.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_anchor_y() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Y coordinate of the anchor point.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_anchor_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The clip region for the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Geometry> property_clip() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The clip region for the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Geometry> property_clip() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Depth of actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_depth() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Depth of actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_depth() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to use fixed positioning for the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_fixed_position_set() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to use fixed positioning for the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_fixed_position_set() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Forced X position of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Unit> property_fixed_x() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Forced X position of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Unit> property_fixed_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Forced Y position of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Unit> property_fixed_y() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Forced Y position of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Unit> property_fixed_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the actor has a clip set or not.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_has_clip() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Height of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_height() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Height of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_height() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Forced minimum height request for the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Unit> property_min_height() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Forced minimum height request for the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Unit> property_min_height() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to use the min-height property.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_min_height_set() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to use the min-height property.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_min_height_set() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Forced minimum width request for the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Unit> property_min_width() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Forced minimum width request for the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Unit> property_min_width() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to use the min-width property.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_min_width_set() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to use the min-width property.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_min_width_set() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Opacity of actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint8> property_opacity() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Opacity of actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint8> property_opacity() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the actor is reactive to events or not.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_reactive() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the actor is reactive to events or not.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_reactive() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The actor's request mode.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<RequestMode> property_request_mode() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The actor's request mode.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<RequestMode> property_request_mode() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation angle on the X axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_rotation_angle_x() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation angle on the X axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_rotation_angle_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation angle on the Y axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_rotation_angle_y() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation angle on the Y axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_rotation_angle_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation angle on the Z axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_rotation_angle_z() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation angle on the Z axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_rotation_angle_z() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation center on the X axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Vertex> property_rotation_center_x() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation center on the X axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Vertex> property_rotation_center_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation center on the Y axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Vertex> property_rotation_center_y() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation center on the Y axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Vertex> property_rotation_center_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation center on the Z axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Vertex> property_rotation_center_z() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation center on the Z axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Vertex> property_rotation_center_z() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Scale factor on the X axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_scale_x() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Scale factor on the X axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_scale_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Scale factor on the Y axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_scale_y() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Scale factor on the Y axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_scale_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the actor is shown when parented.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_on_set_parent() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the actor is shown when parented.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_on_set_parent() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the actor is visible or not.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_visible() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the actor is visible or not.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_visible() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Width of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_width() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Width of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_width() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** X coordinate of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_x() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** X coordinate of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Y coordinate of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_y() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Y coordinate of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


protected:
  
  /** Sets the value for a named parameter of the shader applied
   * to @a actor.
   * 
   * Since: 0.6
   * @param param The name of the parameter.
   * @param value The value of the parameter.
   */
  void set_shader_param_value(const Glib::ustring& param, float value);

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void show_all_vfunc();
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void hide_all_vfunc();
#endif //GLIBMM_VFUNCS_ENABLED


  // TODO: I think we need to hand-code the vfuncs if we need to handle
  // the ClutterUnit* being NULL.
   

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void pick_vfunc(const Color& color);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void get_preferred_width_vfunc(Unit for_height, Unit& min_width_p, Unit& natural_width_p) const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void get_preferred_height_vfunc(Unit for_width, Unit& min_height_p, Unit& natural_height_p) const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void allocate_vfunc(const ActorBox& box, bool absolute_origin_changed);
#endif //GLIBMM_VFUNCS_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual bool on_button_press_event(ButtonEvent* event);
  virtual bool on_button_release_event(ButtonEvent* event);
  virtual bool on_motion_event(MotionEvent* event);
  virtual bool on_leave_event(CrossingEvent* event);
  virtual void on_show();
  virtual void on_hide();
  virtual void on_destroy();
  virtual bool on_key_release_event(KeyEvent* event);
  virtual bool on_enter_event(CrossingEvent* event);
  virtual bool on_event(Event* event);
  virtual void on_focus_out();
  virtual void on_focus_in();
  virtual void on_parent_set(const Glib::RefPtr<Actor>& old_parent);
  virtual bool on_scroll_event(ScrollEvent* event);
  virtual bool on_key_press_event(KeyEvent* event);
  virtual bool on_captured_event(Event* event);
  virtual void on_paint();
  virtual void on_realize();
  virtual void on_unrealize();
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <class ParamType>
void Actor::set_shader_param(const Glib::ustring& param, const ParamType& value)
{
  Glib::Value<ParamType> param_value;
  param_value.init(Glib::Value<ParamType>::value_type());

  param_value.set(value);
  this->set_shader_param_value(param, param_value);
}
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Clutter


namespace Glib
{

/** @relates Clutter::ActorBox
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */
Clutter::ActorBox& wrap(ClutterActorBox* object);

/** @relates Clutter::ActorBox
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */
const Clutter::ActorBox& wrap(const ClutterActorBox* object);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Clutter::ActorBox> : public Glib::Value_Boxed<Clutter::ActorBox>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Actor
   */
  Glib::RefPtr<Clutter::Actor> wrap(ClutterActor* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_ACTOR_H */

