// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_SCRIPT_H
#define _CLUTTERMM_SCRIPT_H


#include <glibmm.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <cluttermm/timeline.h>
#include <clutter/clutter.h>
 

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterScript ClutterScript;
typedef struct _ClutterScriptClass ClutterScriptClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Script_Class; } // namespace Clutter
namespace Clutter
{


class Script : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Script CppObjectType;
  typedef Script_Class CppClassType;
  typedef ClutterScript BaseObjectType;
  typedef ClutterScriptClass BaseClassType;

private:  friend class Script_Class;
  static CppClassType script_class_;

private:
  // noncopyable
  Script(const Script&);
  Script& operator=(const Script&);

protected:
  explicit Script(const Glib::ConstructParams& construct_params);
  explicit Script(ClutterScript* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Script();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterScript*       gobj()       { return reinterpret_cast<ClutterScript*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterScript* gobj() const { return reinterpret_cast<ClutterScript*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterScript* gobj_copy();

private:


protected:
  Script();

public:
  
  static Glib::RefPtr<Script> create();


  // We don't support signal autoconnection in C++:
  

  /** Loads the definitions from @a data into @a script and merges with
   * the currently loaded ones, if any.
   * @param data A buffer containing the definitions.
   * @param length The length of the buffer, or -1 if @a data is a NUL-terminated
   * buffer.
   * @return On error, zero is returned and @a error is set
   * accordingly. On success, the merge id for the UI definitions is
   * returned. You can use the merge id with clutter_script_unmerge().
   * 
   * Since: 0.6.
   */

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  guint load_from_data(const Glib::ustring& data);
#else
  guint load_from_data(const Glib::ustring& data, std::auto_ptr<Glib::Error>& error);
#endif
  
  /** Loads the definitions from @a filename into @a script and merges with
   * the currently loaded ones, if any.
   * @param filename The full path to the definition file.
   * @return On error, zero is returned and @a error is set
   * accordingly. On success, the merge id for the UI definitions is
   * returned. You can use the merge id with clutter_script_unmerge().
   * 
   * Since: 0.6.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  guint load_from_file(const std::string& filename);
#else
  guint load_from_file(const std::string& filename, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Retrieves the object bound to @a name. This function does not increment
   * the reference count of the returned object.
   * @param name The name of the object to retrieve.
   * @return The named object, or <tt>0</tt> if no object with the
   * given name was available
   * 
   * Since: 0.6.
   */
  Glib::RefPtr<Glib::Object> get_object(const Glib::ustring& name);
  
  /** Retrieves the object bound to @a name. This function does not increment
   * the reference count of the returned object.
   * @param name The name of the object to retrieve.
   * @return The named object, or <tt>0</tt> if no object with the
   * given name was available
   * 
   * Since: 0.6.
   */
  Glib::RefPtr<const Glib::Object> get_object(const Glib::ustring& name) const;

  //clutter_script_get_objects() is a varargs convenience function for C.
  

  /** Unmerges the objects identified by @a merge_id.
   * 
   * Since: 0.6
   * @param merge_id Merge id returned when loading a UI definition.
   */
  void unmerge_object(guint merge_id);
  
  /** Ensure that every object defined inside @a script is correctly
   * constructed. You should rarely need to use this function.
   * 
   * Since: 0.6
   */
  void ensure_objects();

  // TODO: connect_signals functions
  // TODO: do we need get_type_from_name()?
  // clutter_script_connect_signals() and clutter_script_connect_signals_full() seem to be like glade_xml_autoconnect(), 
  // and I don't see a way to implement them in C++. murrayc.

  
  /** Retrieves the Clutter script id, if any.
   * @param gobject A Object.
   * @return The script id, or <tt>0</tt> if @a object was not defined inside
   * a UI definition file. The returned string is owned by the object and
   * should never be modified or freed.
   * 
   * Since: 0.6.
   */
  static std::string get_script_id(const Glib::RefPtr<const Glib::Object>& object);

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The path of the currently parsed file.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<std::string> property_filename() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the :filename property is set.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_filename_set() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


protected:

  
  // TODO: Make sure this is actually invoked even with disabled vfuncs so
  // that ClutterScript creates gtkmm's GObjects.
  virtual GType get_type_from_name_vfunc(const Glib::ustring& type_name);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Script
   */
  Glib::RefPtr<Clutter::Script> wrap(ClutterScript* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_SCRIPT_H */

