
#include <glib.h>

// Disable the 'const' function attribute of the get_type() functions.
// GCC would optimize them out because we don't use the return value.
#undef  G_GNUC_CONST
#define G_GNUC_CONST /* empty */

#include <cluttermm/wrap_init.h>
#include <glibmm/error.h>
#include <glibmm/object.h>

// #include the widget headers so that we can call the get_type() static methods:

#include "actor.h"
#include "actor-meta.h"
#include "action.h"
#include "alpha.h"
#include "animation.h"
#include "backend.h"
#include "behaviour.h"
#include "behaviour-depth.h"
#include "behaviour-ellipse.h"
#include "behaviour-opacity.h"
#include "behaviour-path.h"
#include "behaviour-rotate.h"
#include "behaviour-scale.h"
#include "cairo-texture.h"
#include "childmeta.h"
#include "clone.h"
#include "color.h"
#include "container.h"
#include "effect.h"
#include "group.h"
#include "interval.h"
#include "media.h"
#include "path.h"
#include "rectangle.h"
#include "score.h"
#include "script.h"
#include "scriptable.h"
#include "shader.h"
#include "stage.h"
#include "text.h"
#include "texture.h"
#include "timeline.h"
#include "types.h"

extern "C"
{

//Declarations of the *_get_type() functions:

GType clutter_action_get_type(void);
GType clutter_actor_get_type(void);
GType clutter_actor_meta_get_type(void);
GType clutter_alpha_get_type(void);
GType clutter_animation_get_type(void);
GType clutter_backend_get_type(void);
GType clutter_behaviour_get_type(void);
GType clutter_behaviour_depth_get_type(void);
GType clutter_behaviour_ellipse_get_type(void);
GType clutter_behaviour_opacity_get_type(void);
GType clutter_behaviour_path_get_type(void);
GType clutter_behaviour_rotate_get_type(void);
GType clutter_behaviour_scale_get_type(void);
GType clutter_child_meta_get_type(void);
GType clutter_clone_get_type(void);
GType clutter_effect_get_type(void);
GType clutter_group_get_type(void);
GType clutter_interval_get_type(void);
GType clutter_path_get_type(void);
GType clutter_rectangle_get_type(void);
GType clutter_score_get_type(void);
GType clutter_script_get_type(void);
GType clutter_shader_get_type(void);
GType clutter_stage_get_type(void);
GType clutter_text_get_type(void);
GType clutter_texture_get_type(void);
GType clutter_timeline_get_type(void);

//Declarations of the *_error_quark() functions:

GQuark clutter_init_error_quark(void);
GQuark clutter_texture_error_quark(void);
} // extern "C"


//Declarations of the *_Class::wrap_new() methods, instead of including all the private headers:

namespace Clutter {  class Action_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class Actor_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class ActorMeta_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class Alpha_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class Animation_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class Backend_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class Behaviour_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class BehaviourDepth_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class BehaviourEllipse_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class BehaviourOpacity_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class BehaviourPath_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class BehaviourRotate_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class BehaviourScale_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class ChildMeta_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class Clone_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class Effect_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class Group_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class Interval_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class Path_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class Rectangle_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class Score_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class Script_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class Shader_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class Stage_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class Text_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class Texture_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Clutter {  class Timeline_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }

namespace Clutter { 

void wrap_init()
{
  // Register Error domains:
  Glib::Error::register_domain(clutter_init_error_quark(), &Clutter::InitError::throw_func);
  Glib::Error::register_domain(clutter_texture_error_quark(), &Clutter::TextureError::throw_func);

// Map gtypes to gtkmm wrapper-creation functions:
  Glib::wrap_register(clutter_action_get_type(), &Clutter::Action_Class::wrap_new);
  Glib::wrap_register(clutter_actor_get_type(), &Clutter::Actor_Class::wrap_new);
  Glib::wrap_register(clutter_actor_meta_get_type(), &Clutter::ActorMeta_Class::wrap_new);
  Glib::wrap_register(clutter_alpha_get_type(), &Clutter::Alpha_Class::wrap_new);
  Glib::wrap_register(clutter_animation_get_type(), &Clutter::Animation_Class::wrap_new);
  Glib::wrap_register(clutter_backend_get_type(), &Clutter::Backend_Class::wrap_new);
  Glib::wrap_register(clutter_behaviour_get_type(), &Clutter::Behaviour_Class::wrap_new);
  Glib::wrap_register(clutter_behaviour_depth_get_type(), &Clutter::BehaviourDepth_Class::wrap_new);
  Glib::wrap_register(clutter_behaviour_ellipse_get_type(), &Clutter::BehaviourEllipse_Class::wrap_new);
  Glib::wrap_register(clutter_behaviour_opacity_get_type(), &Clutter::BehaviourOpacity_Class::wrap_new);
  Glib::wrap_register(clutter_behaviour_path_get_type(), &Clutter::BehaviourPath_Class::wrap_new);
  Glib::wrap_register(clutter_behaviour_rotate_get_type(), &Clutter::BehaviourRotate_Class::wrap_new);
  Glib::wrap_register(clutter_behaviour_scale_get_type(), &Clutter::BehaviourScale_Class::wrap_new);
  Glib::wrap_register(clutter_child_meta_get_type(), &Clutter::ChildMeta_Class::wrap_new);
  Glib::wrap_register(clutter_clone_get_type(), &Clutter::Clone_Class::wrap_new);
  Glib::wrap_register(clutter_effect_get_type(), &Clutter::Effect_Class::wrap_new);
  Glib::wrap_register(clutter_group_get_type(), &Clutter::Group_Class::wrap_new);
  Glib::wrap_register(clutter_interval_get_type(), &Clutter::Interval_Class::wrap_new);
  Glib::wrap_register(clutter_path_get_type(), &Clutter::Path_Class::wrap_new);
  Glib::wrap_register(clutter_rectangle_get_type(), &Clutter::Rectangle_Class::wrap_new);
  Glib::wrap_register(clutter_score_get_type(), &Clutter::Score_Class::wrap_new);
  Glib::wrap_register(clutter_script_get_type(), &Clutter::Script_Class::wrap_new);
  Glib::wrap_register(clutter_shader_get_type(), &Clutter::Shader_Class::wrap_new);
  Glib::wrap_register(clutter_stage_get_type(), &Clutter::Stage_Class::wrap_new);
  Glib::wrap_register(clutter_text_get_type(), &Clutter::Text_Class::wrap_new);
  Glib::wrap_register(clutter_texture_get_type(), &Clutter::Texture_Class::wrap_new);
  Glib::wrap_register(clutter_timeline_get_type(), &Clutter::Timeline_Class::wrap_new);

  // Register the gtkmm gtypes:
  Clutter::Action::get_type();
  Clutter::Actor::get_type();
  Clutter::ActorMeta::get_type();
  Clutter::Alpha::get_type();
  Clutter::Animation::get_type();
  Clutter::Backend::get_type();
  Clutter::Behaviour::get_type();
  Clutter::BehaviourDepth::get_type();
  Clutter::BehaviourEllipse::get_type();
  Clutter::BehaviourOpacity::get_type();
  Clutter::BehaviourPath::get_type();
  Clutter::BehaviourRotate::get_type();
  Clutter::BehaviourScale::get_type();
  Clutter::ChildMeta::get_type();
  Clutter::Clone::get_type();
  Clutter::Effect::get_type();
  Clutter::Group::get_type();
  Clutter::Interval::get_type();
  Clutter::Path::get_type();
  Clutter::Rectangle::get_type();
  Clutter::Score::get_type();
  Clutter::Script::get_type();
  Clutter::Shader::get_type();
  Clutter::Stage::get_type();
  Clutter::Text::get_type();
  Clutter::Texture::get_type();
  Clutter::Timeline::get_type();

} // wrap_init()

} //Clutter


