// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_INPUT_DEVICE_H
#define _CLUTTERMM_INPUT_DEVICE_H


#include <glibmm.h>

/* Copyright (C) 2011 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterInputDevice ClutterInputDevice;
typedef struct _ClutterInputDeviceClass ClutterInputDeviceClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class InputDevice_Class; } // namespace Clutter
namespace Clutter
{

/** @addtogroup cluttermmEnums cluttermm Enums and Flags */

/**
 * @ingroup cluttermmEnums
 */
enum InputDeviceType
{
  POINTER_DEVICE,
  KEYBOARD_DEVICE,
  EXTENSION_DEVICE,
  N_DEVICE_TYPES
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::InputDeviceType> : public Glib::Value_Enum<Clutter::InputDeviceType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{


class Actor;
class Stage;


class InputDevice : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef InputDevice CppObjectType;
  typedef InputDevice_Class CppClassType;
  typedef ClutterInputDevice BaseObjectType;
  typedef ClutterInputDeviceClass BaseClassType;

private:  friend class InputDevice_Class;
  static CppClassType inputdevice_class_;

private:
  // noncopyable
  InputDevice(const InputDevice&);
  InputDevice& operator=(const InputDevice&);

protected:
  explicit InputDevice(const Glib::ConstructParams& construct_params);
  explicit InputDevice(ClutterInputDevice* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~InputDevice();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterInputDevice*       gobj()       { return reinterpret_cast<ClutterInputDevice*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterInputDevice* gobj() const { return reinterpret_cast<ClutterInputDevice*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterInputDevice* gobj_copy();

private:


protected:
  InputDevice();

public:

  
  /** Retrieves the unique identifier of @a device
   * 
   * @newin{1,0}
   * @return The identifier of the device.
   */
  int get_device_id() const;
  
  /** Retrieves the type of @a device
   * 
   * @newin{1,0}
   * @return The type of the device.
   */
  InputDeviceType get_device_type() const;
  
  /** Retrieves the name of the @a device
   * 
   * @newin{1,2}
   * @return The name of the device, or <tt>0</tt>. The returned string
   * is owned by the Clutter::InputDevice and should never be modified
   * or freed.
   */
  Glib::ustring get_device_name() const;
  
  /** Retrieves the latest coordinates of the pointer of @a device
   * 
   * @newin{1,2}
   * @param x Return location for the X coordinate.
   * @param y Return location for the Y coordinate.
   */
  void get_device_coords(int &x, int &y) const;
  
  /** Retrieves the Clutter::Actor underneath the pointer of @a device
   * 
   * @newin{1,2}
   * @return A pointer to the Clutter::Actor or <tt>0</tt>.
   */
  Glib::RefPtr<Actor> get_pointer_actor();
  
  /** Retrieves the Clutter::Actor underneath the pointer of @a device
   * 
   * @newin{1,2}
   * @return A pointer to the Clutter::Actor or <tt>0</tt>.
   */
  Glib::RefPtr<const Actor> get_pointer_actor() const;
  
  /** Retrieves the Clutter::Stage underneath the pointer of @a device
   * 
   * @newin{1,2}
   * @return A pointer to the Clutter::Stage or <tt>0</tt>.
   */
  Glib::RefPtr<Stage> get_pointer_stage();
  
  /** Retrieves the Clutter::Stage underneath the pointer of @a device
   * 
   * @newin{1,2}
   * @return A pointer to the Clutter::Stage or <tt>0</tt>.
   */
  Glib::RefPtr<const Stage> get_pointer_stage() const;

  //_WRAP_METHOD(void update_from_event(const Event &event, bool update_stage), clutter_input_device_update_from_event)

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The type of the device.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<InputDeviceType> property_device_type() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Unique identifier of the device.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_id() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The name of the device.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::InputDevice
   */
  Glib::RefPtr<Clutter::InputDevice> wrap(ClutterInputDevice* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_INPUT_DEVICE_H */

