// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_ALPHA_H
#define _CLUTTERMM_ALPHA_H


#include <glibmm.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <cluttermm/timeline.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterAlpha ClutterAlpha;
typedef struct _ClutterAlphaClass ClutterAlphaClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Alpha_Class; } // namespace Clutter
namespace Clutter
{


class Alpha : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Alpha CppObjectType;
  typedef Alpha_Class CppClassType;
  typedef ClutterAlpha BaseObjectType;
  typedef ClutterAlphaClass BaseClassType;

private:  friend class Alpha_Class;
  static CppClassType alpha_class_;

private:
  // noncopyable
  Alpha(const Alpha&);
  Alpha& operator=(const Alpha&);

protected:
  explicit Alpha(const Glib::ConstructParams& construct_params);
  explicit Alpha(ClutterAlpha* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Alpha();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterAlpha*       gobj()       { return reinterpret_cast<ClutterAlpha*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterAlpha* gobj() const { return reinterpret_cast<ClutterAlpha*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterAlpha* gobj_copy();

private:

  
public:
  /** For instance,
   * double on_alpha(const Glib::RefPtr<Alpha>& alpha);
   */
  typedef sigc::slot<double, const Glib::RefPtr<Alpha>&> SlotAlphaFunc;

protected:
  Alpha();
  explicit Alpha(const Glib::RefPtr<Timeline>& timeline, gulong mode);

  /** Creates a new Alpha instance and sets the timeline and the alpha function.
   * @param timeline Timeline.
   * @param slot Alpha function.
   */
  Alpha(const Glib::RefPtr<Timeline>& timeline, const SlotAlphaFunc& slot);

public:
  enum { MAX_ALPHA = 0xFFFF };

  
  static Glib::RefPtr<Alpha> create();

  
  static Glib::RefPtr<Alpha> create(const Glib::RefPtr<Timeline>& timeline, const SlotAlphaFunc& slot);

  
  static Glib::RefPtr<Alpha> create(const Glib::RefPtr<Timeline>& timeline, gulong mode);


  /** Binds @a alpha to @a timeline.
   * 
   * @newin{0,2}
   * @param timeline A Clutter::Timeline.
   */
  void set_timeline(const Glib::RefPtr<Timeline>& timeline);
  
  /** Gets the Clutter::Timeline bound to @a alpha.
   * 
   * @newin{0,2}
   * @return A Clutter::Timeline instance.
   */
  Glib::RefPtr<Timeline> get_timeline();
  
  /** Gets the Clutter::Timeline bound to @a alpha.
   * 
   * @newin{0,2}
   * @return A Clutter::Timeline instance.
   */
  Glib::RefPtr<const Timeline> get_timeline() const;
  
  /** Query the current alpha value.
   * 
   * @newin{0,2}
   * @return The current alpha value for the alpha.
   */
  double get_alpha() const;

  
  void set_func(const SlotAlphaFunc& slot);

  //TODO: Special methods that take AnimationMode?
  
  /** Sets the progress function of @a alpha using the symbolic value
   * of @a mode, as taken by the Clutter::AnimationMode enumeration or
   * using the value returned by register_func().
   * 
   * @newin{1,0}
   * @param mode A Clutter::AnimationMode.
   */
  void set_mode(gulong mode);
  
  /** Retrieves the Clutter::AnimationMode used by @a alpha.
   * 
   * @newin{1,0}
   * @return The animation mode.
   */
  gulong get_mode() const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Alpha value.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_alpha() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Timeline used by the alpha.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Timeline> > property_timeline() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Timeline used by the alpha.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Timeline> > property_timeline() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  // We don't need the GClosure stuff in C++:
  

public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Alpha
   */
  Glib::RefPtr<Clutter::Alpha> wrap(ClutterAlpha* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_ALPHA_H */

