/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2009 Canonical Services Ltd (www.canonical.com)
 *
 * Authors: Rodrigo Moya <rodrigo.moya@canonical.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include <libsoup/soup-session-async.h>
#include "couchdb-glib.h"
#include "utils.h"

static JsonParser *
parse_json_response (SoupMessage *http_message, GError **error)
{
	SoupBuffer *buffer;
        GString *str = NULL;
        goffset offset = 0;
	JsonParser *json_parser = NULL;

	while ((buffer = soup_message_body_get_chunk (http_message->response_body, offset))) {
		if (!str)
                        str = g_string_new ("");
                g_string_append_len (str, buffer->data, buffer->length);

                offset += buffer->length;
                soup_buffer_free (buffer);
	}

	if (str && str->len > 0) {
		g_debug ("Response body: %s", str->str);
		json_parser = json_parser_new ();
		if (!json_parser_load_from_data (json_parser,
						 (const gchar *) str->str,
						 str->len,
						 error)) {
			g_object_unref (G_OBJECT (json_parser));
			json_parser = NULL;
		}

		g_string_free (str, TRUE);
	}

	return json_parser;
}

static void
set_error_from_soup (GError **error, guint status)
{
}

JsonParser *
send_message_and_parse (CouchDB *couchdb, const char *method, const char *url, const char *body, GError **error)
{
	SoupMessage *http_message;
	guint status;
	JsonParser *parser = NULL;

	http_message = soup_message_new (method, url);
	if (body != NULL) {
		soup_message_set_request (http_message, "application/json", SOUP_MEMORY_COPY,
					  body, strlen (body));
	}

	g_debug ("Sending %s to %s...", method, url);
	status = soup_session_send_message (couchdb->http_session, http_message);
	if (SOUP_STATUS_IS_SUCCESSFUL (status)) {
	       	parser = parse_json_response (http_message, error);
	} else {
		set_error_from_soup (error, status);
	}

	return parser;
}
