/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2009 Canonical Services Ltd (www.canonical.com)
 *
 * Authors: Rodrigo Moya <rodrigo.moya@canonical.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef __COUCHDB_DOCUMENT_CONTACT_H__
#define __COUCHDB_DOCUMENT_CONTACT_H__

#include <couchdb-glib.h>

#define COUCHDB_RECORD_TYPE_CONTACT "http://www.freedesktop.org/wiki/Specifications/desktopcouch/contact"

CouchDBDocument *couchdb_document_contact_new (CouchDB *couchdb);
gboolean         couchdb_document_is_contact (CouchDBDocument *document);

/*
 * Top level functions to manipulate documents representing a contact
 */

const char *couchdb_document_contact_get_first_name (CouchDBDocument *document);
void        couchdb_document_contact_set_first_name (CouchDBDocument *document, const char *first_name);
const char *couchdb_document_contact_get_last_name (CouchDBDocument *document);
void        couchdb_document_contact_set_last_name (CouchDBDocument *document, const char *last_name);
const char *couchdb_document_contact_get_nick_name (CouchDBDocument *document);
void        couchdb_document_contact_set_nick_name (CouchDBDocument *document, const char *nick_name);
const char *couchdb_document_contact_get_spouse_name (CouchDBDocument *document);
void        couchdb_document_contact_set_spouse_name (CouchDBDocument *document, const char *spouse_name);
const char *couchdb_document_contact_get_birth_date (CouchDBDocument *document);
void        couchdb_document_contact_set_birth_date (CouchDBDocument *document, const char *birth_date);
const char *couchdb_document_contact_get_wedding_date (CouchDBDocument *document);
void        couchdb_document_contact_set_wedding_date (CouchDBDocument *document, const char *wedding_date);

const char *couchdb_document_contact_get_company (CouchDBDocument *document);
void        couchdb_document_contact_set_company (CouchDBDocument *document, const char *company);
const char *couchdb_document_contact_get_department (CouchDBDocument *document);
void        couchdb_document_contact_set_department (CouchDBDocument *document, const char *department);
const char *couchdb_document_contact_get_title (CouchDBDocument *document);
void        couchdb_document_contact_set_title (CouchDBDocument *document, const char *title);
const char *couchdb_document_contact_get_job_title (CouchDBDocument *document);
void        couchdb_document_contact_set_job_title (CouchDBDocument *document, const char *job_title);
const char *couchdb_document_contact_get_manager_name (CouchDBDocument *document);
void        couchdb_document_contact_set_manager_name (CouchDBDocument *document, const char *manager_name);
const char *couchdb_document_contact_get_assistant_name (CouchDBDocument *document);
void        couchdb_document_contact_set_assistant_name (CouchDBDocument *document, const char *assistant_name);
const char *couchdb_document_contact_get_office (CouchDBDocument *document);
void        couchdb_document_contact_set_office (CouchDBDocument *document, const char *office);

GSList     *couchdb_document_contact_get_email_addresses (CouchDBDocument *document);
void        couchdb_document_contact_set_email_addresses (CouchDBDocument *document, GSList *list);

GSList     *couchdb_document_contact_get_phone_numbers (CouchDBDocument *document);
void        couchdb_document_contact_set_phone_numbers (CouchDBDocument *document, GSList *list);

GSList     *couchdb_document_contact_get_addresses (CouchDBDocument *document);
void        couchdb_document_contact_set_addresses (CouchDBDocument *document, GSList *list);

GSList     *couchdb_document_contact_get_im_addresses (CouchDBDocument *document);
void        couchdb_document_contact_set_im_addresses (CouchDBDocument *document, GSList *list);

GSList     *couchdb_document_contact_get_urls (CouchDBDocument *document);
void        couchdb_document_contact_set_urls (CouchDBDocument *document, GSList *list);

const char *couchdb_document_contact_get_notes (CouchDBDocument *document);
void        couchdb_document_contact_set_notes (CouchDBDocument *document, const char *notes);

/*
 * Utility functions to manipulate email addresses fields
 */

CouchDBStructField *couchdb_document_contact_email_new (const char *uuid, const char *address, const char *description);
const char         *couchdb_document_contact_email_get_address (CouchDBStructField *sf);
void                couchdb_document_contact_email_set_address (CouchDBStructField *sf, const char *email);

#define COUCHDB_DOCUMENT_CONTACT_EMAIL_DESCRIPTION_HOME  "home"
#define COUCHDB_DOCUMENT_CONTACT_EMAIL_DESCRIPTION_OTHER "other"
#define COUCHDB_DOCUMENT_CONTACT_EMAIL_DESCRIPTION_WORK  "work"

const char         *couchdb_document_contact_email_get_description (CouchDBStructField *sf);
void                couchdb_document_contact_email_set_description (CouchDBStructField *sf, const char *description);

/*
 * Utility functions to manipulate phone numbers
 */

CouchDBStructField *couchdb_document_contact_phone_new (const char *uuid, const char *number, const char *description, gint priority);
gint                couchdb_document_contact_phone_get_priority (CouchDBStructField *sf);
void                couchdb_document_contact_phone_set_priority (CouchDBStructField *sf, gint priority);
const char         *couchdb_document_contact_phone_get_number (CouchDBStructField *sf);
void                couchdb_document_contact_phone_set_number (CouchDBStructField *sf, const char *number);

#define COUCHDB_DOCUMENT_CONTACT_PHONE_DESCRIPTION_ASSISTANT "assistant"
#define COUCHDB_DOCUMENT_CONTACT_PHONE_DESCRIPTION_CALLBACK  "callback"
#define COUCHDB_DOCUMENT_CONTACT_PHONE_DESCRIPTION_CAR       "car"
#define COUCHDB_DOCUMENT_CONTACT_PHONE_DESCRIPTION_COMPANY   "company"
#define COUCHDB_DOCUMENT_CONTACT_PHONE_DESCRIPTION_HOME      "home"
#define COUCHDB_DOCUMENT_CONTACT_PHONE_DESCRIPTION_HOME_FAX  "home fax"
#define COUCHDB_DOCUMENT_CONTACT_PHONE_DESCRIPTION_MOBILE    "mobile"
#define COUCHDB_DOCUMENT_CONTACT_PHONE_DESCRIPTION_OTHER     "other"
#define COUCHDB_DOCUMENT_CONTACT_PHONE_DESCRIPTION_OTHER_FAX "other fax"
#define COUCHDB_DOCUMENT_CONTACT_PHONE_DESCRIPTION_PAGER     "pager"
#define COUCHDB_DOCUMENT_CONTACT_PHONE_DESCRIPTION_PRIMARY   "primary"
#define COUCHDB_DOCUMENT_CONTACT_PHONE_DESCRIPTION_RADIO     "radio"
#define COUCHDB_DOCUMENT_CONTACT_PHONE_DESCRIPTION_TELEX     "telex"
#define COUCHDB_DOCUMENT_CONTACT_PHONE_DESCRIPTION_WORK      "work"
#define COUCHDB_DOCUMENT_CONTACT_PHONE_DESCRIPTION_WORK_FAX  "work fax"

const char         *couchdb_document_contact_phone_get_description (CouchDBStructField *sf);
void                couchdb_document_contact_phone_set_description (CouchDBStructField *sf, const char *description);

/*
 * Utility functions to manipulate addresses
 */
CouchDBStructField *couchdb_document_contact_address_new (const char *uuid,
							  const char *street,
							  const char *city,
							  const char *state,
							  const char *country,
							  const char *postalcode,
							  const char *pobox,
							  const char *description);
const char         *couchdb_document_contact_address_get_street (CouchDBStructField *sf);
void                couchdb_document_contact_address_set_street (CouchDBStructField *sf, const char *street);
const char         *couchdb_document_contact_address_get_city (CouchDBStructField *sf);
void                couchdb_document_contact_address_set_city (CouchDBStructField *sf, const char *city);
const char         *couchdb_document_contact_address_get_state (CouchDBStructField *sf);
void                couchdb_document_contact_address_set_state (CouchDBStructField *sf, const char *state);
const char         *couchdb_document_contact_address_get_country (CouchDBStructField *sf);
void                couchdb_document_contact_address_set_country (CouchDBStructField *sf, const char *country);
const char         *couchdb_document_contact_address_get_postalcode (CouchDBStructField *sf);
void                couchdb_document_contact_address_set_postalcode (CouchDBStructField *sf, const char *postalcode);
const char         *couchdb_document_contact_address_get_pobox (CouchDBStructField *sf);
void                couchdb_document_contact_address_set_pobox (CouchDBStructField *sf, const char *pobox);

#define COUCHDB_DOCUMENT_CONTACT_ADDRESS_DESCRIPTION_HOME  "home"
#define COUCHDB_DOCUMENT_CONTACT_ADDRESS_DESCRIPTION_OTHER "other"
#define COUCHDB_DOCUMENT_CONTACT_ADDRESS_DESCRIPTION_WORK  "work"

const char         *couchdb_document_contact_address_get_description (CouchDBStructField *sf);
void                couchdb_document_contact_address_set_description (CouchDBStructField *sf, const char *description);

/*
 * Utility functions to manipulate IM addresses
 */
CouchDBStructField *couchdb_document_contact_im_new (const char *uuid,
						     const char *address,
						     const char *description,
						     const char *protocol);
const char         *couchdb_document_contact_im_get_address (CouchDBStructField *sf);
void                couchdb_document_contact_im_set_address (CouchDBStructField *sf, const char *address);
const char         *couchdb_document_contact_im_get_description (CouchDBStructField *sf);
void                couchdb_document_contact_im_set_description (CouchDBStructField *sf, const char *description);

#define COUCHDB_DOCUMENT_CONTACT_IM_PROTOCOL_AIM       "aim"
#define COUCHDB_DOCUMENT_CONTACT_IM_PROTOCOL_GADU_GADU "gadu-gadu"
#define COUCHDB_DOCUMENT_CONTACT_IM_PROTOCOL_GROUPWISE "groupwise"
#define COUCHDB_DOCUMENT_CONTACT_IM_PROTOCOL_ICQ       "icq"
#define COUCHDB_DOCUMENT_CONTACT_IM_PROTOCOL_IRC       "irc"
#define COUCHDB_DOCUMENT_CONTACT_IM_PROTOCOL_JABBER    "jabber"
#define COUCHDB_DOCUMENT_CONTACT_IM_PROTOCOL_MSN       "msn"
#define COUCHDB_DOCUMENT_CONTACT_IM_PROTOCOL_SKYPE     "skype"
#define COUCHDB_DOCUMENT_CONTACT_IM_PROTOCOL_YAHOO     "yahoo"

const char         *couchdb_document_contact_im_get_protocol (CouchDBStructField *sf);
void                couchdb_document_contact_im_set_protocol (CouchDBStructField *sf, const char *protocol);

/*
 * Utility functions to manipulate URLs
 */
CouchDBStructField *couchdb_document_contact_url_new (const char *uuid, const char *address, const char *description);
const char         *couchdb_document_contact_url_get_address  (CouchDBStructField *sf);
void                couchdb_document_contact_url_set_address (CouchDBStructField *sf, const char *address);

#define COUCHDB_DOCUMENT_CONTACT_URL_DESCRIPTION_BLOG     "blog"
#define COUCHDB_DOCUMENT_CONTACT_URL_DESCRIPTION_HOMEPAGE "home page"

const char         *couchdb_document_contact_url_get_description (CouchDBStructField *sf);
void                couchdb_document_contact_url_set_description (CouchDBStructField *sf, const char *description);
#endif
