/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2009 Canonical Services Ltd (www.canonical.com)
 *
 * Authors: Rodrigo Moya <rodrigo.moya@canonical.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef __COUCHDB_TYPES_H__
#define __COUCHDB_TYPES_H__

#include <glib-object.h>

#define COUCHDB_TYPE_DATABASE_INFO (couchdb_database_info_get_type ())
#define COUCHDB_TYPE_DOCUMENT_INFO (couchdb_document_info_get_type ())
#define COUCHDB_TYPE_STRUCT_FIELD  (couchdb_struct_field_get_type ())

/*
 * CouchDBDatabaseInfo
 */
typedef struct _CouchDBDatabaseInfo CouchDBDatabaseInfo;

GType                couchdb_database_info_get_type (void);
CouchDBDatabaseInfo *couchdb_database_info_ref (CouchDBDatabaseInfo *dbinfo);
void                 couchdb_database_info_unref (CouchDBDatabaseInfo *dbinfo);

const char          *couchdb_database_info_get_dbname (CouchDBDatabaseInfo *dbinfo);
gint                 couchdb_database_info_get_documents_count (CouchDBDatabaseInfo *dbinfo);
gint                 couchdb_database_info_get_deleted_documents_count (CouchDBDatabaseInfo *dbinfo);
gint                 couchdb_database_info_get_update_sequence (CouchDBDatabaseInfo *dbinfo);
gboolean             couchdb_database_info_is_compact_running (CouchDBDatabaseInfo *dbinfo);
gint                 couchdb_database_info_get_disk_size (CouchDBDatabaseInfo *dbinfo);

/*
 * CouchDBDocumentInfo
 */
typedef struct _CouchDBDocumentInfo CouchDBDocumentInfo;

GType                couchdb_document_info_get_type (void);
CouchDBDocumentInfo *couchdb_document_info_ref (CouchDBDocumentInfo *doc_info);
void                 couchdb_document_info_unref (CouchDBDocumentInfo *doc_info);

const char          *couchdb_document_info_get_docid (CouchDBDocumentInfo *doc_info);
const char          *couchdb_document_info_get_revision (CouchDBDocumentInfo *doc_info);

/*
 * CouchDBStructField
 */
typedef struct _CouchDBStructField CouchDBStructField;

GType               couchdb_struct_field_get_type (void);
CouchDBStructField *couchdb_struct_field_new (void);
CouchDBStructField *couchdb_struct_field_new_from_string (const char *str);
CouchDBStructField *couchdb_struct_field_ref (CouchDBStructField *sf);
void                couchdb_struct_field_unref (CouchDBStructField *sf);

gboolean            couchdb_struct_field_has_field (CouchDBStructField *sf, const char *field);
void                couchdb_struct_field_remove_field (CouchDBStructField *sf, const char *field);

gboolean            couchdb_struct_field_get_boolean_field (CouchDBStructField *sf, const char *field);
void                couchdb_struct_field_set_boolean_field (CouchDBStructField *sf, const char *field, gboolean value);
gdouble             couchdb_struct_field_get_double_field (CouchDBStructField *sf, const char *field);
void                couchdb_struct_field_set_double_field (CouchDBStructField *sf, const char *field, gdouble value);
gint                couchdb_struct_field_get_int_field (CouchDBStructField *sf, const char *field);
void                couchdb_struct_field_set_int_field (CouchDBStructField *sf, const char *field, gint value);
const char         *couchdb_struct_field_get_string_field (CouchDBStructField *sf, const char *field);
void                couchdb_struct_field_set_string_field (CouchDBStructField *sf, const char *field, const char *value);
CouchDBStructField *couchdb_struct_field_get_struct_field (CouchDBStructField *sf, const char *field);
void                couchdb_struct_field_set_struct_field (CouchDBStructField *sf, const char *field, CouchDBStructField *value);

const char         *couchdb_struct_field_get_uuid (CouchDBStructField *sf);
void                couchdb_struct_field_set_uuid (CouchDBStructField *sf, const char *uuid);

char               *couchdb_struct_field_to_string (CouchDBStructField *sf);

#endif
