/*
   Copyright (C) 2010 Bastien Nocera

   The Gnome Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The Gnome Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the Gnome Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301  USA.

   Authors: Bastien Nocera <hadess@hadess.net>

 */

#ifndef DISCIDENT_GLIB_PRIVATE_H
#define DISCIDENT_GLIB_PRIVATE_H

#include <glib.h>

#define QUERY_GTIN "http://discident.com/v1/%s/"

G_BEGIN_DECLS

char *generate_hash (const char *str, gssize len);
char *discident_get_title_for_gtin (const char *gtin,
				    GError    **error);

#endif /* DISCIDENT_GLIB_PRIVATE_H */
