/* ease-cairo-actor.c generated by valac, the Vala compiler
 * generated from ease-cairo-actor.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <cairo.h>


#define EASE_TYPE_ACTOR (ease_actor_get_type ())
#define EASE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ACTOR, EaseActor))
#define EASE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ACTOR, EaseActorClass))
#define EASE_IS_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ACTOR))
#define EASE_IS_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ACTOR))
#define EASE_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ACTOR, EaseActorClass))

typedef struct _EaseActor EaseActor;
typedef struct _EaseActorClass EaseActorClass;
typedef struct _EaseActorPrivate EaseActorPrivate;

#define EASE_TYPE_ELEMENT (ease_element_get_type ())
#define EASE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ELEMENT, EaseElement))
#define EASE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ELEMENT, EaseElementClass))
#define EASE_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ELEMENT))
#define EASE_IS_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ELEMENT))
#define EASE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ELEMENT, EaseElementClass))

typedef struct _EaseElement EaseElement;
typedef struct _EaseElementClass EaseElementClass;

#define EASE_TYPE_ACTOR_CONTEXT (ease_actor_context_get_type ())

#define EASE_TYPE_CAIRO_ACTOR (ease_cairo_actor_get_type ())
#define EASE_CAIRO_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_CAIRO_ACTOR, EaseCairoActor))
#define EASE_CAIRO_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_CAIRO_ACTOR, EaseCairoActorClass))
#define EASE_IS_CAIRO_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_CAIRO_ACTOR))
#define EASE_IS_CAIRO_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_CAIRO_ACTOR))
#define EASE_CAIRO_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_CAIRO_ACTOR, EaseCairoActorClass))

typedef struct _EaseCairoActor EaseCairoActor;
typedef struct _EaseCairoActorClass EaseCairoActorClass;
typedef struct _EaseCairoActorPrivate EaseCairoActorPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

typedef enum  {
	EASE_ACTOR_CONTEXT_PRESENTATION,
	EASE_ACTOR_CONTEXT_EDITOR,
	EASE_ACTOR_CONTEXT_INSPECTOR
} EaseActorContext;

struct _EaseActor {
	ClutterGroup parent_instance;
	EaseActorPrivate * priv;
	ClutterActor* contents;
	EaseElement* element;
	EaseActorContext context;
	gboolean is_background;
};

struct _EaseActorClass {
	ClutterGroupClass parent_class;
	void (*edit) (EaseActor* self, GtkWidget* sender);
	void (*end_edit) (EaseActor* self, GtkWidget* sender);
};

struct _EaseCairoActor {
	EaseActor parent_instance;
	EaseCairoActorPrivate * priv;
};

struct _EaseCairoActorClass {
	EaseActorClass parent_class;
};

struct _EaseCairoActorPrivate {
	ClutterCairoTexture* tex;
};


static gpointer ease_cairo_actor_parent_class = NULL;

GType ease_actor_get_type (void) G_GNUC_CONST;
GType ease_element_get_type (void) G_GNUC_CONST;
GType ease_actor_context_get_type (void) G_GNUC_CONST;
GType ease_cairo_actor_get_type (void) G_GNUC_CONST;
#define EASE_CAIRO_ACTOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_CAIRO_ACTOR, EaseCairoActorPrivate))
enum  {
	EASE_CAIRO_ACTOR_DUMMY_PROPERTY
};
EaseActor* ease_actor_construct (GType object_type, EaseElement* e, EaseActorContext c);
float ease_element_get_width (EaseElement* self);
float ease_element_get_height (EaseElement* self);
float ease_element_get_x (EaseElement* self);
float ease_element_get_y (EaseElement* self);
void ease_cairo_actor_draw (EaseCairoActor* self);
static void _ease_cairo_actor_draw_ease_element_changed (EaseElement* _sender, gpointer self);
EaseCairoActor* ease_cairo_actor_new (EaseElement* e, EaseActorContext ctx);
EaseCairoActor* ease_cairo_actor_construct (GType object_type, EaseElement* e, EaseActorContext ctx);
void ease_element_cairo_render (EaseElement* self, cairo_t* context, GError** error);
static void ease_cairo_actor_finalize (GObject* obj);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 41 "ease-cairo-actor.vala"
static void _ease_cairo_actor_draw_ease_element_changed (EaseElement* _sender, gpointer self) {
#line 134 "ease-cairo-actor.c"
	ease_cairo_actor_draw (self);
}


#line 25 "ease-cairo-actor.vala"
EaseCairoActor* ease_cairo_actor_construct (GType object_type, EaseElement* e, EaseActorContext ctx) {
#line 141 "ease-cairo-actor.c"
	EaseCairoActor * self;
	ClutterCairoTexture* _tmp0_;
	ClutterActor* _tmp1_;
#line 25 "ease-cairo-actor.vala"
	g_return_val_if_fail (e != NULL, NULL);
#line 27 "ease-cairo-actor.vala"
	self = (EaseCairoActor*) ease_actor_construct (object_type, e, ctx);
#line 29 "ease-cairo-actor.vala"
	self->priv->tex = (_tmp0_ = g_object_ref_sink ((ClutterCairoTexture*) clutter_cairo_texture_new ((guint) ease_element_get_width (e), (guint) ease_element_get_height (e))), _g_object_unref0 (self->priv->tex), _tmp0_);
#line 30 "ease-cairo-actor.vala"
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) self->priv->tex);
#line 31 "ease-cairo-actor.vala"
	((EaseActor*) self)->contents = (_tmp1_ = _g_object_ref0 ((ClutterActor*) self->priv->tex), _g_object_unref0 (((EaseActor*) self)->contents), _tmp1_);
#line 32 "ease-cairo-actor.vala"
	clutter_actor_set_width (((EaseActor*) self)->contents, ease_element_get_width (e));
#line 33 "ease-cairo-actor.vala"
	clutter_actor_set_height (((EaseActor*) self)->contents, ease_element_get_height (e));
#line 34 "ease-cairo-actor.vala"
	clutter_actor_set_x ((ClutterActor*) self, ease_element_get_x (e));
#line 35 "ease-cairo-actor.vala"
	clutter_actor_set_y ((ClutterActor*) self, ease_element_get_y (e));
#line 36 "ease-cairo-actor.vala"
	g_signal_connect_object (e, "changed", (GCallback) _ease_cairo_actor_draw_ease_element_changed, self, 0);
#line 38 "ease-cairo-actor.vala"
	ease_cairo_actor_draw (self);
#line 167 "ease-cairo-actor.c"
	return self;
}


#line 25 "ease-cairo-actor.vala"
EaseCairoActor* ease_cairo_actor_new (EaseElement* e, EaseActorContext ctx) {
#line 25 "ease-cairo-actor.vala"
	return ease_cairo_actor_construct (EASE_TYPE_CAIRO_ACTOR, e, ctx);
#line 176 "ease-cairo-actor.c"
}


#line 41 "ease-cairo-actor.vala"
void ease_cairo_actor_draw (EaseCairoActor* self) {
#line 182 "ease-cairo-actor.c"
	GError * _inner_error_;
	cairo_t* cr;
#line 41 "ease-cairo-actor.vala"
	g_return_if_fail (self != NULL);
#line 187 "ease-cairo-actor.c"
	_inner_error_ = NULL;
#line 44 "ease-cairo-actor.vala"
	clutter_cairo_texture_set_surface_size (self->priv->tex, (guint) ease_element_get_width (((EaseActor*) self)->element), (guint) ease_element_get_height (((EaseActor*) self)->element));
#line 45 "ease-cairo-actor.vala"
	clutter_cairo_texture_clear (self->priv->tex);
#line 46 "ease-cairo-actor.vala"
	cr = clutter_cairo_texture_create (self->priv->tex);
#line 195 "ease-cairo-actor.c"
	{
#line 49 "ease-cairo-actor.vala"
		ease_element_cairo_render (((EaseActor*) self)->element, cr, &_inner_error_);
#line 199 "ease-cairo-actor.c"
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 53 "ease-cairo-actor.vala"
			g_critical ("ease-cairo-actor.vala:53: Error rendering CairoActor: %s", e->message);
#line 213 "ease-cairo-actor.c"
			_g_error_free0 (e);
		}
	}
	__finally6:
	if (_inner_error_ != NULL) {
		_cairo_destroy0 (cr);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_cairo_destroy0 (cr);
}


static void ease_cairo_actor_class_init (EaseCairoActorClass * klass) {
	ease_cairo_actor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseCairoActorPrivate));
	G_OBJECT_CLASS (klass)->finalize = ease_cairo_actor_finalize;
}


static void ease_cairo_actor_instance_init (EaseCairoActor * self) {
	self->priv = EASE_CAIRO_ACTOR_GET_PRIVATE (self);
}


static void ease_cairo_actor_finalize (GObject* obj) {
	EaseCairoActor * self;
	self = EASE_CAIRO_ACTOR (obj);
	_g_object_unref0 (self->priv->tex);
	G_OBJECT_CLASS (ease_cairo_actor_parent_class)->finalize (obj);
}


GType ease_cairo_actor_get_type (void) {
	static volatile gsize ease_cairo_actor_type_id__volatile = 0;
	if (g_once_init_enter (&ease_cairo_actor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseCairoActorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_cairo_actor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseCairoActor), 0, (GInstanceInitFunc) ease_cairo_actor_instance_init, NULL };
		GType ease_cairo_actor_type_id;
		ease_cairo_actor_type_id = g_type_register_static (EASE_TYPE_ACTOR, "EaseCairoActor", &g_define_type_info, 0);
		g_once_init_leave (&ease_cairo_actor_type_id__volatile, ease_cairo_actor_type_id);
	}
	return ease_cairo_actor_type_id__volatile;
}




