/* ease-core.h generated by valac, the Vala compiler, do not modify */


#ifndef __EASE_CORE_H__
#define __EASE_CORE_H__

#include <glib.h>
#include <clutter/clutter.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <json-glib/json-glib.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gee.h>
#include <pango/pango.h>

G_BEGIN_DECLS


#define EASE_TYPE_ACTOR (ease_actor_get_type ())
#define EASE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ACTOR, EaseActor))
#define EASE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ACTOR, EaseActorClass))
#define EASE_IS_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ACTOR))
#define EASE_IS_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ACTOR))
#define EASE_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ACTOR, EaseActorClass))

typedef struct _EaseActor EaseActor;
typedef struct _EaseActorClass EaseActorClass;
typedef struct _EaseActorPrivate EaseActorPrivate;

#define EASE_TYPE_ELEMENT (ease_element_get_type ())
#define EASE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ELEMENT, EaseElement))
#define EASE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ELEMENT, EaseElementClass))
#define EASE_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ELEMENT))
#define EASE_IS_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ELEMENT))
#define EASE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ELEMENT, EaseElementClass))

typedef struct _EaseElement EaseElement;
typedef struct _EaseElementClass EaseElementClass;

#define EASE_TYPE_ACTOR_CONTEXT (ease_actor_context_get_type ())

#define EASE_TYPE_ZOOM_SLIDER (ease_zoom_slider_get_type ())
#define EASE_ZOOM_SLIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ZOOM_SLIDER, EaseZoomSlider))
#define EASE_ZOOM_SLIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ZOOM_SLIDER, EaseZoomSliderClass))
#define EASE_IS_ZOOM_SLIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ZOOM_SLIDER))
#define EASE_IS_ZOOM_SLIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ZOOM_SLIDER))
#define EASE_ZOOM_SLIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ZOOM_SLIDER, EaseZoomSliderClass))

typedef struct _EaseZoomSlider EaseZoomSlider;
typedef struct _EaseZoomSliderClass EaseZoomSliderClass;
typedef struct _EaseZoomSliderPrivate EaseZoomSliderPrivate;

#define EASE_TYPE_ANIMATED_ZOOM_SLIDER (ease_animated_zoom_slider_get_type ())
#define EASE_ANIMATED_ZOOM_SLIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ANIMATED_ZOOM_SLIDER, EaseAnimatedZoomSlider))
#define EASE_ANIMATED_ZOOM_SLIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ANIMATED_ZOOM_SLIDER, EaseAnimatedZoomSliderClass))
#define EASE_IS_ANIMATED_ZOOM_SLIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ANIMATED_ZOOM_SLIDER))
#define EASE_IS_ANIMATED_ZOOM_SLIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ANIMATED_ZOOM_SLIDER))
#define EASE_ANIMATED_ZOOM_SLIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ANIMATED_ZOOM_SLIDER, EaseAnimatedZoomSliderClass))

typedef struct _EaseAnimatedZoomSlider EaseAnimatedZoomSlider;
typedef struct _EaseAnimatedZoomSliderClass EaseAnimatedZoomSliderClass;
typedef struct _EaseAnimatedZoomSliderPrivate EaseAnimatedZoomSliderPrivate;

#define EASE_TYPE_BACKGROUND (ease_background_get_type ())
#define EASE_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_BACKGROUND, EaseBackground))
#define EASE_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_BACKGROUND, EaseBackgroundClass))
#define EASE_IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_BACKGROUND))
#define EASE_IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_BACKGROUND))
#define EASE_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_BACKGROUND, EaseBackgroundClass))

typedef struct _EaseBackground EaseBackground;
typedef struct _EaseBackgroundClass EaseBackgroundClass;
typedef struct _EaseBackgroundPrivate EaseBackgroundPrivate;

#define EASE_TYPE_BACKGROUND_TYPE (ease_background_type_get_type ())

#define EASE_TYPE_BACKGROUND_WIDGET (ease_background_widget_get_type ())
#define EASE_BACKGROUND_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_BACKGROUND_WIDGET, EaseBackgroundWidget))
#define EASE_BACKGROUND_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_BACKGROUND_WIDGET, EaseBackgroundWidgetClass))
#define EASE_IS_BACKGROUND_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_BACKGROUND_WIDGET))
#define EASE_IS_BACKGROUND_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_BACKGROUND_WIDGET))
#define EASE_BACKGROUND_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_BACKGROUND_WIDGET, EaseBackgroundWidgetClass))

typedef struct _EaseBackgroundWidget EaseBackgroundWidget;
typedef struct _EaseBackgroundWidgetClass EaseBackgroundWidgetClass;
typedef struct _EaseBackgroundWidgetPrivate EaseBackgroundWidgetPrivate;

#define EASE_TYPE_SLIDE (ease_slide_get_type ())
#define EASE_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SLIDE, EaseSlide))
#define EASE_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SLIDE, EaseSlideClass))
#define EASE_IS_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SLIDE))
#define EASE_IS_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SLIDE))
#define EASE_SLIDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SLIDE, EaseSlideClass))

typedef struct _EaseSlide EaseSlide;
typedef struct _EaseSlideClass EaseSlideClass;

#define EASE_TYPE_CAIRO_ACTOR (ease_cairo_actor_get_type ())
#define EASE_CAIRO_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_CAIRO_ACTOR, EaseCairoActor))
#define EASE_CAIRO_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_CAIRO_ACTOR, EaseCairoActorClass))
#define EASE_IS_CAIRO_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_CAIRO_ACTOR))
#define EASE_IS_CAIRO_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_CAIRO_ACTOR))
#define EASE_CAIRO_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_CAIRO_ACTOR, EaseCairoActorClass))

typedef struct _EaseCairoActor EaseCairoActor;
typedef struct _EaseCairoActorClass EaseCairoActorClass;
typedef struct _EaseCairoActorPrivate EaseCairoActorPrivate;

#define EASE_TYPE_UNDO_SOURCE (ease_undo_source_get_type ())
#define EASE_UNDO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_SOURCE, EaseUndoSource))
#define EASE_IS_UNDO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_SOURCE))
#define EASE_UNDO_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), EASE_TYPE_UNDO_SOURCE, EaseUndoSourceIface))

typedef struct _EaseUndoSource EaseUndoSource;
typedef struct _EaseUndoSourceIface EaseUndoSourceIface;
typedef struct _EaseElementPrivate EaseElementPrivate;

#define EASE_TYPE_HTML_EXPORTER (ease_html_exporter_get_type ())
#define EASE_HTML_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporter))
#define EASE_HTML_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporterClass))
#define EASE_IS_HTML_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_HTML_EXPORTER))
#define EASE_IS_HTML_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_HTML_EXPORTER))
#define EASE_HTML_EXPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporterClass))

typedef struct _EaseHTMLExporter EaseHTMLExporter;
typedef struct _EaseHTMLExporterClass EaseHTMLExporterClass;

#define EASE_TYPE_CAIRO_ELEMENT (ease_cairo_element_get_type ())
#define EASE_CAIRO_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_CAIRO_ELEMENT, EaseCairoElement))
#define EASE_CAIRO_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_CAIRO_ELEMENT, EaseCairoElementClass))
#define EASE_IS_CAIRO_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_CAIRO_ELEMENT))
#define EASE_IS_CAIRO_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_CAIRO_ELEMENT))
#define EASE_CAIRO_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_CAIRO_ELEMENT, EaseCairoElementClass))

typedef struct _EaseCairoElement EaseCairoElement;
typedef struct _EaseCairoElementClass EaseCairoElementClass;
typedef struct _EaseCairoElementPrivate EaseCairoElementPrivate;

#define EASE_TYPE_COLOR (ease_color_get_type ())
#define EASE_COLOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_COLOR, EaseColor))
#define EASE_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_COLOR, EaseColorClass))
#define EASE_IS_COLOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_COLOR))
#define EASE_IS_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_COLOR))
#define EASE_COLOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_COLOR, EaseColorClass))

typedef struct _EaseColor EaseColor;
typedef struct _EaseColorClass EaseColorClass;
typedef struct _EaseColorPrivate EaseColorPrivate;

#define EASE_TYPE_UNDO_ITEM (ease_undo_item_get_type ())
#define EASE_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_ITEM, EaseUndoItem))
#define EASE_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_UNDO_ITEM, EaseUndoItemClass))
#define EASE_IS_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_ITEM))
#define EASE_IS_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_UNDO_ITEM))
#define EASE_UNDO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_UNDO_ITEM, EaseUndoItemClass))

typedef struct _EaseUndoItem EaseUndoItem;
typedef struct _EaseUndoItemClass EaseUndoItemClass;

#define EASE_TYPE_UNDO_ACTION (ease_undo_action_get_type ())
#define EASE_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_ACTION, EaseUndoAction))
#define EASE_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_UNDO_ACTION, EaseUndoActionClass))
#define EASE_IS_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_ACTION))
#define EASE_IS_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_UNDO_ACTION))
#define EASE_UNDO_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_UNDO_ACTION, EaseUndoActionClass))

typedef struct _EaseUndoAction EaseUndoAction;
typedef struct _EaseUndoActionClass EaseUndoActionClass;

#define EASE_DIALOG_TYPE_PROGRESS (ease_dialog_progress_get_type ())
#define EASE_DIALOG_PROGRESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_DIALOG_TYPE_PROGRESS, EaseDialogProgress))
#define EASE_DIALOG_PROGRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_DIALOG_TYPE_PROGRESS, EaseDialogProgressClass))
#define EASE_DIALOG_IS_PROGRESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_DIALOG_TYPE_PROGRESS))
#define EASE_DIALOG_IS_PROGRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_DIALOG_TYPE_PROGRESS))
#define EASE_DIALOG_PROGRESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_DIALOG_TYPE_PROGRESS, EaseDialogProgressClass))

typedef struct _EaseDialogProgress EaseDialogProgress;
typedef struct _EaseDialogProgressClass EaseDialogProgressClass;
typedef struct _EaseDialogProgressPrivate EaseDialogProgressPrivate;

#define EASE_TYPE_DOCUMENT (ease_document_get_type ())
#define EASE_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_DOCUMENT, EaseDocument))
#define EASE_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_DOCUMENT, EaseDocumentClass))
#define EASE_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_DOCUMENT))
#define EASE_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_DOCUMENT))
#define EASE_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_DOCUMENT, EaseDocumentClass))

typedef struct _EaseDocument EaseDocument;
typedef struct _EaseDocumentClass EaseDocumentClass;
typedef struct _EaseDocumentPrivate EaseDocumentPrivate;

#define EASE_TYPE_ITERABLE_LIST_STORE (ease_iterable_list_store_get_type ())
#define EASE_ITERABLE_LIST_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ITERABLE_LIST_STORE, EaseIterableListStore))
#define EASE_ITERABLE_LIST_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ITERABLE_LIST_STORE, EaseIterableListStoreClass))
#define EASE_IS_ITERABLE_LIST_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ITERABLE_LIST_STORE))
#define EASE_IS_ITERABLE_LIST_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ITERABLE_LIST_STORE))
#define EASE_ITERABLE_LIST_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ITERABLE_LIST_STORE, EaseIterableListStoreClass))

typedef struct _EaseIterableListStore EaseIterableListStore;
typedef struct _EaseIterableListStoreClass EaseIterableListStoreClass;

#define EASE_TYPE_THEME (ease_theme_get_type ())
#define EASE_THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_THEME, EaseTheme))
#define EASE_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_THEME, EaseThemeClass))
#define EASE_IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_THEME))
#define EASE_IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_THEME))
#define EASE_THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_THEME, EaseThemeClass))

typedef struct _EaseTheme EaseTheme;
typedef struct _EaseThemeClass EaseThemeClass;

#define EASE_TYPE_HANDLE_POSITION (ease_handle_position_get_type ())

#define EASE_TYPE_KEY (ease_key_get_type ())

#define EASE_TYPE_GRADIENT (ease_gradient_get_type ())
#define EASE_GRADIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_GRADIENT, EaseGradient))
#define EASE_GRADIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_GRADIENT, EaseGradientClass))
#define EASE_IS_GRADIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_GRADIENT))
#define EASE_IS_GRADIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_GRADIENT))
#define EASE_GRADIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_GRADIENT, EaseGradientClass))

typedef struct _EaseGradient EaseGradient;
typedef struct _EaseGradientClass EaseGradientClass;
typedef struct _EaseGradientPrivate EaseGradientPrivate;

#define EASE_TYPE_GRADIENT_TYPE (ease_gradient_type_get_type ())
typedef struct _EaseHTMLExporterPrivate EaseHTMLExporterPrivate;

#define EASE_TYPE_IMAGE_ACTOR (ease_image_actor_get_type ())
#define EASE_IMAGE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_IMAGE_ACTOR, EaseImageActor))
#define EASE_IMAGE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_IMAGE_ACTOR, EaseImageActorClass))
#define EASE_IS_IMAGE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_IMAGE_ACTOR))
#define EASE_IS_IMAGE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_IMAGE_ACTOR))
#define EASE_IMAGE_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_IMAGE_ACTOR, EaseImageActorClass))

typedef struct _EaseImageActor EaseImageActor;
typedef struct _EaseImageActorClass EaseImageActorClass;
typedef struct _EaseImageActorPrivate EaseImageActorPrivate;

#define EASE_TYPE_MEDIA_ELEMENT (ease_media_element_get_type ())
#define EASE_MEDIA_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_MEDIA_ELEMENT, EaseMediaElement))
#define EASE_MEDIA_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_MEDIA_ELEMENT, EaseMediaElementClass))
#define EASE_IS_MEDIA_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_MEDIA_ELEMENT))
#define EASE_IS_MEDIA_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_MEDIA_ELEMENT))
#define EASE_MEDIA_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_MEDIA_ELEMENT, EaseMediaElementClass))

typedef struct _EaseMediaElement EaseMediaElement;
typedef struct _EaseMediaElementClass EaseMediaElementClass;

#define EASE_TYPE_IMAGE_ELEMENT (ease_image_element_get_type ())
#define EASE_IMAGE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_IMAGE_ELEMENT, EaseImageElement))
#define EASE_IMAGE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_IMAGE_ELEMENT, EaseImageElementClass))
#define EASE_IS_IMAGE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_IMAGE_ELEMENT))
#define EASE_IS_IMAGE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_IMAGE_ELEMENT))
#define EASE_IMAGE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_IMAGE_ELEMENT, EaseImageElementClass))

typedef struct _EaseImageElement EaseImageElement;
typedef struct _EaseImageElementClass EaseImageElementClass;
typedef struct _EaseMediaElementPrivate EaseMediaElementPrivate;
typedef struct _EaseImageElementPrivate EaseImageElementPrivate;

#define EASE_TYPE_IMAGE (ease_image_get_type ())
#define EASE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_IMAGE, EaseImage))
#define EASE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_IMAGE, EaseImageClass))
#define EASE_IS_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_IMAGE))
#define EASE_IS_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_IMAGE))
#define EASE_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_IMAGE, EaseImageClass))

typedef struct _EaseImage EaseImage;
typedef struct _EaseImageClass EaseImageClass;
typedef struct _EaseImagePrivate EaseImagePrivate;

#define EASE_TYPE_ITERABLE_TREE_MODEL (ease_iterable_tree_model_get_type ())
#define EASE_ITERABLE_TREE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ITERABLE_TREE_MODEL, EaseIterableTreeModel))
#define EASE_IS_ITERABLE_TREE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ITERABLE_TREE_MODEL))
#define EASE_ITERABLE_TREE_MODEL_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), EASE_TYPE_ITERABLE_TREE_MODEL, EaseIterableTreeModelIface))

typedef struct _EaseIterableTreeModel EaseIterableTreeModel;
typedef struct _EaseIterableTreeModelIface EaseIterableTreeModelIface;

#define EASE_ITERABLE_TREE_MODEL_TYPE_ITERATOR (ease_iterable_tree_model_iterator_get_type ())
#define EASE_ITERABLE_TREE_MODEL_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_ITERABLE_TREE_MODEL_TYPE_ITERATOR, EaseIterableTreeModelIterator))
#define EASE_ITERABLE_TREE_MODEL_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_ITERABLE_TREE_MODEL_TYPE_ITERATOR, EaseIterableTreeModelIteratorClass))
#define EASE_ITERABLE_TREE_MODEL_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_ITERABLE_TREE_MODEL_TYPE_ITERATOR))
#define EASE_ITERABLE_TREE_MODEL_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_ITERABLE_TREE_MODEL_TYPE_ITERATOR))
#define EASE_ITERABLE_TREE_MODEL_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_ITERABLE_TREE_MODEL_TYPE_ITERATOR, EaseIterableTreeModelIteratorClass))

typedef struct _EaseIterableTreeModelIterator EaseIterableTreeModelIterator;
typedef struct _EaseIterableTreeModelIteratorClass EaseIterableTreeModelIteratorClass;
typedef struct _EaseIterableTreeModelIteratorPrivate EaseIterableTreeModelIteratorPrivate;
typedef struct _EaseIterableListStorePrivate EaseIterableListStorePrivate;

#define EASE_TYPE_SHAPE_ELEMENT (ease_shape_element_get_type ())
#define EASE_SHAPE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SHAPE_ELEMENT, EaseShapeElement))
#define EASE_SHAPE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SHAPE_ELEMENT, EaseShapeElementClass))
#define EASE_IS_SHAPE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SHAPE_ELEMENT))
#define EASE_IS_SHAPE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SHAPE_ELEMENT))
#define EASE_SHAPE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SHAPE_ELEMENT, EaseShapeElementClass))

typedef struct _EaseShapeElement EaseShapeElement;
typedef struct _EaseShapeElementClass EaseShapeElementClass;
typedef struct _EaseShapeElementPrivate EaseShapeElementPrivate;

#define EASE_TYPE_SHAPE_TYPE (ease_shape_type_get_type ())
typedef struct _EaseSlidePrivate EaseSlidePrivate;

#define EASE_SLIDE_TYPE_ITERATOR (ease_slide_iterator_get_type ())
#define EASE_SLIDE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_SLIDE_TYPE_ITERATOR, EaseSlideIterator))
#define EASE_SLIDE_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_SLIDE_TYPE_ITERATOR, EaseSlideIteratorClass))
#define EASE_SLIDE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_SLIDE_TYPE_ITERATOR))
#define EASE_SLIDE_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_SLIDE_TYPE_ITERATOR))
#define EASE_SLIDE_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_SLIDE_TYPE_ITERATOR, EaseSlideIteratorClass))

typedef struct _EaseSlideIterator EaseSlideIterator;
typedef struct _EaseSlideIteratorClass EaseSlideIteratorClass;

#define EASE_TYPE_TRANSITION (ease_transition_get_type ())

#define EASE_TYPE_TRANSITION_VARIANT (ease_transition_variant_get_type ())
typedef struct _EaseSlideIteratorPrivate EaseSlideIteratorPrivate;

#define EASE_TYPE_TEMP (ease_temp_get_type ())
#define EASE_TEMP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_TEMP, EaseTemp))
#define EASE_TEMP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_TEMP, EaseTempClass))
#define EASE_IS_TEMP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_TEMP))
#define EASE_IS_TEMP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_TEMP))
#define EASE_TEMP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_TEMP, EaseTempClass))

typedef struct _EaseTemp EaseTemp;
typedef struct _EaseTempClass EaseTempClass;
typedef struct _EaseTempPrivate EaseTempPrivate;

#define EASE_TYPE_TEXT_ACTOR (ease_text_actor_get_type ())
#define EASE_TEXT_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_TEXT_ACTOR, EaseTextActor))
#define EASE_TEXT_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_TEXT_ACTOR, EaseTextActorClass))
#define EASE_IS_TEXT_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_TEXT_ACTOR))
#define EASE_IS_TEXT_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_TEXT_ACTOR))
#define EASE_TEXT_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_TEXT_ACTOR, EaseTextActorClass))

typedef struct _EaseTextActor EaseTextActor;
typedef struct _EaseTextActorClass EaseTextActorClass;
typedef struct _EaseTextActorPrivate EaseTextActorPrivate;

#define EASE_TYPE_TEXT_ELEMENT (ease_text_element_get_type ())
#define EASE_TEXT_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_TEXT_ELEMENT, EaseTextElement))
#define EASE_TEXT_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_TEXT_ELEMENT, EaseTextElementClass))
#define EASE_IS_TEXT_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_TEXT_ELEMENT))
#define EASE_IS_TEXT_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_TEXT_ELEMENT))
#define EASE_TEXT_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_TEXT_ELEMENT, EaseTextElementClass))

typedef struct _EaseTextElement EaseTextElement;
typedef struct _EaseTextElementClass EaseTextElementClass;
typedef struct _EaseTextElementPrivate EaseTextElementPrivate;
typedef struct _EaseThemePrivate EaseThemePrivate;
typedef struct _EaseUndoItemPrivate EaseUndoItemPrivate;
typedef struct _EaseUndoActionPrivate EaseUndoActionPrivate;

#define EASE_UNDO_ACTION_TYPE_UNDO_PAIR (ease_undo_action_undo_pair_get_type ())
#define EASE_UNDO_ACTION_UNDO_PAIR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_UNDO_ACTION_TYPE_UNDO_PAIR, EaseUndoActionUndoPair))
#define EASE_UNDO_ACTION_UNDO_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_UNDO_ACTION_TYPE_UNDO_PAIR, EaseUndoActionUndoPairClass))
#define EASE_UNDO_ACTION_IS_UNDO_PAIR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_UNDO_ACTION_TYPE_UNDO_PAIR))
#define EASE_UNDO_ACTION_IS_UNDO_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_UNDO_ACTION_TYPE_UNDO_PAIR))
#define EASE_UNDO_ACTION_UNDO_PAIR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_UNDO_ACTION_TYPE_UNDO_PAIR, EaseUndoActionUndoPairClass))

typedef struct _EaseUndoActionUndoPair EaseUndoActionUndoPair;
typedef struct _EaseUndoActionUndoPairClass EaseUndoActionUndoPairClass;

#define EASE_TYPE_UNDO_CONTROLLER (ease_undo_controller_get_type ())
#define EASE_UNDO_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_CONTROLLER, EaseUndoController))
#define EASE_UNDO_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_UNDO_CONTROLLER, EaseUndoControllerClass))
#define EASE_IS_UNDO_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_CONTROLLER))
#define EASE_IS_UNDO_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_UNDO_CONTROLLER))
#define EASE_UNDO_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_UNDO_CONTROLLER, EaseUndoControllerClass))

typedef struct _EaseUndoController EaseUndoController;
typedef struct _EaseUndoControllerClass EaseUndoControllerClass;
typedef struct _EaseUndoControllerPrivate EaseUndoControllerPrivate;

#define EASE_TYPE_VIDEO_ACTOR (ease_video_actor_get_type ())
#define EASE_VIDEO_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_VIDEO_ACTOR, EaseVideoActor))
#define EASE_VIDEO_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_VIDEO_ACTOR, EaseVideoActorClass))
#define EASE_IS_VIDEO_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_VIDEO_ACTOR))
#define EASE_IS_VIDEO_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_VIDEO_ACTOR))
#define EASE_VIDEO_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_VIDEO_ACTOR, EaseVideoActorClass))

typedef struct _EaseVideoActor EaseVideoActor;
typedef struct _EaseVideoActorClass EaseVideoActorClass;
typedef struct _EaseVideoActorPrivate EaseVideoActorPrivate;

#define EASE_TYPE_VIDEO_ELEMENT (ease_video_element_get_type ())
#define EASE_VIDEO_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_VIDEO_ELEMENT, EaseVideoElement))
#define EASE_VIDEO_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_VIDEO_ELEMENT, EaseVideoElementClass))
#define EASE_IS_VIDEO_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_VIDEO_ELEMENT))
#define EASE_IS_VIDEO_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_VIDEO_ELEMENT))
#define EASE_VIDEO_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_VIDEO_ELEMENT, EaseVideoElementClass))

typedef struct _EaseVideoElement EaseVideoElement;
typedef struct _EaseVideoElementClass EaseVideoElementClass;
typedef struct _EaseVideoElementPrivate EaseVideoElementPrivate;

typedef enum  {
	EASE_ACTOR_CONTEXT_PRESENTATION,
	EASE_ACTOR_CONTEXT_EDITOR,
	EASE_ACTOR_CONTEXT_INSPECTOR
} EaseActorContext;

struct _EaseActor {
	ClutterGroup parent_instance;
	EaseActorPrivate * priv;
	ClutterActor* contents;
	EaseElement* element;
	EaseActorContext context;
	gboolean is_background;
};

struct _EaseActorClass {
	ClutterGroupClass parent_class;
	void (*edit) (EaseActor* self, GtkWidget* sender);
	void (*end_edit) (EaseActor* self, GtkWidget* sender);
};

struct _EaseZoomSlider {
	GtkAlignment parent_instance;
	EaseZoomSliderPrivate * priv;
};

struct _EaseZoomSliderClass {
	GtkAlignmentClass parent_class;
	void (*change_zoom) (EaseZoomSlider* self, double value);
};

struct _EaseAnimatedZoomSlider {
	EaseZoomSlider parent_instance;
	EaseAnimatedZoomSliderPrivate * priv;
};

struct _EaseAnimatedZoomSliderClass {
	EaseZoomSliderClass parent_class;
};

struct _EaseBackground {
	GObject parent_instance;
	EaseBackgroundPrivate * priv;
};

struct _EaseBackgroundClass {
	GObjectClass parent_class;
};

typedef enum  {
	EASE_BACKGROUND_TYPE_COLOR,
	EASE_BACKGROUND_TYPE_GRADIENT,
	EASE_BACKGROUND_TYPE_IMAGE
} EaseBackgroundType;

struct _EaseBackgroundWidget {
	GtkAlignment parent_instance;
	EaseBackgroundWidgetPrivate * priv;
};

struct _EaseBackgroundWidgetClass {
	GtkAlignmentClass parent_class;
};

struct _EaseCairoActor {
	EaseActor parent_instance;
	EaseCairoActorPrivate * priv;
};

struct _EaseCairoActorClass {
	EaseActorClass parent_class;
};

struct _EaseUndoSourceIface {
	GTypeInterface parent_iface;
};

struct _EaseElement {
	GObject parent_instance;
	EaseElementPrivate * priv;
};

struct _EaseElementClass {
	GObjectClass parent_class;
	void (*signals) (EaseElement* self);
	JsonObject* (*to_json) (EaseElement* self);
	void (*to_html) (EaseElement* self, char** html, EaseHTMLExporter* exporter, double amount);
	char** (*claim_media) (EaseElement* self, int* result_length1);
	char* (*html_render) (EaseElement* self, EaseHTMLExporter* exporter);
	void (*cairo_render) (EaseElement* self, cairo_t* context, GError** error);
	EaseActor* (*actor) (EaseElement* self, EaseActorContext c);
	GtkWidget* (*inspector_widget) (EaseElement* self);
	GList* (*tool_items) (EaseElement* self);
	gboolean (*set_color) (EaseElement* self, ClutterColor* c);
	ClutterColor* (*get_color) (EaseElement* self);
};

struct _EaseCairoElement {
	EaseElement parent_instance;
	EaseCairoElementPrivate * priv;
};

struct _EaseCairoElementClass {
	EaseElementClass parent_class;
};

struct _EaseColor {
	GObject parent_instance;
	EaseColorPrivate * priv;
};

struct _EaseColorClass {
	GObjectClass parent_class;
};

struct _EaseDialogProgress {
	GObject parent_instance;
	EaseDialogProgressPrivate * priv;
};

struct _EaseDialogProgressClass {
	GObjectClass parent_class;
};

typedef void (*EaseDialogFileChooserDialogExtension) (GtkFileChooserDialog* d, void* user_data);
struct _EaseDocument {
	GObject parent_instance;
	EaseDocumentPrivate * priv;
	EaseIterableListStore* slides;
};

struct _EaseDocumentClass {
	GObjectClass parent_class;
};

typedef enum  {
	EASE_HANDLE_POSITION_TOP_LEFT = 0,
	EASE_HANDLE_POSITION_TOP_RIGHT = 1,
	EASE_HANDLE_POSITION_TOP = 2,
	EASE_HANDLE_POSITION_LEFT = 3,
	EASE_HANDLE_POSITION_RIGHT = 4,
	EASE_HANDLE_POSITION_BOTTOM_LEFT = 5,
	EASE_HANDLE_POSITION_BOTTOM_RIGHT = 6,
	EASE_HANDLE_POSITION_BOTTOM = 7
} EaseHandlePosition;

typedef enum  {
	EASE_KEY_UP = 65362,
	EASE_KEY_DOWN = 65364,
	EASE_KEY_LEFT = 65361,
	EASE_KEY_RIGHT = 65363,
	EASE_KEY_BACKSPACE = 65288,
	EASE_KEY_DELETE = 65535,
	EASE_KEY_ESCAPE = 0xff1b,
	EASE_KEY_SPACE = 32,
	EASE_KEY_ENTER = 65293
} EaseKey;

struct _EaseGradient {
	GObject parent_instance;
	EaseGradientPrivate * priv;
};

struct _EaseGradientClass {
	GObjectClass parent_class;
};

typedef enum  {
	EASE_GRADIENT_TYPE_LINEAR,
	EASE_GRADIENT_TYPE_LINEAR_MIRRORED,
	EASE_GRADIENT_TYPE_RADIAL
} EaseGradientType;

struct _EaseHTMLExporter {
	GObject parent_instance;
	EaseHTMLExporterPrivate * priv;
};

struct _EaseHTMLExporterClass {
	GObjectClass parent_class;
};

struct _EaseImageActor {
	EaseActor parent_instance;
	EaseImageActorPrivate * priv;
};

struct _EaseImageActorClass {
	EaseActorClass parent_class;
};

struct _EaseMediaElement {
	EaseElement parent_instance;
	EaseMediaElementPrivate * priv;
};

struct _EaseMediaElementClass {
	EaseElementClass parent_class;
};

struct _EaseImageElement {
	EaseMediaElement parent_instance;
	EaseImageElementPrivate * priv;
};

struct _EaseImageElementClass {
	EaseMediaElementClass parent_class;
};

struct _EaseImage {
	GObject parent_instance;
	EaseImagePrivate * priv;
};

struct _EaseImageClass {
	GObjectClass parent_class;
};

struct _EaseIterableTreeModelIface {
	GTypeInterface parent_iface;
};

struct _EaseIterableTreeModelIterator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EaseIterableTreeModelIteratorPrivate * priv;
};

struct _EaseIterableTreeModelIteratorClass {
	GTypeClass parent_class;
	void (*finalize) (EaseIterableTreeModelIterator *self);
};

struct _EaseIterableListStore {
	GtkListStore parent_instance;
	EaseIterableListStorePrivate * priv;
};

struct _EaseIterableListStoreClass {
	GtkListStoreClass parent_class;
};

struct _EaseShapeElement {
	EaseCairoElement parent_instance;
	EaseShapeElementPrivate * priv;
};

struct _EaseShapeElementClass {
	EaseCairoElementClass parent_class;
};

typedef enum  {
	EASE_SHAPE_TYPE_RECTANGLE = 0,
	EASE_SHAPE_TYPE_OVAL = 1
} EaseShapeType;

struct _EaseSlide {
	GObject parent_instance;
	EaseSlidePrivate * priv;
	GeeLinkedList* elements;
};

struct _EaseSlideClass {
	GObjectClass parent_class;
};

typedef enum  {
	EASE_TRANSITION_NONE,
	EASE_TRANSITION_FADE,
	EASE_TRANSITION_SLIDE,
	EASE_TRANSITION_DROP,
	EASE_TRANSITION_PIVOT,
	EASE_TRANSITION_FLIP,
	EASE_TRANSITION_REVOLVING_DOOR,
	EASE_TRANSITION_REVEAL,
	EASE_TRANSITION_FALL,
	EASE_TRANSITION_SLATS,
	EASE_TRANSITION_OPEN_DOOR,
	EASE_TRANSITION_EXPLODE,
	EASE_TRANSITION_ASSEMBLE,
	EASE_TRANSITION_ZOOM,
	EASE_TRANSITION_PANEL,
	EASE_TRANSITION_SPIN_CONTENTS,
	EASE_TRANSITION_SPRING_CONTENTS,
	EASE_TRANSITION_SWING_CONTENTS,
	EASE_TRANSITION_SLIDE_CONTENTS,
	EASE_TRANSITION_ZOOM_CONTENTS
} EaseTransition;

typedef enum  {
	EASE_TRANSITION_VARIANT_LEFT,
	EASE_TRANSITION_VARIANT_RIGHT,
	EASE_TRANSITION_VARIANT_UP,
	EASE_TRANSITION_VARIANT_DOWN,
	EASE_TRANSITION_VARIANT_BOTTOM,
	EASE_TRANSITION_VARIANT_TOP,
	EASE_TRANSITION_VARIANT_CENTER,
	EASE_TRANSITION_VARIANT_TOP_LEFT,
	EASE_TRANSITION_VARIANT_TOP_RIGHT,
	EASE_TRANSITION_VARIANT_BOTTOM_LEFT,
	EASE_TRANSITION_VARIANT_BOTTOM_RIGHT,
	EASE_TRANSITION_VARIANT_TOP_TO_BOTTOM,
	EASE_TRANSITION_VARIANT_BOTTOM_TO_TOP,
	EASE_TRANSITION_VARIANT_LEFT_TO_RIGHT,
	EASE_TRANSITION_VARIANT_RIGHT_TO_LEFT,
	EASE_TRANSITION_VARIANT_IN,
	EASE_TRANSITION_VARIANT_OUT
} EaseTransitionVariant;

struct _EaseSlideIterator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EaseSlideIteratorPrivate * priv;
};

struct _EaseSlideIteratorClass {
	GTypeClass parent_class;
	void (*finalize) (EaseSlideIterator *self);
};

struct _EaseTemp {
	GObject parent_instance;
	EaseTempPrivate * priv;
};

struct _EaseTempClass {
	GObjectClass parent_class;
};

struct _EaseTextActor {
	EaseActor parent_instance;
	EaseTextActorPrivate * priv;
};

struct _EaseTextActorClass {
	EaseActorClass parent_class;
};

struct _EaseTextElement {
	EaseElement parent_instance;
	EaseTextElementPrivate * priv;
};

struct _EaseTextElementClass {
	EaseElementClass parent_class;
};

struct _EaseTheme {
	GObject parent_instance;
	EaseThemePrivate * priv;
	char* title;
};

struct _EaseThemeClass {
	GObjectClass parent_class;
};

struct _EaseUndoItem {
	GObject parent_instance;
	EaseUndoItemPrivate * priv;
};

struct _EaseUndoItemClass {
	GObjectClass parent_class;
	EaseUndoItem* (*apply) (EaseUndoItem* self);
	gboolean (*contains) (EaseUndoItem* self, GObject* obj);
};

struct _EaseUndoAction {
	EaseUndoItem parent_instance;
	EaseUndoActionPrivate * priv;
	GeeLinkedList* pairs;
};

struct _EaseUndoActionClass {
	EaseUndoItemClass parent_class;
};

struct _EaseUndoController {
	GObject parent_instance;
	EaseUndoControllerPrivate * priv;
};

struct _EaseUndoControllerClass {
	GObjectClass parent_class;
};

typedef void (*EaseRecursiveDirAction) (const char* path, const char* full_path, void* user_data, GError** error);
struct _EaseVideoActor {
	EaseActor parent_instance;
	EaseVideoActorPrivate * priv;
};

struct _EaseVideoActorClass {
	EaseActorClass parent_class;
};

struct _EaseVideoElement {
	EaseMediaElement parent_instance;
	EaseVideoElementPrivate * priv;
};

struct _EaseVideoElementClass {
	EaseMediaElementClass parent_class;
};


GType ease_actor_get_type (void) G_GNUC_CONST;
GType ease_element_get_type (void) G_GNUC_CONST;
GType ease_actor_context_get_type (void) G_GNUC_CONST;
EaseActor* ease_actor_construct (GType object_type, EaseElement* e, EaseActorContext c);
void ease_actor_autosize (EaseActor* self, ClutterActor* actor);
void ease_actor_reposition (EaseActor* self);
void ease_actor_translate (EaseActor* self, float x_change, float y_change);
void ease_actor_resize (EaseActor* self, float w_change, float h_change, gboolean proportional);
void ease_actor_edit (EaseActor* self, GtkWidget* sender);
void ease_actor_end_edit (EaseActor* self, GtkWidget* sender);
GType ease_zoom_slider_get_type (void) G_GNUC_CONST;
GType ease_animated_zoom_slider_get_type (void) G_GNUC_CONST;
EaseAnimatedZoomSlider* ease_animated_zoom_slider_new (GtkAdjustment* adjustment, gint* button_values, int button_values_length1);
EaseAnimatedZoomSlider* ease_animated_zoom_slider_construct (GType object_type, GtkAdjustment* adjustment, gint* button_values, int button_values_length1);
GType ease_background_get_type (void) G_GNUC_CONST;
EaseBackground* ease_background_new (void);
EaseBackground* ease_background_construct (GType object_type);
EaseBackground* ease_background_new_default_gradient (void);
EaseBackground* ease_background_construct_default_gradient (GType object_type);
EaseBackground* ease_background_new_from_json (JsonObject* obj);
EaseBackground* ease_background_construct_from_json (GType object_type, JsonObject* obj);
void ease_background_to_json (EaseBackground* self, JsonObject** obj);
void ease_background_set_cairo (EaseBackground* self, cairo_t* cr, gint width, gint height, const char* path);
GType ease_background_type_get_type (void) G_GNUC_CONST;
char* ease_background_type_to_string (EaseBackgroundType self);
EaseBackgroundType ease_background_type_from_string (const char* str);
char* ease_background_type_description (EaseBackgroundType self);
GType ease_background_widget_get_type (void) G_GNUC_CONST;
EaseBackgroundWidget* ease_background_widget_new (EaseBackground* bg, EaseElement* e);
EaseBackgroundWidget* ease_background_widget_construct (GType object_type, EaseBackground* bg, EaseElement* e);
GType ease_slide_get_type (void) G_GNUC_CONST;
EaseBackgroundWidget* ease_background_widget_new_for_slide (EaseSlide* s);
EaseBackgroundWidget* ease_background_widget_construct_for_slide (GType object_type, EaseSlide* s);
GType ease_cairo_actor_get_type (void) G_GNUC_CONST;
EaseCairoActor* ease_cairo_actor_new (EaseElement* e, EaseActorContext ctx);
EaseCairoActor* ease_cairo_actor_construct (GType object_type, EaseElement* e, EaseActorContext ctx);
GType ease_undo_source_get_type (void) G_GNUC_CONST;
GType ease_html_exporter_get_type (void) G_GNUC_CONST;
GType ease_cairo_element_get_type (void) G_GNUC_CONST;
EaseCairoElement* ease_cairo_element_construct (GType object_type);
GType ease_color_get_type (void) G_GNUC_CONST;
EaseColor* ease_color_new_rgb (double r, double g, double b);
EaseColor* ease_color_construct_rgb (GType object_type, double r, double g, double b);
EaseColor* ease_color_new_rgba (double r, double g, double b, double a);
EaseColor* ease_color_construct_rgba (GType object_type, double r, double g, double b, double a);
EaseColor* ease_color_new_from_clutter (ClutterColor* color);
EaseColor* ease_color_construct_from_clutter (GType object_type, ClutterColor* color);
EaseColor* ease_color_new_from_gdk (GdkColor* color);
EaseColor* ease_color_construct_from_gdk (GType object_type, GdkColor* color);
EaseColor* ease_color_new_from_string (const char* str);
EaseColor* ease_color_construct_from_string (GType object_type, const char* str);
char* ease_color_to_string (EaseColor* self);
EaseColor* ease_color_copy (EaseColor* self);
void ease_color_set_cairo (EaseColor* self, cairo_t* cr);
GType ease_undo_item_get_type (void) G_GNUC_CONST;
GType ease_undo_action_get_type (void) G_GNUC_CONST;
EaseUndoAction* ease_color_undo_action (EaseColor* self);
EaseColor* ease_color_new (void);
EaseColor* ease_color_construct (GType object_type);
EaseColor* ease_color_get_white (void);
EaseColor* ease_color_get_black (void);
double ease_color_get_red (EaseColor* self);
void ease_color_set_red (EaseColor* self, double value);
double ease_color_get_green (EaseColor* self);
void ease_color_set_green (EaseColor* self, double value);
double ease_color_get_blue (EaseColor* self);
void ease_color_set_blue (EaseColor* self, double value);
double ease_color_get_alpha (EaseColor* self);
void ease_color_set_alpha (EaseColor* self, double value);
void ease_color_get_clutter (EaseColor* self, ClutterColor* result);
void ease_color_set_clutter (EaseColor* self, ClutterColor* value);
void ease_color_get_gdk (EaseColor* self, GdkColor* result);
void ease_color_set_gdk (EaseColor* self, GdkColor* value);
GType ease_dialog_progress_get_type (void) G_GNUC_CONST;
EaseDialogProgress* ease_dialog_progress_new (const char* title, gboolean cancellable, double max, GtkWindow* modal);
EaseDialogProgress* ease_dialog_progress_construct (GType object_type, const char* title, gboolean cancellable, double max, GtkWindow* modal);
void ease_dialog_progress_show (EaseDialogProgress* self);
void ease_dialog_progress_destroy (EaseDialogProgress* self);
void ease_dialog_progress_set_label (EaseDialogProgress* self, const char* str);
void ease_dialog_progress_set (EaseDialogProgress* self, double val);
void ease_dialog_progress_set_fraction (EaseDialogProgress* self, double val);
void ease_dialog_progress_add (EaseDialogProgress* self, double val);
void ease_dialog_progress_add_fraction (EaseDialogProgress* self, double val);
char* ease_dialog_open (const char* title, GtkWindow* modal);
char* ease_dialog_open_ext (const char* title, GtkWindow* modal, EaseDialogFileChooserDialogExtension ext, void* ext_target);
char* ease_dialog_open_document (GtkWindow* modal);
char* ease_dialog_save (const char* title, GtkWindow* modal);
char* ease_dialog_save_ext (const char* title, GtkWindow* modal, EaseDialogFileChooserDialogExtension ext, void* ext_target);
char* ease_dialog_save_document (const char* title, GtkWindow* modal);
GType ease_document_get_type (void) G_GNUC_CONST;
GType ease_iterable_list_store_get_type (void) G_GNUC_CONST;
#define EASE_DOCUMENT_DEFAULT_SLIDE EASE_THEME_CONTENT_HEADER
#define EASE_DOCUMENT_THEME_PATH "Theme"
#define EASE_DOCUMENT_COL_SLIDE 0
#define EASE_DOCUMENT_COL_PIXBUF 1
#define EASE_DOCUMENT_COL_TITLE 2
EaseDocument* ease_document_new_from_saved (const char* file_path, GError** error);
EaseDocument* ease_document_construct_from_saved (GType object_type, const char* file_path, GError** error);
GType ease_theme_get_type (void) G_GNUC_CONST;
EaseDocument* ease_document_new_from_theme (EaseTheme* doc_theme, gint w, gint h, GError** error);
EaseDocument* ease_document_construct_from_theme (GType object_type, EaseTheme* doc_theme, gint w, gint h, GError** error);
void ease_document_to_json (EaseDocument* self, GtkWindow* window, GError** error);
void ease_document_add_slide (EaseDocument* self, gint index, EaseSlide* slide);
void ease_document_append_slide (EaseDocument* self, EaseSlide* s);
EaseSlide* ease_document_remove_slide (EaseDocument* self, EaseSlide* slide);
gboolean ease_document_has_next_slide (EaseDocument* self, EaseSlide* slide);
gint ease_document_index_of (EaseDocument* self, EaseSlide* slide);
EaseSlide* ease_document_get_slide (EaseDocument* self, gint index);
void ease_document_cairo_render (EaseDocument* self, cairo_surface_t* surface, GError** error);
void ease_document_export_as_pdf (EaseDocument* self, GtkWindow* win);
void ease_document_export_as_postscript (EaseDocument* self, GtkWindow* win);
void ease_document_export_as_html (EaseDocument* self, GtkWindow* window);
char* ease_document_add_media_file (EaseDocument* self, const char* file, GError** error);
EaseDocument* ease_document_new (void);
EaseDocument* ease_document_construct (GType object_type);
EaseTheme* ease_document_get_theme (EaseDocument* self);
void ease_document_set_theme (EaseDocument* self, EaseTheme* value);
gint ease_document_get_width (EaseDocument* self);
void ease_document_set_width (EaseDocument* self, gint value);
gint ease_document_get_height (EaseDocument* self);
void ease_document_set_height (EaseDocument* self, gint value);
float ease_document_get_aspect (EaseDocument* self);
const char* ease_document_get_filename (EaseDocument* self);
void ease_document_set_filename (EaseDocument* self, const char* value);
const char* ease_document_get_path (EaseDocument* self);
void ease_document_set_path (EaseDocument* self, const char* value);
gint ease_document_get_length (EaseDocument* self);
EaseElement* ease_element_construct_from_json (GType object_type, JsonObject* obj);
void ease_element_signals (EaseElement* self);
JsonObject* ease_element_to_json (EaseElement* self);
EaseElement* ease_element_construct_with_owner (GType object_type, EaseSlide* owner);
char** ease_element_claim_media (EaseElement* self, int* result_length1);
char* ease_element_html_render (EaseElement* self, EaseHTMLExporter* exporter);
void ease_element_cairo_render (EaseElement* self, cairo_t* context, GError** error);
EaseActor* ease_element_actor (EaseElement* self, EaseActorContext c);
GtkWidget* ease_element_inspector_widget (EaseElement* self);
GtkWidget* ease_element_get_inspector_widget (EaseElement* self);
GList* ease_element_tool_items (EaseElement* self);
gboolean ease_element_set_color (EaseElement* self, ClutterColor* c);
ClutterColor* ease_element_get_color (EaseElement* self);
EaseElement* ease_element_construct (GType object_type);
const char* ease_element_get_identifier (EaseElement* self);
void ease_element_set_identifier (EaseElement* self, const char* value);
const char* ease_element_get_element_type (EaseElement* self);
void ease_element_set_element_type (EaseElement* self, const char* value);
float ease_element_get_x (EaseElement* self);
void ease_element_set_x (EaseElement* self, float value);
float ease_element_get_y (EaseElement* self);
void ease_element_set_y (EaseElement* self, float value);
float ease_element_get_width (EaseElement* self);
void ease_element_set_width (EaseElement* self, float value);
float ease_element_get_height (EaseElement* self);
void ease_element_set_height (EaseElement* self, float value);
gboolean ease_element_get_has_been_edited (EaseElement* self);
void ease_element_set_has_been_edited (EaseElement* self, gboolean value);
GType ease_handle_position_get_type (void) G_GNUC_CONST;
GType ease_key_get_type (void) G_GNUC_CONST;
GType ease_gradient_get_type (void) G_GNUC_CONST;
EaseGradient* ease_gradient_new (EaseColor* start_color, EaseColor* end_color);
EaseGradient* ease_gradient_construct (GType object_type, EaseColor* start_color, EaseColor* end_color);
EaseGradient* ease_gradient_new_mirrored (EaseColor* start_color, EaseColor* end_color);
EaseGradient* ease_gradient_construct_mirrored (GType object_type, EaseColor* start_color, EaseColor* end_color);
EaseGradient* ease_gradient_new_radial (EaseColor* start_color, EaseColor* end_color);
EaseGradient* ease_gradient_construct_radial (GType object_type, EaseColor* start_color, EaseColor* end_color);
EaseGradient* ease_gradient_new_from_string (const char* str);
EaseGradient* ease_gradient_construct_from_string (GType object_type, const char* str);
char* ease_gradient_to_string (EaseGradient* self);
EaseGradient* ease_gradient_copy (EaseGradient* self);
void ease_gradient_flip (EaseGradient* self);
void ease_gradient_cairo_render_rect (EaseGradient* self, cairo_t* cr, gint width, gint height);
void ease_gradient_set_cairo (EaseGradient* self, cairo_t* cr, gint width, gint height);
EaseColor* ease_gradient_get_start (EaseGradient* self);
void ease_gradient_set_start (EaseGradient* self, EaseColor* value);
EaseColor* ease_gradient_get_end (EaseGradient* self);
void ease_gradient_set_end (EaseGradient* self, EaseColor* value);
GType ease_gradient_type_get_type (void) G_GNUC_CONST;
EaseGradientType ease_gradient_get_mode (EaseGradient* self);
void ease_gradient_set_mode (EaseGradient* self, EaseGradientType value);
double ease_gradient_get_angle (EaseGradient* self);
void ease_gradient_set_angle (EaseGradient* self, double value);
EaseGradient* ease_gradient_get_default_background (void);
char* ease_gradient_type_to_string (EaseGradientType self);
EaseGradientType ease_gradient_type_from_string (const char* str);
char* ease_gradient_type_description (EaseGradientType self);
GtkListStore* ease_gradient_type_list_store (void);
#define EASE_HTML_EXPORTER_HEADER "<!DOCTYPE html>\n" \
"<html>\n" \
"<head>\n" \
"\t<title>Presentation</title>\n" \
"\t\n" \
"\t<script type=\"text/javascript\">\n" \
"\t\tvar slide = -1;\n" \
"\n" \
"\t\tfunction load() {\n" \
"\t\t\tadvance();\n" \
"\t\t}\n" \
"\n" \
"\t\tfunction keydown(e) {\n" \
"\t\t\tvar code = e.keyCode;\n" \
"\t\t\tif (code == 32 || code == 39 || code == 13 || code == 40 || code" \
" == 39) {\n" \
"\t\t\t\tadvance();\n" \
"\t\t\t}\n" \
"\t\n" \
"\t\t\telse if (code == 8 || code == 46 || code == 37 || code == 38) {\n" \
"\t\t\t\tretreat();\n" \
"\t\t\t}\n" \
"\t\t}\n" \
"\n" \
"\t\tfunction advance() {\n" \
"\t\t\tif (document.getElementById(\"slide\" + (slide + 1)) != null) {\n" \
"\t\t\t\tif (slide >= 0) {\n" \
"\t\t\t\t\tdocument.getElementById(\"slide\" + slide).style.display = \"" \
"none\";\n" \
"\t\t\t\t}\n" \
"\t\t\t\tslide++;\n" \
"\t\t\t\tdocument.getElementById(\"slide\" + slide).style.display = \"b" \
"lock\";\n" \
"\t\t\t}\n" \
"\t\t}\n" \
"\n" \
"\t\tfunction retreat() {\n" \
"\t\t\tif (slide > 0) {\n" \
"\t\t\t\tdocument.getElementById(\"slide\" + slide).style.display = \"n" \
"one\";\n" \
"\t\t\t\tslide--;\n" \
"\t\t\t\tdocument.getElementById(\"slide\" + slide).style.display = \"b" \
"lock\";\n" \
"\t\t\t}\n" \
"\t\t}\n" \
"\n" \
"\t\tdocument.onkeydown = keydown;\n" \
"\t</script>\n" \
"\t\n" \
"\t<style>\n" \
"\t\t.slide {\n" \
"\t\t\twidth: %ipx;\n" \
"\t\t\theight: %ipx;\n" \
"\t\t\tdisplay: none;\n" \
"\t\t\toverflow: hidden;\n" \
"\t\t\tposition: relative;\n" \
"\t\t\tmargin: 20px auto 20px auto;\n" \
"\t\t}\n" \
"\t\thtml {\n" \
"\t\t\tpadding: 0px;\n" \
"\t\t\tmargin: 0px;\n" \
"\t\t\tbackground-color: black;\n" \
"\t\t}\n" \
"\t</style>\n" \
"</head>\n" \
"<body onload=load()>\n"
EaseHTMLExporter* ease_html_exporter_new (void);
EaseHTMLExporter* ease_html_exporter_construct (GType object_type);
gboolean ease_html_exporter_request_path (EaseHTMLExporter* self, GtkWindow* win);
void ease_html_exporter_add_progress (EaseHTMLExporter* self, double amount);
void ease_html_exporter_finish (EaseHTMLExporter* self);
void ease_html_exporter_copy_file (EaseHTMLExporter* self, const char* end_path, const char* base_path);
const char* ease_html_exporter_get_path (EaseHTMLExporter* self);
char* ease_html_exporter_get_basename (EaseHTMLExporter* self);
GType ease_image_actor_get_type (void) G_GNUC_CONST;
GType ease_media_element_get_type (void) G_GNUC_CONST;
GType ease_image_element_get_type (void) G_GNUC_CONST;
EaseImageActor* ease_image_actor_new (EaseImageElement* e, EaseActorContext c);
EaseImageActor* ease_image_actor_construct (GType object_type, EaseImageElement* e, EaseActorContext c);
EaseImageElement* ease_image_element_new (void);
EaseImageElement* ease_image_element_construct (GType object_type);
GType ease_image_get_type (void) G_GNUC_CONST;
void ease_image_set_cairo (EaseImage* self, cairo_t* cr, gint width, gint height, const char* path);
EaseImage* ease_image_new (void);
EaseImage* ease_image_construct (GType object_type);
GType ease_iterable_tree_model_get_type (void) G_GNUC_CONST;
gpointer ease_iterable_tree_model_iterator_ref (gpointer instance);
void ease_iterable_tree_model_iterator_unref (gpointer instance);
GParamSpec* ease_iterable_tree_model_param_spec_iterator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void ease_iterable_tree_model_value_set_iterator (GValue* value, gpointer v_object);
void ease_iterable_tree_model_value_take_iterator (GValue* value, gpointer v_object);
gpointer ease_iterable_tree_model_value_get_iterator (const GValue* value);
GType ease_iterable_tree_model_iterator_get_type (void) G_GNUC_CONST;
EaseIterableTreeModelIterator* ease_iterable_tree_model_iterator (EaseIterableTreeModel* self);
EaseIterableTreeModelIterator* ease_iterable_tree_model_iterator_new (EaseIterableTreeModel* _self_);
EaseIterableTreeModelIterator* ease_iterable_tree_model_iterator_construct (GType object_type, EaseIterableTreeModel* _self_);
gboolean ease_iterable_tree_model_iterator_next (EaseIterableTreeModelIterator* self);
void ease_iterable_tree_model_iterator_get (EaseIterableTreeModelIterator* self, GtkTreeIter* result);
EaseIterableListStore* ease_iterable_list_store_new (GType* types, int types_length1);
EaseIterableListStore* ease_iterable_list_store_construct (GType object_type, GType* types, int types_length1);
gint ease_iterable_list_store_get_size (EaseIterableListStore* self);
EaseMediaElement* ease_media_element_construct (GType object_type);
const char* ease_media_element_get_filename (EaseMediaElement* self);
void ease_media_element_set_filename (EaseMediaElement* self, const char* value);
const char* ease_media_element_get_source_filename (EaseMediaElement* self);
void ease_media_element_set_source_filename (EaseMediaElement* self, const char* value);
char* ease_media_element_get_full_filename (EaseMediaElement* self);
GType ease_shape_element_get_type (void) G_GNUC_CONST;
GType ease_shape_type_get_type (void) G_GNUC_CONST;
EaseShapeElement* ease_shape_element_new (EaseShapeType type);
EaseShapeElement* ease_shape_element_construct (GType object_type, EaseShapeType type);
EaseShapeElement* ease_shape_element_new_from_json (JsonObject* obj);
EaseShapeElement* ease_shape_element_construct_from_json (GType object_type, JsonObject* obj);
EaseShapeType ease_shape_element_get_shape_type (EaseShapeElement* self);
#define EASE_SLIDE_IMAGE_TYPE "EaseImageElement"
#define EASE_SLIDE_SHAPE_TYPE "EaseShapeElement"
#define EASE_SLIDE_VIDEO_TYPE "EaseVideoElement"
EaseSlide* ease_slide_new (void);
EaseSlide* ease_slide_construct (GType object_type);
EaseSlide* ease_slide_new_with_owner (EaseDocument* owner);
EaseSlide* ease_slide_construct_with_owner (GType object_type, EaseDocument* owner);
void ease_slide_add (EaseSlide* self, gint index, EaseElement* e);
void ease_slide_append (EaseSlide* self, EaseElement* e);
void ease_slide_remove (EaseSlide* self, EaseElement* e);
void ease_slide_remove_at (EaseSlide* self, gint index);
gint ease_slide_index_of (EaseSlide* self, EaseElement* e);
EaseElement* ease_slide_element_at (EaseSlide* self, gint i);
void ease_slide_raise (EaseSlide* self, EaseElement* element);
void ease_slide_lower (EaseSlide* self, EaseElement* element);
void ease_slide_raise_top (EaseSlide* self, EaseElement* element);
void ease_slide_lower_bottom (EaseSlide* self, EaseElement* element);
void ease_slide_cairo_render (EaseSlide* self, cairo_t* context, GError** error);
void ease_slide_cairo_render_sized (EaseSlide* self, cairo_t* context, gint w, gint h, GError** error);
void ease_slide_cairo_render_background (EaseSlide* self, cairo_t* cr, gint w, gint h, GError** error);
void ease_slide_to_html (EaseSlide* self, char** html, EaseHTMLExporter* exporter, double amount, gint index);
gpointer ease_slide_iterator_ref (gpointer instance);
void ease_slide_iterator_unref (gpointer instance);
GParamSpec* ease_slide_param_spec_iterator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void ease_slide_value_set_iterator (GValue* value, gpointer v_object);
void ease_slide_value_take_iterator (GValue* value, gpointer v_object);
gpointer ease_slide_value_get_iterator (const GValue* value);
GType ease_slide_iterator_get_type (void) G_GNUC_CONST;
EaseSlideIterator* ease_slide_iterator (EaseSlide* self);
GType ease_transition_get_type (void) G_GNUC_CONST;
EaseTransition ease_slide_get_transition (EaseSlide* self);
void ease_slide_set_transition (EaseSlide* self, EaseTransition value);
GType ease_transition_variant_get_type (void) G_GNUC_CONST;
EaseTransitionVariant ease_slide_get_variant (EaseSlide* self);
void ease_slide_set_variant (EaseSlide* self, EaseTransitionVariant value);
double ease_slide_get_transition_time (EaseSlide* self);
void ease_slide_set_transition_time (EaseSlide* self, double value);
guint ease_slide_get_transition_msecs (EaseSlide* self);
void ease_slide_set_transition_msecs (EaseSlide* self, guint value);
gboolean ease_slide_get_automatically_advance (EaseSlide* self);
void ease_slide_set_automatically_advance (EaseSlide* self, gboolean value);
double ease_slide_get_advance_delay (EaseSlide* self);
void ease_slide_set_advance_delay (EaseSlide* self, double value);
EaseBackground* ease_slide_get_background (EaseSlide* self);
void ease_slide_set_background (EaseSlide* self, EaseBackground* value);
char* ease_slide_get_background_abs (EaseSlide* self);
gint ease_slide_get_width (EaseSlide* self);
gint ease_slide_get_height (EaseSlide* self);
float ease_slide_get_aspect (EaseSlide* self);
const char* ease_slide_get_master (EaseSlide* self);
void ease_slide_set_master (EaseSlide* self, const char* value);
gint ease_slide_get_count (EaseSlide* self);
EaseSlide* ease_slide_get_next (EaseSlide* self);
EaseSlide* ease_slide_get_previous (EaseSlide* self);
EaseSlideIterator* ease_slide_iterator_new (EaseSlide* slide);
EaseSlideIterator* ease_slide_iterator_construct (GType object_type, EaseSlide* slide);
gboolean ease_slide_iterator_next (EaseSlideIterator* self);
EaseElement* ease_slide_iterator_get (EaseSlideIterator* self);
GType ease_temp_get_type (void) G_GNUC_CONST;
#define EASE_TEMP_TEMP_DIR "ease"
#define EASE_TEMP_THEME_DIR "themes"
#define EASE_TEMP_IMG_DIR "svg"
#define EASE_TEMP_UI_DIR "ui"
char* ease_temp_request (GError** error);
char* ease_temp_request_str (const char* str, GError** error);
void ease_temp_clean (void);
gboolean ease_temp_exists (gint dir, const char* tmp);
EaseTemp* ease_temp_new (void);
EaseTemp* ease_temp_construct (GType object_type);
GType ease_text_actor_get_type (void) G_GNUC_CONST;
GType ease_text_element_get_type (void) G_GNUC_CONST;
EaseTextActor* ease_text_actor_new (EaseTextElement* e, EaseActorContext c);
EaseTextActor* ease_text_actor_construct (GType object_type, EaseTextElement* e, EaseActorContext c);
EaseTextElement* ease_text_element_new (void);
EaseTextElement* ease_text_element_construct (GType object_type);
void ease_text_element_on_inspector_alignment (GtkWidget* sender, EaseTextElement* self);
char* ease_text_element_text_style_to_string (EaseTextElement* self);
void ease_text_element_text_style_from_string (EaseTextElement* self, const char* str);
void ease_text_element_text_variant_from_string (EaseTextElement* self, const char* str);
char* ease_text_element_text_variant_to_string (EaseTextElement* self);
void ease_text_element_text_weight_from_string (EaseTextElement* self, const char* str);
char* ease_text_element_text_weight_to_string (EaseTextElement* self);
void ease_text_element_text_align_from_string (EaseTextElement* self, const char* str);
char* ease_text_element_text_align_to_string (EaseTextElement* self);
void ease_text_element_text_size_from_string (EaseTextElement* self, const char* str);
char* ease_text_element_text_size_to_string (EaseTextElement* self);
const char* ease_text_element_get_text (EaseTextElement* self);
void ease_text_element_set_text (EaseTextElement* self, const char* value);
const char* ease_text_element_get_display_text (EaseTextElement* self);
EaseColor* ease_text_element_get_color (EaseTextElement* self);
void ease_text_element_set_color (EaseTextElement* self, EaseColor* value);
const char* ease_text_element_get_text_font (EaseTextElement* self);
void ease_text_element_set_text_font (EaseTextElement* self, const char* value);
PangoStyle ease_text_element_get_text_style (EaseTextElement* self);
void ease_text_element_set_text_style (EaseTextElement* self, PangoStyle value);
PangoVariant ease_text_element_get_text_variant (EaseTextElement* self);
void ease_text_element_set_text_variant (EaseTextElement* self, PangoVariant value);
gint ease_text_element_get_text_weight (EaseTextElement* self);
void ease_text_element_set_text_weight (EaseTextElement* self, gint value);
PangoFontDescription* ease_text_element_get_font_description (EaseTextElement* self);
void ease_text_element_set_font_description (EaseTextElement* self, const PangoFontDescription* value);
PangoAlignment ease_text_element_get_text_align (EaseTextElement* self);
void ease_text_element_set_text_align (EaseTextElement* self, PangoAlignment value);
gint ease_text_element_get_text_size (EaseTextElement* self);
void ease_text_element_set_text_size (EaseTextElement* self, gint value);
#define EASE_THEME_JSON_PATH "Theme.json"
#define EASE_THEME_TITLE "title"
#define EASE_THEME_CONTENT "content"
#define EASE_THEME_CONTENT_HEADER "content-header"
#define EASE_THEME_CONTENT_DUAL "content-dual"
#define EASE_THEME_CONTENT_DUAL_HEADER "content-dual-header"
#define EASE_THEME_MEDIA "media"
#define EASE_THEME_MEDIA_HEADER "media-header"
#define EASE_THEME_EMPTY "empty"
#define EASE_THEME_BACKGROUND_COLOR "background-color"
#define EASE_THEME_BACKGROUND_GRADIENT "background-gradient"
#define EASE_THEME_BACKGROUND_IMAGE "background-image"
#define EASE_THEME_BACKGROUND_IMAGE_SOURCE "background-image-source"
#define EASE_THEME_BACKGROUND_IMAGE_FILL "background-image-fill"
#define EASE_THEME_S_IDENTIFIER "slide-identifier"
#define EASE_THEME_TITLE_TEXT "title-text"
#define EASE_THEME_AUTHOR_TEXT "author-text"
#define EASE_THEME_CONTENT_TEXT "content-text"
#define EASE_THEME_HEADER_TEXT "header-text"
#define EASE_THEME_CUSTOM_TEXT "custom-text"
#define EASE_THEME_TEXT_FONT "text-font"
#define EASE_THEME_TEXT_SIZE "text-size"
#define EASE_THEME_TEXT_STYLE "text-style"
#define EASE_THEME_TEXT_VARIANT "text-variant"
#define EASE_THEME_TEXT_WEIGHT "text-weight"
#define EASE_THEME_TEXT_ALIGN "text-align"
#define EASE_THEME_TEXT_COLOR "text-color"
#define EASE_THEME_TEXT_TEXT "text"
#define EASE_THEME_CONTENT_MEDIA "content-media"
#define EASE_THEME_CUSTOM_MEDIA "custom-media"
#define EASE_THEME_MEDIA_FILENAME "media-filename"
#define EASE_THEME_MEDIA_SOURCE_FILENAME "media-source-filename"
#define EASE_THEME_SHAPE_TYPE "shape-type"
#define EASE_THEME_GRAD_LINEAR "linear"
#define EASE_THEME_GRAD_LINEAR_MIRRORED "linear-mirrored"
#define EASE_THEME_GRAD_RADIAL "radial"
#define EASE_THEME_IMAGE_STRETCH "image-fill-stretch"
#define EASE_THEME_IMAGE_ASPECT "image-fill-aspect"
#define EASE_THEME_IMAGE_ORIGINAL "image-fill-original"
#define EASE_THEME_VIDEO_PLAY_AUTO "video-play-automatically"
#define EASE_THEME_VIDEO_MUTE "video-mute"
#define EASE_THEME_VIDEO_END_ACTION "video-end-action"
#define EASE_THEME_VIDEO_END_STOP "video-end-stop"
#define EASE_THEME_VIDEO_END_LOOP "video-end-loop"
#define EASE_THEME_VIDEO_END_CONTINUE "video-end-continue"
#define EASE_THEME_E_IDENTIFIER "element-identifier"
#define EASE_THEME_ELEMENT_TYPE "element-type"
#define EASE_THEME_PAD_LEFT "padding-left"
#define EASE_THEME_PAD_RIGHT "padding-right"
#define EASE_THEME_PAD_TOP "padding-top"
#define EASE_THEME_PAD_BOTTOM "padding-bottom"
#define EASE_THEME_WIDTH "width"
#define EASE_THEME_HEIGHT "height"
#define EASE_THEME_X "x"
#define EASE_THEME_Y "y"
#define EASE_THEME_HAS_BEEN_EDITED "has-been-edited"
EaseTheme* ease_theme_new (const char* dir_path);
EaseTheme* ease_theme_construct (GType object_type, const char* dir_path);
EaseTheme* ease_theme_new_json (const char* json_path);
EaseTheme* ease_theme_construct_json (GType object_type, const char* json_path);
EaseTheme* ease_theme_copy_to_path (EaseTheme* self, const char* copy_to, GError** error);
void ease_theme_copy_media (EaseTheme* self, const char* target, GError** error);
EaseSlide* ease_theme_create_slide (EaseTheme* self, const char* master, gint width, gint height);
EaseTextElement* ease_theme_create_custom_text (EaseTheme* self);
char* ease_theme_master_description (const char* master);
char* ease_theme_master_mnemonic_description (const char* master);
char* ease_theme_master_from_description (const char* desc);
const char* ease_theme_get_path (EaseTheme* self);
void ease_theme_set_path (EaseTheme* self, const char* value);
void ease_transformations_clutter_color_to_gdk_color (ClutterColor* color, GdkColor* result);
void ease_transformations_gdk_color_to_clutter_color (GdkColor* color, ClutterColor* result);
GtkListStore* ease_transition_model (void);
GtkListStore* ease_transition_variant_model (EaseTransition self);
EaseTransition ease_transition_from_string (const char* str);
EaseTransitionVariant* ease_transition_variants (EaseTransition self, int* result_length1);
char* ease_transition_get_name (EaseTransition self);
EaseTransitionVariant ease_transition_variant_from_string (const char* str);
char* ease_transition_variant_get_name (EaseTransitionVariant self);
gpointer ease_undo_action_undo_pair_ref (gpointer instance);
void ease_undo_action_undo_pair_unref (gpointer instance);
GParamSpec* ease_undo_action_param_spec_undo_pair (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void ease_undo_action_value_set_undo_pair (GValue* value, gpointer v_object);
void ease_undo_action_value_take_undo_pair (GValue* value, gpointer v_object);
gpointer ease_undo_action_value_get_undo_pair (const GValue* value);
GType ease_undo_action_undo_pair_get_type (void) G_GNUC_CONST;
EaseUndoAction* ease_undo_action_new (GObject* obj, const char* prop);
EaseUndoAction* ease_undo_action_construct (GType object_type, GObject* obj, const char* prop);
void ease_undo_action_add (EaseUndoAction* self, GObject* obj, const char* prop);
void ease_undo_action_combine (EaseUndoAction* self, EaseUndoAction* action);
GType ease_undo_controller_get_type (void) G_GNUC_CONST;
EaseUndoController* ease_undo_controller_new (void);
EaseUndoController* ease_undo_controller_construct (GType object_type);
gboolean ease_undo_controller_can_undo (EaseUndoController* self);
gboolean ease_undo_controller_can_redo (EaseUndoController* self);
void ease_undo_controller_undo (EaseUndoController* self);
void ease_undo_controller_redo (EaseUndoController* self);
void ease_undo_controller_clear_redo (EaseUndoController* self);
void ease_undo_controller_add_action (EaseUndoController* self, EaseUndoItem* action);
gboolean ease_undo_controller_get_enable_debug (void);
void ease_undo_controller_set_enable_debug (gboolean value);
EaseUndoItem* ease_undo_item_apply (EaseUndoItem* self);
gboolean ease_undo_item_contains (EaseUndoItem* self, GObject* obj);
EaseUndoItem* ease_undo_item_construct (GType object_type);
void ease_undo_source_forward (EaseUndoSource* self, EaseUndoItem* action);
void ease_undo_source_listen (EaseUndoSource* self, EaseUndoSource* source);
void ease_undo_source_silence (EaseUndoSource* self, EaseUndoSource* source);
void ease_error_dialog (const char* title, const char* message);
char* ease_data_path (const char* path);
void ease_recursive_directory (const char* directory, EaseRecursiveDirAction directory_action, void* directory_action_target, EaseRecursiveDirAction file_action, void* file_action_target, GError** error);
void ease_recursive_directory_after (const char* directory, EaseRecursiveDirAction directory_action, void* directory_action_target, EaseRecursiveDirAction file_action, void* file_action_target, GError** error);
void ease_recursive_delete (const char* path, GError** error);
void ease_recursive_copy (const char* from_dir, const char* to_dir, GError** error);
GdkColor* ease_theme_color (const char* color);
void ease_theme_clutter_color (const char* color, ClutterColor* result);
GtkWindow* ease_widget_window (GtkWidget* widg);
char* ease_absolute_path (const char* path);
double ease_dmax (double a, double b);
double ease_dmin (double a, double b);
gint ease_roundd (double num);
GType ease_video_actor_get_type (void) G_GNUC_CONST;
GType ease_video_element_get_type (void) G_GNUC_CONST;
EaseVideoActor* ease_video_actor_new (EaseVideoElement* e, EaseActorContext c);
EaseVideoActor* ease_video_actor_construct (GType object_type, EaseVideoElement* e, EaseActorContext c);
double ease_video_actor_get_audio_volume (EaseVideoActor* self);
double ease_video_actor_get_buffer_fill (EaseVideoActor* self);
gboolean ease_video_actor_get_can_seek (EaseVideoActor* self);
double ease_video_actor_get_duration (EaseVideoActor* self);
gboolean ease_video_actor_get_playing (EaseVideoActor* self);
double ease_video_actor_get_progress (EaseVideoActor* self);
const char* ease_video_actor_get_subtitle_font_name (EaseVideoActor* self);
const char* ease_video_actor_get_subtitle_uri (EaseVideoActor* self);
const char* ease_video_actor_get_uri (EaseVideoActor* self);
void ease_video_actor_set_audio_volume (EaseVideoActor* self, double volume);
void ease_video_actor_set_filename (EaseVideoActor* self, const char* filename);
void ease_video_actor_set_playing (EaseVideoActor* self, gboolean playing);
void ease_video_actor_set_progress (EaseVideoActor* self, double progress);
void ease_video_actor_set_subtitle_font_name (EaseVideoActor* self, const char* font_name);
void ease_video_actor_set_subtitle_uri (EaseVideoActor* self, const char* uri);
void ease_video_actor_set_uri (EaseVideoActor* self, const char* uri);
EaseVideoElement* ease_video_element_new (void);
EaseVideoElement* ease_video_element_construct (GType object_type);
EaseZoomSlider* ease_zoom_slider_new (GtkAdjustment* adjustment, gint* button_values, int button_values_length1);
EaseZoomSlider* ease_zoom_slider_construct (GType object_type, GtkAdjustment* adjustment, gint* button_values, int button_values_length1);
double ease_zoom_slider_get_value (EaseZoomSlider* self);
void ease_zoom_slider_zoom_out (EaseZoomSlider* self);
void ease_zoom_slider_zoom_in (EaseZoomSlider* self);
void ease_zoom_slider_change_zoom (EaseZoomSlider* self, double value);
GtkPositionType ease_zoom_slider_get_value_pos (EaseZoomSlider* self);
void ease_zoom_slider_set_value_pos (EaseZoomSlider* self, GtkPositionType value);
gint ease_zoom_slider_get_digits (EaseZoomSlider* self);
void ease_zoom_slider_set_digits (EaseZoomSlider* self, gint value);
double ease_zoom_slider_get_sliderpos (EaseZoomSlider* self);
void ease_zoom_slider_set_sliderpos (EaseZoomSlider* self, double value);
gboolean ease_zoom_slider_get_buttons_shown (EaseZoomSlider* self);
void ease_zoom_slider_set_buttons_shown (EaseZoomSlider* self, gboolean value);

extern const EaseBackgroundType EASE_BACKGROUND_TYPE_TYPES[3];
extern const char* EASE_THEME_MASTER_SLIDES[4];

G_END_DECLS

#endif
